/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql;

import com.github.fabienbarbero.sql.SQLFaultException;
import com.github.fabienbarbero.sql.SQLRecord;
import com.github.fabienbarbero.sql.SQLRecordMapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class SQLIterator<T>
implements Iterator<T>,
AutoCloseable {
    private final ResultSet rs;
    private final SQLRecordMapper<T> mapper;
    private final PreparedStatement st;

    SQLIterator(ResultSet rs, PreparedStatement st, SQLRecordMapper<T> mapper) {
        this.rs = rs;
        this.st = st;
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.rs.next();
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting next entity", ex);
        }
    }

    @Override
    public T next() {
        return this.mapper.buildEntity(new SQLRecord(this.rs));
    }

    @Override
    public void remove() {
        try {
            this.rs.deleteRow();
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error deleting entity", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.rs.close();
            this.st.close();
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error closing SQL transaction", ex);
        }
    }
}

