/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql;

import com.github.fabienbarbero.sql.HasSQLConnection;
import com.github.fabienbarbero.sql.SQLFaultException;
import com.github.fabienbarbero.sql.SQLSavepoint;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class SQLTransaction
implements AutoCloseable,
HasSQLConnection {
    private final Connection conn;

    public static SQLTransaction begin(DataSource ds) {
        try {
            return SQLTransaction.begin(ds.getConnection(), false, null);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error begenning SQL transaction", ex);
        }
    }

    public static SQLTransaction begin(DataSource ds, boolean readOnly, IsolationLevel level) {
        try {
            return SQLTransaction.begin(ds.getConnection(), readOnly, level);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error begenning SQL transaction", ex);
        }
    }

    public static SQLTransaction begin(Connection conn) {
        return SQLTransaction.begin(conn, false, null);
    }

    public static SQLTransaction begin(Connection conn, boolean readOnly, IsolationLevel level) {
        try {
            conn.setAutoCommit(false);
            conn.setReadOnly(readOnly);
            if (level != null) {
                conn.setTransactionIsolation(level.value);
            }
            return new SQLTransaction(conn);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error begenning SQL transaction", ex);
        }
    }

    private SQLTransaction(Connection conn) {
        this.conn = conn;
    }

    public SQLSavepoint createSavepoint(String name) {
        try {
            return new SQLSavepoint(this.conn.setSavepoint(name), this.conn);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error creating SQL savepoint", ex);
        }
    }

    public void commit() throws SQLFaultException {
        try {
            this.conn.commit();
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error commiting SQL transaction", ex);
        }
    }

    public void rollback() throws SQLFaultException {
        try {
            this.conn.rollback();
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error rollbacking transaction", ex);
        }
    }

    @Override
    public void close() throws SQLFaultException {
        try {
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error closing SQL transaction", ex);
        }
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    public static enum IsolationLevel {
        READ_UNCOMMITTED(1),
        READ_COMMITTED(2),
        REPEATABLE_READ(4),
        SERIALIZABLE(8);

        private final int value;

        private IsolationLevel(int value) {
            this.value = value;
        }
    }
}

