/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;

public class SQLIndex {
    private final String name;
    private final String tableName;
    private final String columnName;
    private final Ordering ordering;

    SQLIndex(ResultSet rs) throws SQLException {
        this.name = rs.getString("INDEX_NAME");
        this.tableName = rs.getString("TABLE_NAME");
        this.columnName = rs.getString("COLUMN_NAME");
        this.ordering = Ordering.from(rs.getString("ASC_OR_DESC"));
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLIndex) {
            SQLIndex index = (SQLIndex)obj;
            return this.name.equals(index.name) && this.tableName.equals(index.tableName) && this.columnName.equals(index.columnName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.name);
        hash = 97 * hash + Objects.hashCode(this.tableName);
        hash = 97 * hash + Objects.hashCode(this.columnName);
        return hash;
    }

    public static enum Ordering {
        ASC("A"),
        DESC("D");

        private final String value;

        private Ordering(String value) {
            this.value = value;
        }

        private static Ordering from(String value) {
            return Arrays.stream(Ordering.values()).filter(o -> o.value.equals(value)).findFirst().orElse(null);
        }
    }
}

