/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql.helper;

import com.github.fabienbarbero.sql.helper.SQLColumn;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SQLTable {
    private final String name;
    private final List<SQLColumn> columns;

    SQLTable(String name, List<SQLColumn> columns) {
        this.name = name;
        this.columns = columns;
    }

    public List<SQLColumn> getColumns() {
        return this.columns;
    }

    public SQLColumn getColumn(String name) {
        return this.columns.stream().filter(col -> col.getName().equals(name)).findFirst().orElse(null);
    }

    public List<SQLColumn> getPrimaryColumns() {
        return this.columns.stream().filter(SQLColumn::isPrimary).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLTable) {
            SQLTable table = (SQLTable)obj;
            return this.name.equals(table.name);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Objects.hashCode(this.name);
        return hash;
    }
}

