/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql.migration;

import com.github.fabienbarbero.sql.SQLTransaction;
import com.github.fabienbarbero.sql.migration.MigrationContext;
import com.github.fabienbarbero.sql.migration.MigrationSkippedException;
import com.github.fabienbarbero.sql.migration.Migrator;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationManager.class);
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private final List<Migrator> migrators = new ArrayList<Migrator>();
    private final DataSource dataSource;

    public MigrationManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void register(Migrator migrator) {
        this.migrators.add(migrator);
    }

    public void execute(Mode migrationMode) throws Exception {
        Instant start = Instant.now();
        for (Migrator migrator : this.migrators) {
            try {
                SQLTransaction tx = SQLTransaction.begin(this.dataSource);
                Throwable throwable = null;
                try {
                    Instant migratorStart = Instant.now();
                    MigrationContext context = new MigrationContext(tx);
                    switch (migrationMode) {
                        case LIVE_BEFORE: {
                            migrator.migrateLiveBefore(context);
                            break;
                        }
                        case NORMAL: {
                            migrator.migrateNormal(context);
                            break;
                        }
                        case LIVE_AFTER: {
                            migrator.migrateLiveAfter(context);
                        }
                    }
                    tx.commit();
                    Instant migratorEnd = Instant.now();
                    LOGGER.info("\u001b[32mMigrator '{}' execution succeeded in {} seconds\u001b[0m", (Object)migrator.getName(), (Object)migratorStart.until(migratorEnd, ChronoUnit.SECONDS));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            catch (MigrationSkippedException ex) {
                LOGGER.info("\u001b[33mMigrator '{}' skipped\u001b[0m", (Object)migrator.getName());
            }
            catch (Exception ex) {
                LOGGER.error("\u001b[31mMigrator '{}' failed\u001b[0m", (Throwable)ex);
                throw ex;
            }
        }
        Instant end = Instant.now();
        LOGGER.info("\u001b[32mYippie !!! Migration succeeded in {} seconds\u001b[0m", (Object)start.until(end, ChronoUnit.SECONDS));
    }

    public static enum Mode {
        LIVE_BEFORE,
        NORMAL,
        LIVE_AFTER;

    }
}

