/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.javaclassversion;

import com.github.fracpete.javaclassversion.core.Info;
import com.github.fracpete.javaclassversion.core.Version;
import com.github.fracpete.javaclassversion.output.CSV;
import com.github.fracpete.javaclassversion.output.Summary;
import com.github.fracpete.javaclassversion.output.Text;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class ListClasses
implements Serializable {
    protected boolean m_Verbose;

    protected List<Info> list(String location) {
        ArrayList<Info> result = new ArrayList<Info>();
        return result;
    }

    public void setVerbose(boolean value) {
        this.m_Verbose = value;
    }

    public boolean isVerbose() {
        return this.m_Verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void list(List<Info> classes, File location) throws Exception {
        if (location.isDirectory()) {
            File[] files;
            if (this.isVerbose()) {
                System.err.println("Directory: " + location);
            }
            if ((files = location.listFiles()) == null) {
                System.err.println("Failed to list files/dirs in directory: " + location);
                return;
            }
            for (File file : files) {
                if (file.getName().equals(".") || file.getName().equals("..")) continue;
                this.list(classes, file);
            }
        } else if (location.isFile()) {
            if (location.getName().endsWith(".class")) {
                short version;
                if (this.isVerbose()) {
                    System.err.println("Class file: " + location);
                }
                if ((version = Version.fromFile((File)location)) > -1) {
                    classes.add(new Info(location.getParentFile().toURL(), location.getName(), version));
                }
            } else if (location.getName().toLowerCase().endsWith(".jar")) {
                if (this.isVerbose()) {
                    System.err.println("Jar file: " + location);
                }
                try (ZipFile zip = null;){
                    zip = new ZipFile(location);
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".class")) continue;
                        InputStream stream = zip.getInputStream(entry);
                        short version = Version.fromStream((InputStream)stream);
                        if (version > -1) {
                            classes.add(new Info(location.toURL(), entry.getName(), version));
                        }
                        stream.close();
                    }
                }
            } else if (this.isVerbose()) {
                System.err.println("Skipping: " + location);
            }
        }
    }

    public List<Info> list(List<String> locations) throws Exception {
        ArrayList<Info> result = new ArrayList<Info>();
        for (String location : locations) {
            this.list(result, new File(location));
        }
        return result;
    }

    public boolean execute(String[] options) throws Exception {
        boolean close;
        Writer writer;
        Text format;
        Namespace ns;
        ArgumentParser parser = ArgumentParsers.newFor((String)this.getClass().getName()).build().description("Listing Java class file versions.");
        parser.addArgument(new String[]{"--input"}).dest("input").required(true).action((ArgumentAction)Arguments.append()).help("The files or directories to inspect");
        parser.addArgument(new String[]{"--format"}).dest("format").required(false).setDefault((Object)"text").choices((Object[])new String[]{"text", "csv", "summary"}).help("The output format to use");
        parser.addArgument(new String[]{"--output"}).dest("output").required(false).help("The file to write the generated output to");
        parser.addArgument(new String[]{"--verbose"}).dest("verbose").action((ArgumentAction)Arguments.storeTrue()).help("Whether to be verbose during generation");
        try {
            ns = parser.parseArgs(options);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return false;
        }
        this.setVerbose(ns.getBoolean("verbose").booleanValue());
        switch (ns.getString("format")) {
            case "text": {
                format = new Text();
                break;
            }
            case "csv": {
                format = new CSV();
                break;
            }
            case "summary": {
                format = new Summary();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output: " + ns.getString("output"));
            }
        }
        List inputs = ns.getList("input");
        List classes = this.list(inputs);
        if (ns.getString("output") == null) {
            writer = new PrintWriter(System.out);
            close = false;
        } else {
            writer = new FileWriter(ns.getString("output"));
            close = true;
        }
        format.generate(classes, writer);
        if (close) {
            writer.close();
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        ListClasses l = new ListClasses();
        l.execute(args);
    }
}

