/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.javaclassversion.output;

import com.github.fracpete.javaclassversion.core.Info;
import com.github.fracpete.javaclassversion.core.Utils;
import com.github.fracpete.javaclassversion.output.AbstractOutputFormat;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class Text
extends AbstractOutputFormat {
    public static final String LOCATION = "Location";
    public static final String CLASS = "Class";
    public static final String VERSION = "Version";

    public void generate(List<Info> classes, Writer output) throws IOException {
        int lenLoc = 0;
        int lenName = 0;
        int lenVer = 0;
        for (Info cls : classes) {
            lenLoc = Math.max(lenLoc, cls.getLocation().toString().length());
            lenName = Math.max(lenName, cls.getClassname().length());
            lenVer = Math.max(lenVer, cls.getVersionText().length());
        }
        lenLoc = Math.max(lenLoc, LOCATION.length());
        lenName = Math.max(lenName, CLASS.length());
        lenVer = Math.max(lenVer, VERSION.length());
        Utils.padRight((Writer)output, (String)LOCATION, (int)lenLoc);
        output.write(" ");
        Utils.padRight((Writer)output, (String)CLASS, (int)lenName);
        output.write(" ");
        output.write(VERSION);
        output.write("\n");
        for (int i = 0; i < lenLoc + lenName + lenVer + 2; ++i) {
            output.write("-");
        }
        output.write("\n");
        for (Info cls : classes) {
            Utils.padRight((Writer)output, (String)cls.getLocation().toString(), (int)lenLoc);
            output.write(" ");
            Utils.padRight((Writer)output, (String)cls.getClassname(), (int)lenName);
            output.write(" ");
            output.write(cls.getVersionText());
            output.write("\n");
        }
        output.flush();
    }
}

