/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.javaclassversion.output;

import com.github.fracpete.javaclassversion.core.Info;
import com.github.fracpete.javaclassversion.core.Utils;
import com.github.fracpete.javaclassversion.output.AbstractOutputFormat;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;

public class Summary
extends AbstractOutputFormat {
    public static final String VERSION = "Version";
    public static final String COUNT = "Count";

    @Override
    public void generate(List<Info> classes, Writer output) throws IOException {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Info cls : classes) {
            if (!counts.containsKey(cls.getVersionText())) {
                counts.put(cls.getVersionText(), 0);
            }
            counts.put(cls.getVersionText(), (Integer)counts.get(cls.getVersionText()) + 1);
        }
        int lenVersion = 0;
        int lenCount = 0;
        for (String version : counts.keySet()) {
            lenVersion = Math.max(lenVersion, version.length());
            lenCount = Math.max(lenCount, ("" + counts.get(version)).length());
        }
        lenVersion = Math.max(lenVersion, VERSION.length());
        lenCount = Math.max(lenCount, COUNT.length());
        Utils.padRight(output, VERSION, lenVersion);
        output.write(" ");
        Utils.padRight(output, COUNT, lenCount);
        output.write("\n");
        for (int i = 0; i < lenVersion + lenCount + 1; ++i) {
            output.write("-");
        }
        output.write("\n");
        for (String version : counts.keySet()) {
            Utils.padRight(output, version, lenVersion);
            output.write(" ");
            Utils.padLeft(output, "" + counts.get(version), lenCount);
            output.write("\n");
        }
        output.flush();
    }
}

