/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.javautils.enumerate;

import com.github.fracpete.javautils.enumerate.Enumerated;
import java.io.Serializable;
import java.util.Iterator;

public class Enumerator<T>
implements Iterator<Enumerated<T>>,
Serializable {
    private static final long serialVersionUID = -3734546761287865157L;
    protected Iterator<T> m_Iterator;
    protected int m_Index;
    protected int m_Start;
    protected int m_Step;

    public Enumerator(Iterable<T> iterable) {
        this(iterable.iterator());
    }

    public Enumerator(Iterable<T> iterable, int start) {
        this(iterable.iterator(), start);
    }

    public Enumerator(Iterable<T> iterable, int start, int step) {
        this(iterable.iterator(), start, step);
    }

    public Enumerator(Iterator<T> iterator) {
        this(iterator, 0, 1);
    }

    public Enumerator(Iterator<T> iterator, int start) {
        this(iterator, start, 1);
    }

    public Enumerator(Iterator<T> iterator, int start, int step) {
        this.m_Iterator = iterator;
        this.m_Index = start;
        this.m_Start = start;
        this.m_Step = step;
    }

    public int getStart() {
        return this.m_Start;
    }

    public int getStep() {
        return this.m_Step;
    }

    @Override
    public boolean hasNext() {
        return this.m_Iterator.hasNext();
    }

    @Override
    public Enumerated<T> next() {
        Enumerated<T> result = new Enumerated<T>(this.m_Index, this.m_Iterator.next());
        this.m_Index += this.m_Step;
        return result;
    }

    public String toString() {
        return "start=" + this.m_Start + ", step=" + this.m_Step + ", index=" + this.m_Index;
    }
}

