/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.javautils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Reflection {
    public static Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> T newInstance(String cls, Class[] signature, Object[] values) throws Exception {
        return (T)Reflection.newInstance(Class.forName(cls), signature, values);
    }

    public static <T> T newInstance(Class<T> cls, Class[] signature, Object[] values) throws Exception {
        Constructor<T> constr = cls.getConstructor(signature);
        T result = constr.newInstance(values);
        return result;
    }

    public static <T> T function(Object obj, String method) throws Exception {
        return Reflection.function(obj, method, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public static <T> T function(Object obj, String method, Class[] signature, Object[] values) throws Exception {
        if (obj == null) {
            throw new IllegalStateException("No object provided!");
        }
        Method meth = obj.getClass().getMethod(method, signature);
        Object result = meth.invoke(obj, values);
        return (T)result;
    }

    public static void procedure(Object obj, String method) throws Exception {
        Reflection.procedure(obj, method, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public static void procedure(Object obj, String method, Class[] signature, Object[] values) throws Exception {
        if (obj == null) {
            throw new IllegalStateException("No object provided!");
        }
        Method meth = obj.getClass().getMethod(method, signature);
        meth.invoke(obj, values);
    }
}

