/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.javautils.enumerate;

import com.github.fracpete.javautils.enumerate.Enumerated;
import com.github.fracpete.javautils.enumerate.Enumerator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;

public class Enumeration<T>
implements Iterable<Enumerated<T>>,
Serializable {
    private static final long serialVersionUID = -6874019120085387575L;
    protected Iterator<T> m_Iterator;
    protected int m_Start;
    protected int m_Step;

    public Enumeration(Iterable<T> iterable) {
        this(iterable.iterator());
    }

    public Enumeration(Iterable<T> iterable, int start) {
        this(iterable.iterator(), start);
    }

    public Enumeration(Iterable<T> iterable, int start, int step) {
        this(iterable.iterator(), start, step);
    }

    public Enumeration(T[] array) {
        this(Arrays.asList(array).iterator());
    }

    public Enumeration(T[] array, int start) {
        this(Arrays.asList(array).iterator(), start);
    }

    public Enumeration(T[] array, int start, int step) {
        this(Arrays.asList(array).iterator(), start, step);
    }

    public Enumeration(Iterator<T> iterator) {
        this(iterator, 0, 1);
    }

    public Enumeration(Iterator<T> iterator, int start) {
        this(iterator, start, 1);
    }

    public Enumeration(Iterator<T> iterator, int start, int step) {
        this.m_Iterator = iterator;
        this.m_Start = start;
        this.m_Step = step;
    }

    @Override
    public Iterator<Enumerated<T>> iterator() {
        return new Enumerator<T>(this.m_Iterator, this.m_Start, this.m_Step);
    }

    public String toString() {
        return "start=" + this.m_Start + ", step=" + this.m_Step;
    }
}

