/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.DirectedEdge;
import edu.princeton.cs.algorithms.EdgeWeightedDigraph;
import edu.princeton.cs.algorithms.Stack;
import edu.princeton.cs.algorithms.Topological;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;

public class AcyclicLP {
    private double[] distTo;
    private DirectedEdge[] edgeTo;

    public AcyclicLP(EdgeWeightedDigraph G, int s) {
        this.distTo = new double[G.V()];
        this.edgeTo = new DirectedEdge[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            this.distTo[v] = Double.NEGATIVE_INFINITY;
        }
        this.distTo[s] = 0.0;
        Topological topological = new Topological(G);
        if (!topological.hasOrder()) {
            throw new IllegalArgumentException("Digraph is not acyclic.");
        }
        for (int v : topological.order()) {
            for (DirectedEdge e : G.adj(v)) {
                this.relax(e);
            }
        }
    }

    private void relax(DirectedEdge e) {
        int v = e.from();
        int w = e.to();
        if (this.distTo[w] < this.distTo[v] + e.weight()) {
            this.distTo[w] = this.distTo[v] + e.weight();
            this.edgeTo[w] = e;
        }
    }

    public double distTo(int v) {
        return this.distTo[v];
    }

    public boolean hasPathTo(int v) {
        return this.distTo[v] > Double.NEGATIVE_INFINITY;
    }

    public Iterable<DirectedEdge> pathTo(int v) {
        if (!this.hasPathTo(v)) {
            return null;
        }
        Stack<DirectedEdge> path = new Stack<DirectedEdge>();
        DirectedEdge e = this.edgeTo[v];
        while (e != null) {
            path.push(e);
            e = this.edgeTo[e.from()];
        }
        return path;
    }

    public static void main(String[] args) {
        In in = new In(args[0]);
        int s = Integer.parseInt(args[1]);
        EdgeWeightedDigraph G = new EdgeWeightedDigraph(in);
        AcyclicLP lp = new AcyclicLP(G, s);
        for (int v = 0; v < G.V(); ++v) {
            if (lp.hasPathTo(v)) {
                StdOut.printf((String)"%d to %d (%.2f)  ", (Object[])new Object[]{s, v, lp.distTo(v)});
                for (DirectedEdge e : lp.pathTo(v)) {
                    StdOut.print((Object)(e + "   "));
                }
                StdOut.println();
                continue;
            }
            StdOut.printf((String)"%d to %d         no path\n", (Object[])new Object[]{s, v});
        }
    }
}

