/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.BellmanFordSP;
import edu.princeton.cs.algorithms.DirectedEdge;
import edu.princeton.cs.algorithms.EdgeWeightedDigraph;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class Arbitrage {
    private Arbitrage() {
    }

    public static void main(String[] args) {
        int V = StdIn.readInt();
        String[] name = new String[V];
        EdgeWeightedDigraph G = new EdgeWeightedDigraph(V);
        for (int v = 0; v < V; ++v) {
            name[v] = StdIn.readString();
            for (int w = 0; w < V; ++w) {
                double rate = StdIn.readDouble();
                DirectedEdge e = new DirectedEdge(v, w, -Math.log(rate));
                G.addEdge(e);
            }
        }
        BellmanFordSP spt = new BellmanFordSP(G, 0);
        if (spt.hasNegativeCycle()) {
            double stake = 1000.0;
            for (DirectedEdge e : spt.negativeCycle()) {
                StdOut.printf((String)"%10.5f %s ", (Object[])new Object[]{stake, name[e.from()]});
                StdOut.printf((String)"= %10.5f %s\n", (Object[])new Object[]{stake *= Math.exp(-e.weight()), name[e.to()]});
            }
        } else {
            StdOut.println((Object)"No arbitrage opportunity");
        }
    }
}

