/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Queue;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.NoSuchElementException;

public class BinarySearchST<Key extends Comparable<Key>, Value> {
    private static final int INIT_CAPACITY = 2;
    private Key[] keys;
    private Value[] vals;
    private int N = 0;

    public BinarySearchST() {
        this(2);
    }

    public BinarySearchST(int capacity) {
        this.keys = new Comparable[capacity];
        this.vals = new Object[capacity];
    }

    private void resize(int capacity) {
        assert (capacity >= this.N);
        Comparable[] tempk = new Comparable[capacity];
        Object[] tempv = new Object[capacity];
        for (int i = 0; i < this.N; ++i) {
            tempk[i] = this.keys[i];
            tempv[i] = this.vals[i];
        }
        this.vals = tempv;
        this.keys = tempk;
    }

    public boolean contains(Key key) {
        return this.get(key) != null;
    }

    public int size() {
        return this.N;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Value get(Key key) {
        if (this.isEmpty()) {
            return null;
        }
        int i = this.rank(key);
        if (i < this.N && this.keys[i].compareTo(key) == 0) {
            return this.vals[i];
        }
        return null;
    }

    public int rank(Key key) {
        int lo = 0;
        int hi = this.N - 1;
        while (lo <= hi) {
            int m = lo + (hi - lo) / 2;
            int cmp = key.compareTo(this.keys[m]);
            if (cmp < 0) {
                hi = m - 1;
                continue;
            }
            if (cmp > 0) {
                lo = m + 1;
                continue;
            }
            return m;
        }
        return lo;
    }

    public void put(Key key, Value val) {
        if (val == null) {
            this.delete(key);
            return;
        }
        int i = this.rank(key);
        if (i < this.N && this.keys[i].compareTo(key) == 0) {
            this.vals[i] = val;
            return;
        }
        if (this.N == this.keys.length) {
            this.resize(2 * this.keys.length);
        }
        for (int j = this.N; j > i; --j) {
            this.keys[j] = this.keys[j - 1];
            this.vals[j] = this.vals[j - 1];
        }
        this.keys[i] = key;
        this.vals[i] = val;
        ++this.N;
        assert (this.check());
    }

    public void delete(Key key) {
        if (this.isEmpty()) {
            return;
        }
        int i = this.rank(key);
        if (i == this.N || this.keys[i].compareTo(key) != 0) {
            return;
        }
        for (int j = i; j < this.N - 1; ++j) {
            this.keys[j] = this.keys[j + 1];
            this.vals[j] = this.vals[j + 1];
        }
        --this.N;
        this.keys[this.N] = null;
        this.vals[this.N] = null;
        if (this.N > 0 && this.N == this.keys.length / 4) {
            this.resize(this.keys.length / 2);
        }
        assert (this.check());
    }

    public void deleteMin() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Symbol table underflow error");
        }
        this.delete(this.min());
    }

    public void deleteMax() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Symbol table underflow error");
        }
        this.delete(this.max());
    }

    public Key min() {
        if (this.isEmpty()) {
            return null;
        }
        return this.keys[0];
    }

    public Key max() {
        if (this.isEmpty()) {
            return null;
        }
        return this.keys[this.N - 1];
    }

    public Key select(int k) {
        if (k < 0 || k >= this.N) {
            return null;
        }
        return this.keys[k];
    }

    public Key floor(Key key) {
        int i = this.rank(key);
        if (i < this.N && key.compareTo(this.keys[i]) == 0) {
            return this.keys[i];
        }
        if (i == 0) {
            return null;
        }
        return this.keys[i - 1];
    }

    public Key ceiling(Key key) {
        int i = this.rank(key);
        if (i == this.N) {
            return null;
        }
        return this.keys[i];
    }

    public int size(Key lo, Key hi) {
        if (lo.compareTo(hi) > 0) {
            return 0;
        }
        if (this.contains(hi)) {
            return this.rank(hi) - this.rank(lo) + 1;
        }
        return this.rank(hi) - this.rank(lo);
    }

    public Iterable<Key> keys() {
        return this.keys(this.min(), this.max());
    }

    public Iterable<Key> keys(Key lo, Key hi) {
        Queue<Key> queue = new Queue<Key>();
        if (lo == null && hi == null) {
            return queue;
        }
        if (lo == null) {
            throw new NullPointerException("lo is null in keys()");
        }
        if (hi == null) {
            throw new NullPointerException("hi is null in keys()");
        }
        if (lo.compareTo(hi) > 0) {
            return queue;
        }
        for (int i = this.rank(lo); i < this.rank(hi); ++i) {
            queue.enqueue(this.keys[i]);
        }
        if (this.contains(hi)) {
            queue.enqueue(this.keys[this.rank(hi)]);
        }
        return queue;
    }

    private boolean check() {
        return this.isSorted() && this.rankCheck();
    }

    private boolean isSorted() {
        for (int i = 1; i < this.size(); ++i) {
            if (this.keys[i].compareTo(this.keys[i - 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    private boolean rankCheck() {
        int i;
        for (i = 0; i < this.size(); ++i) {
            if (i == this.rank(this.select(i))) continue;
            return false;
        }
        for (i = 0; i < this.size(); ++i) {
            if (this.keys[i].compareTo(this.select(this.rank(this.keys[i]))) == 0) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        BinarySearchST<String, Integer> st = new BinarySearchST<String, Integer>();
        int i = 0;
        while (!StdIn.isEmpty()) {
            String key = StdIn.readString();
            st.put(key, i);
            ++i;
        }
        for (String s : st.keys()) {
            StdOut.println((Object)(s + " " + st.get(s)));
        }
    }
}

