/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Graph;
import edu.princeton.cs.algorithms.Stack;
import edu.princeton.cs.introcs.StdOut;
import edu.princeton.cs.introcs.StdRandom;

public class Bipartite {
    private boolean isBipartite = true;
    private boolean[] color;
    private boolean[] marked;
    private int[] edgeTo;
    private Stack<Integer> cycle;

    public Bipartite(Graph G) {
        this.color = new boolean[G.V()];
        this.marked = new boolean[G.V()];
        this.edgeTo = new int[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            if (this.marked[v]) continue;
            this.dfs(G, v);
        }
        assert (this.check(G));
    }

    private void dfs(Graph G, int v) {
        this.marked[v] = true;
        for (int w : G.adj(v)) {
            if (this.cycle != null) {
                return;
            }
            if (!this.marked[w]) {
                this.edgeTo[w] = v;
                this.color[w] = !this.color[v];
                this.dfs(G, w);
                continue;
            }
            if (this.color[w] != this.color[v]) continue;
            this.isBipartite = false;
            this.cycle = new Stack();
            this.cycle.push(w);
            int x = v;
            while (x != w) {
                this.cycle.push(x);
                x = this.edgeTo[x];
            }
            this.cycle.push(w);
        }
    }

    public boolean isBipartite() {
        return this.isBipartite;
    }

    public boolean color(int v) {
        if (!this.isBipartite) {
            throw new UnsupportedOperationException("Graph is not bipartite");
        }
        return this.color[v];
    }

    public Iterable<Integer> oddCycle() {
        return this.cycle;
    }

    private boolean check(Graph G) {
        if (this.isBipartite) {
            for (int v = 0; v < G.V(); ++v) {
                for (int w : G.adj(v)) {
                    if (this.color[v] != this.color[w]) continue;
                    System.err.printf("edge %d-%d with %d and %d in same side of bipartition\n", v, w, v, w);
                    return false;
                }
            }
        } else {
            int first = -1;
            int last = -1;
            for (int v : this.oddCycle()) {
                if (first == -1) {
                    first = v;
                }
                last = v;
            }
            if (first != last) {
                System.err.printf("cycle begins with %d and ends with %d\n", first, last);
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        int w;
        int v;
        int i;
        int V = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        int F = Integer.parseInt(args[2]);
        Graph G = new Graph(V);
        int[] vertices = new int[V];
        for (i = 0; i < V; ++i) {
            vertices[i] = i;
        }
        StdRandom.shuffle((int[])vertices);
        for (i = 0; i < E; ++i) {
            v = StdRandom.uniform((int)(V / 2));
            w = StdRandom.uniform((int)(V / 2));
            G.addEdge(vertices[v], vertices[V / 2 + w]);
        }
        for (i = 0; i < F; ++i) {
            v = (int)(Math.random() * (double)V);
            w = (int)(Math.random() * (double)V);
            G.addEdge(v, w);
        }
        StdOut.println((Object)G);
        Bipartite b = new Bipartite(G);
        if (b.isBipartite()) {
            StdOut.println((Object)"Graph is bipartite");
            for (v = 0; v < G.V(); ++v) {
                StdOut.println((Object)(v + ": " + b.color(v)));
            }
        } else {
            StdOut.print((Object)"Graph has an odd-length cycle: ");
            for (int x : b.oddCycle()) {
                StdOut.print((Object)(x + " "));
            }
            StdOut.println();
        }
    }
}

