/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Graph;
import edu.princeton.cs.algorithms.Queue;
import edu.princeton.cs.algorithms.Stack;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;

public class BreadthFirstPaths {
    private static final int INFINITY = Integer.MAX_VALUE;
    private boolean[] marked;
    private int[] edgeTo;
    private int[] distTo;

    public BreadthFirstPaths(Graph G, int s) {
        this.marked = new boolean[G.V()];
        this.distTo = new int[G.V()];
        this.edgeTo = new int[G.V()];
        this.bfs(G, s);
        assert (this.check(G, s));
    }

    public BreadthFirstPaths(Graph G, Iterable<Integer> sources) {
        this.marked = new boolean[G.V()];
        this.distTo = new int[G.V()];
        this.edgeTo = new int[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            this.distTo[v] = Integer.MAX_VALUE;
        }
        this.bfs(G, sources);
    }

    private void bfs(Graph G, int s) {
        int v;
        Queue<Integer> q = new Queue<Integer>();
        for (v = 0; v < G.V(); ++v) {
            this.distTo[v] = Integer.MAX_VALUE;
        }
        this.distTo[s] = 0;
        this.marked[s] = true;
        q.enqueue(s);
        while (!q.isEmpty()) {
            v = (Integer)q.dequeue();
            for (int w : G.adj(v)) {
                if (this.marked[w]) continue;
                this.edgeTo[w] = v;
                this.distTo[w] = this.distTo[v] + 1;
                this.marked[w] = true;
                q.enqueue(w);
            }
        }
    }

    private void bfs(Graph G, Iterable<Integer> sources) {
        Queue<Integer> q = new Queue<Integer>();
        for (int s : sources) {
            this.marked[s] = true;
            this.distTo[s] = 0;
            q.enqueue(s);
        }
        while (!q.isEmpty()) {
            int v = (Integer)q.dequeue();
            for (int w : G.adj(v)) {
                if (this.marked[w]) continue;
                this.edgeTo[w] = v;
                this.distTo[w] = this.distTo[v] + 1;
                this.marked[w] = true;
                q.enqueue(w);
            }
        }
    }

    public boolean hasPathTo(int v) {
        return this.marked[v];
    }

    public int distTo(int v) {
        return this.distTo[v];
    }

    public Iterable<Integer> pathTo(int v) {
        if (!this.hasPathTo(v)) {
            return null;
        }
        Stack<Integer> path = new Stack<Integer>();
        int x = v;
        while (this.distTo[x] != 0) {
            path.push(x);
            x = this.edgeTo[x];
        }
        path.push(x);
        return path;
    }

    private boolean check(Graph G, int s) {
        if (this.distTo[s] != 0) {
            StdOut.println((Object)("distance of source " + s + " to itself = " + this.distTo[s]));
            return false;
        }
        for (int v = 0; v < G.V(); ++v) {
            for (int w : G.adj(v)) {
                if (this.hasPathTo(v) != this.hasPathTo(w)) {
                    StdOut.println((Object)("edge " + v + "-" + w));
                    StdOut.println((Object)("hasPathTo(" + v + ") = " + this.hasPathTo(v)));
                    StdOut.println((Object)("hasPathTo(" + w + ") = " + this.hasPathTo(w)));
                    return false;
                }
                if (!this.hasPathTo(v) || this.distTo[w] <= this.distTo[v] + 1) continue;
                StdOut.println((Object)("edge " + v + "-" + w));
                StdOut.println((Object)("distTo[" + v + "] = " + this.distTo[v]));
                StdOut.println((Object)("distTo[" + w + "] = " + this.distTo[w]));
                return false;
            }
        }
        for (int w = 0; w < G.V(); ++w) {
            int v;
            if (!this.hasPathTo(w) || w == s || this.distTo[w] == this.distTo[v = this.edgeTo[w]] + 1) continue;
            StdOut.println((Object)("shortest path edge " + v + "-" + w));
            StdOut.println((Object)("distTo[" + v + "] = " + this.distTo[v]));
            StdOut.println((Object)("distTo[" + w + "] = " + this.distTo[w]));
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        In in = new In(args[0]);
        Graph G = new Graph(in);
        int s = Integer.parseInt(args[1]);
        BreadthFirstPaths bfs = new BreadthFirstPaths(G, s);
        for (int v = 0; v < G.V(); ++v) {
            if (bfs.hasPathTo(v)) {
                StdOut.printf((String)"%d to %d (%d):  ", (Object[])new Object[]{s, v, bfs.distTo(v)});
                for (int x : bfs.pathTo(v)) {
                    if (x == s) {
                        StdOut.print((int)x);
                        continue;
                    }
                    StdOut.print((Object)("-" + x));
                }
                StdOut.println();
                continue;
            }
            StdOut.printf((String)"%d to %d (-):  not connected\n", (Object[])new Object[]{s, v});
        }
    }
}

