/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.AcyclicLP;
import edu.princeton.cs.algorithms.DirectedEdge;
import edu.princeton.cs.algorithms.EdgeWeightedDigraph;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class CPM {
    private CPM() {
    }

    public static void main(String[] args) {
        int N = StdIn.readInt();
        int source = 2 * N;
        int sink = 2 * N + 1;
        EdgeWeightedDigraph G = new EdgeWeightedDigraph(2 * N + 2);
        for (int i = 0; i < N; ++i) {
            double duration = StdIn.readDouble();
            G.addEdge(new DirectedEdge(source, i, 0.0));
            G.addEdge(new DirectedEdge(i + N, sink, 0.0));
            G.addEdge(new DirectedEdge(i, i + N, duration));
            int M = StdIn.readInt();
            for (int j = 0; j < M; ++j) {
                int precedent = StdIn.readInt();
                G.addEdge(new DirectedEdge(N + i, precedent, 0.0));
            }
        }
        AcyclicLP lp = new AcyclicLP(G, source);
        StdOut.println((Object)" job   start  finish");
        StdOut.println((Object)"--------------------");
        for (int i = 0; i < N; ++i) {
            StdOut.printf((String)"%4d %7.1f %7.1f\n", (Object[])new Object[]{i, lp.distTo(i), lp.distTo(i + N)});
        }
        StdOut.printf((String)"Finish time: %7.1f\n", (Object[])new Object[]{lp.distTo(sink)});
    }
}

