/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdOut;
import edu.princeton.cs.introcs.StdRandom;

public class Counter
implements Comparable<Counter> {
    private final String name;
    private int count;

    public Counter(String id) {
        this.name = id;
    }

    public void increment() {
        ++this.count;
    }

    public int tally() {
        return this.count;
    }

    public String toString() {
        return this.count + " " + this.name;
    }

    @Override
    public int compareTo(Counter that) {
        if (this.count < that.count) {
            return -1;
        }
        if (this.count > that.count) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        int i;
        int N = Integer.parseInt(args[0]);
        int T = Integer.parseInt(args[1]);
        Counter[] hits = new Counter[N];
        for (i = 0; i < N; ++i) {
            hits[i] = new Counter("counter" + i);
        }
        for (int t = 0; t < T; ++t) {
            hits[StdRandom.uniform((int)N)].increment();
        }
        for (i = 0; i < N; ++i) {
            StdOut.println((Object)hits[i]);
        }
    }
}

