/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.GrahamScan;
import edu.princeton.cs.algorithms.Point2D;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class FarthestPair {
    private Point2D best1;
    private Point2D best2;
    private double bestDistance = Double.NEGATIVE_INFINITY;

    public FarthestPair(Point2D[] points) {
        GrahamScan graham = new GrahamScan(points);
        if (points.length <= 1) {
            return;
        }
        int M = 0;
        for (Point2D p : graham.hull()) {
            ++M;
        }
        Point2D[] hull = new Point2D[M + 1];
        int m = 1;
        for (Point2D p : graham.hull()) {
            hull[m++] = p;
        }
        if (M == 1) {
            return;
        }
        if (M == 2) {
            this.best1 = hull[1];
            this.best2 = hull[2];
            this.bestDistance = this.best1.distanceTo(this.best2);
            return;
        }
        int k = 2;
        while (Point2D.area2(hull[M], hull[k + 1], hull[1]) > Point2D.area2(hull[M], hull[k], hull[1])) {
            ++k;
        }
        int j = k;
        for (int i = 1; i <= k; ++i) {
            if (hull[i].distanceTo(hull[j]) > this.bestDistance) {
                this.best1 = hull[i];
                this.best2 = hull[j];
                this.bestDistance = hull[i].distanceTo(hull[j]);
            }
            while (j < M && Point2D.area2(hull[i], hull[j + 1], hull[i + 1]) > Point2D.area2(hull[i], hull[j], hull[i + 1])) {
                double distance;
                if (!((distance = hull[i].distanceTo(hull[++j])) > this.bestDistance)) continue;
                this.best1 = hull[i];
                this.best2 = hull[j];
                this.bestDistance = hull[i].distanceTo(hull[j]);
            }
        }
    }

    public Point2D either() {
        return this.best1;
    }

    public Point2D other() {
        return this.best2;
    }

    public double distance() {
        return this.bestDistance;
    }

    public static void main(String[] args) {
        int N = StdIn.readInt();
        Point2D[] points = new Point2D[N];
        for (int i = 0; i < N; ++i) {
            int x = StdIn.readInt();
            int y = StdIn.readInt();
            points[i] = new Point2D(x, y);
        }
        FarthestPair farthest = new FarthestPair(points);
        StdOut.println((Object)(farthest.distance() + " from " + farthest.either() + " to " + farthest.other()));
    }
}

