/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Bag;
import edu.princeton.cs.algorithms.FlowEdge;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;
import edu.princeton.cs.introcs.StdRandom;

public class FlowNetwork {
    private final int V;
    private int E;
    private Bag<FlowEdge>[] adj;

    public FlowNetwork(int V) {
        if (V < 0) {
            throw new IllegalArgumentException("Number of vertices in a Graph must be nonnegative");
        }
        this.V = V;
        this.E = 0;
        this.adj = new Bag[V];
        for (int v = 0; v < V; ++v) {
            this.adj[v] = new Bag();
        }
    }

    public FlowNetwork(int V, int E) {
        this(V);
        if (E < 0) {
            throw new IllegalArgumentException("Number of edges must be nonnegative");
        }
        for (int i = 0; i < E; ++i) {
            int v = StdRandom.uniform((int)V);
            int w = StdRandom.uniform((int)V);
            double capacity = StdRandom.uniform((int)100);
            this.addEdge(new FlowEdge(v, w, capacity));
        }
    }

    public FlowNetwork(In in) {
        this(in.readInt());
        int E = in.readInt();
        if (E < 0) {
            throw new IllegalArgumentException("Number of edges must be nonnegative");
        }
        for (int i = 0; i < E; ++i) {
            int v = in.readInt();
            int w = in.readInt();
            if (v < 0 || v >= this.V) {
                throw new IndexOutOfBoundsException("vertex " + v + " is not between 0 and " + (this.V - 1));
            }
            if (w < 0 || w >= this.V) {
                throw new IndexOutOfBoundsException("vertex " + w + " is not between 0 and " + (this.V - 1));
            }
            double capacity = in.readDouble();
            this.addEdge(new FlowEdge(v, w, capacity));
        }
    }

    public int V() {
        return this.V;
    }

    public int E() {
        return this.E;
    }

    public void addEdge(FlowEdge e) {
        int v = e.from();
        int w = e.to();
        if (v < 0 || v >= this.V) {
            throw new IndexOutOfBoundsException("vertex " + v + " is not between 0 and " + (this.V - 1));
        }
        if (w < 0 || w >= this.V) {
            throw new IndexOutOfBoundsException("vertex " + w + " is not between 0 and " + (this.V - 1));
        }
        this.adj[v].add(e);
        this.adj[w].add(e);
        ++this.E;
    }

    public Iterable<FlowEdge> adj(int v) {
        if (v < 0 || v >= this.V) {
            throw new IndexOutOfBoundsException("vertex " + v + " is not between 0 and " + (this.V - 1));
        }
        return this.adj[v];
    }

    public Iterable<FlowEdge> edges() {
        Bag<FlowEdge> list = new Bag<FlowEdge>();
        for (int v = 0; v < this.V; ++v) {
            for (FlowEdge e : this.adj(v)) {
                if (e.to() == v) continue;
                list.add(e);
            }
        }
        return list;
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder();
        s.append(this.V + " " + this.E + NEWLINE);
        for (int v = 0; v < this.V; ++v) {
            s.append(v + ":  ");
            for (FlowEdge e : this.adj[v]) {
                if (e.to() == v) continue;
                s.append(e + "  ");
            }
            s.append(NEWLINE);
        }
        return s.toString();
    }

    public static void main(String[] args) {
        In in = new In(args[0]);
        FlowNetwork G = new FlowNetwork(in);
        StdOut.println((Object)G);
    }
}

