/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.AdjMatrixEdgeWeightedDigraph;
import edu.princeton.cs.algorithms.DirectedEdge;
import edu.princeton.cs.algorithms.EdgeWeightedDigraph;
import edu.princeton.cs.algorithms.EdgeWeightedDirectedCycle;
import edu.princeton.cs.algorithms.Stack;
import edu.princeton.cs.introcs.StdOut;

public class FloydWarshall {
    private boolean hasNegativeCycle;
    private double[][] distTo;
    private DirectedEdge[][] edgeTo;

    public FloydWarshall(AdjMatrixEdgeWeightedDigraph G) {
        int v;
        int V = G.V();
        this.distTo = new double[V][V];
        this.edgeTo = new DirectedEdge[V][V];
        for (v = 0; v < V; ++v) {
            for (int w = 0; w < V; ++w) {
                this.distTo[v][w] = Double.POSITIVE_INFINITY;
            }
        }
        for (v = 0; v < G.V(); ++v) {
            for (DirectedEdge e : G.adj(v)) {
                this.distTo[e.from()][e.to()] = e.weight();
                this.edgeTo[e.from()][e.to()] = e;
            }
            if (!(this.distTo[v][v] >= 0.0)) continue;
            this.distTo[v][v] = 0.0;
            this.edgeTo[v][v] = null;
        }
        for (int i = 0; i < V; ++i) {
            for (int v2 = 0; v2 < V; ++v2) {
                if (this.edgeTo[v2][i] == null) continue;
                for (int w = 0; w < V; ++w) {
                    if (!(this.distTo[v2][w] > this.distTo[v2][i] + this.distTo[i][w])) continue;
                    this.distTo[v2][w] = this.distTo[v2][i] + this.distTo[i][w];
                    this.edgeTo[v2][w] = this.edgeTo[i][w];
                }
                if (!(this.distTo[v2][v2] < 0.0)) continue;
                this.hasNegativeCycle = true;
                return;
            }
        }
    }

    public boolean hasNegativeCycle() {
        return this.hasNegativeCycle;
    }

    public Iterable<DirectedEdge> negativeCycle() {
        for (int v = 0; v < this.distTo.length; ++v) {
            if (!(this.distTo[v][v] < 0.0)) continue;
            int V = this.edgeTo.length;
            EdgeWeightedDigraph spt = new EdgeWeightedDigraph(V);
            for (int w = 0; w < V; ++w) {
                if (this.edgeTo[v][w] == null) continue;
                spt.addEdge(this.edgeTo[v][w]);
            }
            EdgeWeightedDirectedCycle finder = new EdgeWeightedDirectedCycle(spt);
            assert (finder.hasCycle());
            return finder.cycle();
        }
        return null;
    }

    public boolean hasPath(int s, int t) {
        return this.distTo[s][t] < Double.POSITIVE_INFINITY;
    }

    public double dist(int s, int t) {
        if (this.hasNegativeCycle()) {
            throw new UnsupportedOperationException("Negative cost cycle exists");
        }
        return this.distTo[s][t];
    }

    public Iterable<DirectedEdge> path(int s, int t) {
        if (this.hasNegativeCycle()) {
            throw new UnsupportedOperationException("Negative cost cycle exists");
        }
        if (!this.hasPath(s, t)) {
            return null;
        }
        Stack<DirectedEdge> path = new Stack<DirectedEdge>();
        DirectedEdge e = this.edgeTo[s][t];
        while (e != null) {
            path.push(e);
            e = this.edgeTo[s][e.from()];
        }
        return path;
    }

    private boolean check(EdgeWeightedDigraph G, int s) {
        if (!this.hasNegativeCycle()) {
            for (int v = 0; v < G.V(); ++v) {
                for (DirectedEdge e : G.adj(v)) {
                    int w = e.to();
                    for (int i = 0; i < G.V(); ++i) {
                        if (!(this.distTo[i][w] > this.distTo[i][v] + e.weight())) continue;
                        System.err.println("edge " + e + " is eligible");
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static void main(String[] args) {
        int w;
        int v;
        int V = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        AdjMatrixEdgeWeightedDigraph G = new AdjMatrixEdgeWeightedDigraph(V);
        for (int i = 0; i < E; ++i) {
            v = (int)((double)V * Math.random());
            w = (int)((double)V * Math.random());
            double weight = (double)Math.round(100.0 * (Math.random() - 0.15)) / 100.0;
            if (v == w) {
                G.addEdge(new DirectedEdge(v, w, Math.abs(weight)));
                continue;
            }
            G.addEdge(new DirectedEdge(v, w, weight));
        }
        StdOut.println((Object)G);
        FloydWarshall spt = new FloydWarshall(G);
        StdOut.printf((String)"  ", (Object[])new Object[0]);
        for (v = 0; v < G.V(); ++v) {
            StdOut.printf((String)"%6d ", (Object[])new Object[]{v});
        }
        StdOut.println();
        for (v = 0; v < G.V(); ++v) {
            StdOut.printf((String)"%3d: ", (Object[])new Object[]{v});
            for (w = 0; w < G.V(); ++w) {
                if (spt.hasPath(v, w)) {
                    StdOut.printf((String)"%6.2f ", (Object[])new Object[]{spt.dist(v, w)});
                    continue;
                }
                StdOut.printf((String)"  Inf ", (Object[])new Object[0]);
            }
            StdOut.println();
        }
        if (spt.hasNegativeCycle()) {
            StdOut.println((Object)"Negative cost cycle:");
            for (DirectedEdge e : spt.negativeCycle()) {
                StdOut.println((Object)e);
            }
            StdOut.println();
        } else {
            for (v = 0; v < G.V(); ++v) {
                for (w = 0; w < G.V(); ++w) {
                    if (spt.hasPath(v, w)) {
                        StdOut.printf((String)"%d to %d (%5.2f)  ", (Object[])new Object[]{v, w, spt.dist(v, w)});
                        for (DirectedEdge e : spt.path(v, w)) {
                            StdOut.print((Object)(e + "  "));
                        }
                        StdOut.println();
                        continue;
                    }
                    StdOut.printf((String)"%d to %d no path\n", (Object[])new Object[]{v, w});
                }
            }
        }
    }
}

