/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdOut;
import java.util.Arrays;
import java.util.Comparator;

public class Interval1D {
    public static final Comparator<Interval1D> LEFT_ENDPOINT_ORDER = new LeftComparator();
    public static final Comparator<Interval1D> RIGHT_ENDPOINT_ORDER = new RightComparator();
    public static final Comparator<Interval1D> LENGTH_ORDER = new LengthComparator();
    private final double left;
    private final double right;

    public Interval1D(double left, double right) {
        if (Double.isInfinite(left) || Double.isInfinite(right)) {
            throw new IllegalArgumentException("Endpoints must be finite");
        }
        if (Double.isNaN(left) || Double.isNaN(right)) {
            throw new IllegalArgumentException("Endpoints cannot be NaN");
        }
        if (!(left <= right)) {
            throw new IllegalArgumentException("Illegal interval");
        }
        this.left = left;
        this.right = right;
    }

    public double left() {
        return this.left;
    }

    public double right() {
        return this.right;
    }

    public boolean intersects(Interval1D that) {
        if (this.right < that.left) {
            return false;
        }
        return !(that.right < this.left);
    }

    public boolean contains(double x) {
        return this.left <= x && x <= this.right;
    }

    public double length() {
        return this.right - this.left;
    }

    public String toString() {
        return "[" + this.left + ", " + this.right + "]";
    }

    public static void main(String[] args) {
        int i;
        Interval1D[] intervals = new Interval1D[]{new Interval1D(15.0, 33.0), new Interval1D(45.0, 60.0), new Interval1D(20.0, 70.0), new Interval1D(46.0, 55.0)};
        StdOut.println((Object)"Unsorted");
        for (i = 0; i < intervals.length; ++i) {
            StdOut.println((Object)intervals[i]);
        }
        StdOut.println();
        StdOut.println((Object)"Sort by left endpoint");
        Arrays.sort(intervals, LEFT_ENDPOINT_ORDER);
        for (i = 0; i < intervals.length; ++i) {
            StdOut.println((Object)intervals[i]);
        }
        StdOut.println();
        StdOut.println((Object)"Sort by right endpoint");
        Arrays.sort(intervals, RIGHT_ENDPOINT_ORDER);
        for (i = 0; i < intervals.length; ++i) {
            StdOut.println((Object)intervals[i]);
        }
        StdOut.println();
        StdOut.println((Object)"Sort by length");
        Arrays.sort(intervals, LENGTH_ORDER);
        for (i = 0; i < intervals.length; ++i) {
            StdOut.println((Object)intervals[i]);
        }
        StdOut.println();
    }

    private static class LengthComparator
    implements Comparator<Interval1D> {
        private LengthComparator() {
        }

        @Override
        public int compare(Interval1D a, Interval1D b) {
            double blen;
            double alen = a.length();
            if (alen < (blen = b.length())) {
                return -1;
            }
            if (alen > blen) {
                return 1;
            }
            return 0;
        }
    }

    private static class RightComparator
    implements Comparator<Interval1D> {
        private RightComparator() {
        }

        @Override
        public int compare(Interval1D a, Interval1D b) {
            if (a.right < b.right) {
                return -1;
            }
            if (a.right > b.right) {
                return 1;
            }
            if (a.left < b.left) {
                return -1;
            }
            if (a.left > b.left) {
                return 1;
            }
            return 0;
        }
    }

    private static class LeftComparator
    implements Comparator<Interval1D> {
        private LeftComparator() {
        }

        @Override
        public int compare(Interval1D a, Interval1D b) {
            if (a.left < b.left) {
                return -1;
            }
            if (a.left > b.left) {
                return 1;
            }
            if (a.right < b.right) {
                return -1;
            }
            if (a.right > b.right) {
                return 1;
            }
            return 0;
        }
    }
}

