/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdOut;

public class KMP {
    private final int R;
    private int[][] dfa;
    private char[] pattern;
    private String pat;

    public KMP(String pat) {
        this.R = 256;
        this.pat = pat;
        int M = pat.length();
        this.dfa = new int[this.R][M];
        this.dfa[pat.charAt((int)0)][0] = 1;
        int X = 0;
        for (int j = 1; j < M; ++j) {
            for (int c = 0; c < this.R; ++c) {
                this.dfa[c][j] = this.dfa[c][X];
            }
            this.dfa[pat.charAt((int)j)][j] = j + 1;
            X = this.dfa[pat.charAt(j)][X];
        }
    }

    public KMP(char[] pattern, int R) {
        this.R = R;
        this.pattern = new char[pattern.length];
        for (int j = 0; j < pattern.length; ++j) {
            this.pattern[j] = pattern[j];
        }
        int M = pattern.length;
        this.dfa = new int[R][M];
        this.dfa[pattern[0]][0] = 1;
        int X = 0;
        for (int j = 1; j < M; ++j) {
            for (int c = 0; c < R; ++c) {
                this.dfa[c][j] = this.dfa[c][X];
            }
            this.dfa[pattern[j]][j] = j + 1;
            X = this.dfa[pattern[j]][X];
        }
    }

    public int search(String txt) {
        int i;
        int M = this.pat.length();
        int N = txt.length();
        int j = 0;
        for (i = 0; i < N && j < M; ++i) {
            j = this.dfa[txt.charAt(i)][j];
        }
        if (j == M) {
            return i - M;
        }
        return N;
    }

    public int search(char[] text) {
        int i;
        int M = this.pattern.length;
        int N = text.length;
        int j = 0;
        for (i = 0; i < N && j < M; ++i) {
            j = this.dfa[text[i]][j];
        }
        if (j == M) {
            return i - M;
        }
        return N;
    }

    public static void main(String[] args) {
        int i;
        String pat = args[0];
        String txt = args[1];
        char[] pattern = pat.toCharArray();
        char[] text = txt.toCharArray();
        KMP kmp1 = new KMP(pat);
        int offset1 = kmp1.search(txt);
        KMP kmp2 = new KMP(pattern, 256);
        int offset2 = kmp2.search(text);
        StdOut.println((Object)("text:    " + txt));
        StdOut.print((Object)"pattern: ");
        for (i = 0; i < offset1; ++i) {
            StdOut.print((Object)" ");
        }
        StdOut.println((Object)pat);
        StdOut.print((Object)"pattern: ");
        for (i = 0; i < offset2; ++i) {
            StdOut.print((Object)" ");
        }
        StdOut.println((Object)pat);
    }
}

