/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.DepthFirstOrder;
import edu.princeton.cs.algorithms.Digraph;
import edu.princeton.cs.algorithms.Queue;
import edu.princeton.cs.algorithms.TransitiveClosure;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;

public class KosarajuSharirSCC {
    private boolean[] marked;
    private int[] id;
    private int count;

    public KosarajuSharirSCC(Digraph G) {
        DepthFirstOrder dfs = new DepthFirstOrder(G.reverse());
        this.marked = new boolean[G.V()];
        this.id = new int[G.V()];
        for (int v : dfs.reversePost()) {
            if (this.marked[v]) continue;
            this.dfs(G, v);
            ++this.count;
        }
        assert (this.check(G));
    }

    private void dfs(Digraph G, int v) {
        this.marked[v] = true;
        this.id[v] = this.count;
        for (int w : G.adj(v)) {
            if (this.marked[w]) continue;
            this.dfs(G, w);
        }
    }

    public int count() {
        return this.count;
    }

    public boolean stronglyConnected(int v, int w) {
        return this.id[v] == this.id[w];
    }

    public int id(int v) {
        return this.id[v];
    }

    private boolean check(Digraph G) {
        TransitiveClosure tc = new TransitiveClosure(G);
        for (int v = 0; v < G.V(); ++v) {
            for (int w = 0; w < G.V(); ++w) {
                if (this.stronglyConnected(v, w) == (tc.reachable(v, w) && tc.reachable(w, v))) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        int i;
        In in = new In(args[0]);
        Digraph G = new Digraph(in);
        KosarajuSharirSCC scc = new KosarajuSharirSCC(G);
        int M = scc.count();
        StdOut.println((Object)(M + " components"));
        Queue[] components = new Queue[M];
        for (i = 0; i < M; ++i) {
            components[i] = new Queue();
        }
        for (int v = 0; v < G.V(); ++v) {
            components[scc.id(v)].enqueue(v);
        }
        for (i = 0; i < M; ++i) {
            Iterator iterator = components[i].iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                StdOut.print((Object)(v + " "));
            }
            StdOut.println();
        }
    }
}

