/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

public class LinearRegression {
    private final int N;
    private final double alpha;
    private final double beta;
    private final double R2;
    private final double svar;
    private final double svar0;
    private final double svar1;

    public LinearRegression(double[] x, double[] y) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException("array lengths are not equal");
        }
        this.N = x.length;
        double sumx = 0.0;
        double sumy = 0.0;
        double sumx2 = 0.0;
        for (i = 0; i < this.N; ++i) {
            sumx += x[i];
        }
        for (i = 0; i < this.N; ++i) {
            sumx2 += x[i] * x[i];
        }
        for (i = 0; i < this.N; ++i) {
            sumy += y[i];
        }
        double xbar = sumx / (double)this.N;
        double ybar = sumy / (double)this.N;
        double xxbar = 0.0;
        double yybar = 0.0;
        double xybar = 0.0;
        for (int i2 = 0; i2 < this.N; ++i2) {
            xxbar += (x[i2] - xbar) * (x[i2] - xbar);
            yybar += (y[i2] - ybar) * (y[i2] - ybar);
            xybar += (x[i2] - xbar) * (y[i2] - ybar);
        }
        this.beta = xybar / xxbar;
        this.alpha = ybar - this.beta * xbar;
        double rss = 0.0;
        double ssr = 0.0;
        for (int i3 = 0; i3 < this.N; ++i3) {
            double fit = this.beta * x[i3] + this.alpha;
            rss += (fit - y[i3]) * (fit - y[i3]);
            ssr += (fit - ybar) * (fit - ybar);
        }
        int degreesOfFreedom = this.N - 2;
        this.R2 = ssr / yybar;
        this.svar = rss / (double)degreesOfFreedom;
        this.svar1 = this.svar / xxbar;
        this.svar0 = this.svar / (double)this.N + xbar * xbar * this.svar1;
    }

    public double intercept() {
        return this.alpha;
    }

    public double slope() {
        return this.beta;
    }

    public double R2() {
        return this.R2;
    }

    public double interceptStdErr() {
        return Math.sqrt(this.svar0);
    }

    public double slopeStdErr() {
        return Math.sqrt(this.svar1);
    }

    public double predict(double x) {
        return this.beta * x + this.alpha;
    }

    public String toString() {
        String s = "";
        s = s + String.format("%.2f N + %.2f", this.slope(), this.intercept());
        return s + "  (R^2 = " + String.format("%.3f", this.R2()) + ")";
    }
}

