/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class MSD {
    private static final int R = 256;
    private static final int CUTOFF = 15;

    public static void sort(String[] a) {
        int N = a.length;
        String[] aux = new String[N];
        MSD.sort(a, 0, N - 1, 0, aux);
    }

    private static int charAt(String s, int d) {
        assert (d >= 0 && d <= s.length());
        if (d == s.length()) {
            return -1;
        }
        return s.charAt(d);
    }

    private static void sort(String[] a, int lo, int hi, int d, String[] aux) {
        int r;
        int c;
        int i;
        if (hi <= lo + 15) {
            MSD.insertion(a, lo, hi, d);
            return;
        }
        int[] count = new int[258];
        for (i = lo; i <= hi; ++i) {
            c = MSD.charAt(a[i], d);
            int n = c + 2;
            count[n] = count[n] + 1;
        }
        for (r = 0; r < 257; ++r) {
            int n = r + 1;
            count[n] = count[n] + count[r];
        }
        for (i = lo; i <= hi; ++i) {
            c = MSD.charAt(a[i], d);
            int n = c + 1;
            int n2 = count[n];
            count[n] = n2 + 1;
            aux[n2] = a[i];
        }
        for (i = lo; i <= hi; ++i) {
            a[i] = aux[i - lo];
        }
        for (r = 0; r < 256; ++r) {
            MSD.sort(a, lo + count[r], lo + count[r + 1] - 1, d + 1, aux);
        }
    }

    private static void insertion(String[] a, int lo, int hi, int d) {
        for (int i = lo; i <= hi; ++i) {
            for (int j = i; j > lo && MSD.less(a[j], a[j - 1], d); --j) {
                MSD.exch(a, j, j - 1);
            }
        }
    }

    private static void exch(String[] a, int i, int j) {
        String temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    private static boolean less(String v, String w, int d) {
        assert (v.substring(0, d).equals(w.substring(0, d)));
        for (int i = d; i < Math.min(v.length(), w.length()); ++i) {
            if (v.charAt(i) < w.charAt(i)) {
                return true;
            }
            if (v.charAt(i) <= w.charAt(i)) continue;
            return false;
        }
        return v.length() < w.length();
    }

    public static void main(String[] args) {
        String[] a = StdIn.readAllStrings();
        int N = a.length;
        MSD.sort(a);
        for (int i = 0; i < N; ++i) {
            StdOut.println((Object)a[i]);
        }
    }
}

