/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import Jama.Matrix;
import Jama.QRDecomposition;
import edu.princeton.cs.introcs.StdOut;

public class PolynomialRegression {
    private final int N;
    private final int degree;
    private final Matrix beta;
    private double SSE;
    private double SST;

    public PolynomialRegression(double[] x, double[] y, int degree) {
        this.degree = degree;
        this.N = x.length;
        double[][] vandermonde = new double[this.N][degree + 1];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j <= degree; ++j) {
                vandermonde[i][j] = Math.pow(x[i], j);
            }
        }
        Matrix X = new Matrix(vandermonde);
        Matrix Y = new Matrix(y, this.N);
        QRDecomposition qr = new QRDecomposition(X);
        this.beta = qr.solve(Y);
        double sum = 0.0;
        for (int i = 0; i < this.N; ++i) {
            sum += y[i];
        }
        double mean = sum / (double)this.N;
        for (int i = 0; i < this.N; ++i) {
            double dev = y[i] - mean;
            this.SST += dev * dev;
        }
        Matrix residuals = X.times(this.beta).minus(Y);
        this.SSE = residuals.norm2() * residuals.norm2();
    }

    public double beta(int j) {
        return this.beta.get(j, 0);
    }

    public int degree() {
        return this.degree;
    }

    public double R2() {
        if (this.SST == 0.0) {
            return 1.0;
        }
        return 1.0 - this.SSE / this.SST;
    }

    public double predict(double x) {
        double y = 0.0;
        for (int j = this.degree; j >= 0; --j) {
            y = this.beta(j) + x * y;
        }
        return y;
    }

    public String toString() {
        int j;
        String s = "";
        for (j = this.degree; j >= 0 && Math.abs(this.beta(j)) < 1.0E-5; --j) {
        }
        while (j >= 0) {
            s = j == 0 ? s + String.format("%.2f ", this.beta(j)) : (j == 1 ? s + String.format("%.2f N + ", this.beta(j)) : s + String.format("%.2f N^%d + ", this.beta(j), j));
            --j;
        }
        return s + "  (R^2 = " + String.format("%.3f", this.R2()) + ")";
    }

    public static void main(String[] args) {
        double[] x = new double[]{10.0, 20.0, 40.0, 80.0, 160.0, 200.0};
        double[] y = new double[]{100.0, 350.0, 1500.0, 6700.0, 20160.0, 40000.0};
        PolynomialRegression regression = new PolynomialRegression(x, y, 3);
        StdOut.println((Object)regression);
    }
}

