/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Comparator;

public class Selection {
    private Selection() {
    }

    public static void sort(Comparable[] a) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            int min = i;
            for (int j = i + 1; j < N; ++j) {
                if (!Selection.less(a[j], a[min])) continue;
                min = j;
            }
            Selection.exch(a, i, min);
            assert (Selection.isSorted(a, 0, i));
        }
        assert (Selection.isSorted(a));
    }

    public static void sort(Object[] a, Comparator c) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            int min = i;
            for (int j = i + 1; j < N; ++j) {
                if (!Selection.less(c, a[j], a[min])) continue;
                min = j;
            }
            Selection.exch(a, i, min);
            assert (Selection.isSorted(a, c, 0, i));
        }
        assert (Selection.isSorted(a, c));
    }

    private static boolean less(Comparable v, Comparable w) {
        return v.compareTo(w) < 0;
    }

    private static boolean less(Comparator c, Object v, Object w) {
        return c.compare(v, w) < 0;
    }

    private static void exch(Object[] a, int i, int j) {
        Object swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }

    private static boolean isSorted(Comparable[] a) {
        return Selection.isSorted(a, 0, a.length - 1);
    }

    private static boolean isSorted(Comparable[] a, int lo, int hi) {
        for (int i = lo + 1; i <= hi; ++i) {
            if (!Selection.less(a[i], a[i - 1])) continue;
            return false;
        }
        return true;
    }

    private static boolean isSorted(Object[] a, Comparator c) {
        return Selection.isSorted(a, c, 0, a.length - 1);
    }

    private static boolean isSorted(Object[] a, Comparator c, int lo, int hi) {
        for (int i = lo + 1; i <= hi; ++i) {
            if (!Selection.less(c, a[i], a[i - 1])) continue;
            return false;
        }
        return true;
    }

    private static void show(Comparable[] a) {
        for (int i = 0; i < a.length; ++i) {
            StdOut.println((Object)a[i]);
        }
    }

    public static void main(String[] args) {
        String[] a = StdIn.readAllStrings();
        Selection.sort((Comparable[])a);
        Selection.show((Comparable[])a);
    }
}

