/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdOut;
import edu.princeton.cs.introcs.StdRandom;

public class Simplex {
    private static final double EPSILON = 1.0E-10;
    private double[][] a;
    private int M;
    private int N;
    private int[] basis;

    public Simplex(double[][] A, double[] b, double[] c) {
        int i;
        this.M = b.length;
        this.N = c.length;
        this.a = new double[this.M + 1][this.N + this.M + 1];
        for (i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.a[i][j] = A[i][j];
            }
        }
        for (i = 0; i < this.M; ++i) {
            this.a[i][this.N + i] = 1.0;
        }
        for (int j = 0; j < this.N; ++j) {
            this.a[this.M][j] = c[j];
        }
        for (i = 0; i < this.M; ++i) {
            this.a[i][this.M + this.N] = b[i];
        }
        this.basis = new int[this.M];
        for (i = 0; i < this.M; ++i) {
            this.basis[i] = this.N + i;
        }
        this.solve();
        assert (this.check(A, b, c));
    }

    private void solve() {
        int q;
        while ((q = this.bland()) != -1) {
            int p = this.minRatioRule(q);
            if (p == -1) {
                throw new ArithmeticException("Linear program is unbounded");
            }
            this.pivot(p, q);
            this.basis[p] = q;
        }
    }

    private int bland() {
        for (int j = 0; j < this.M + this.N; ++j) {
            if (!(this.a[this.M][j] > 0.0)) continue;
            return j;
        }
        return -1;
    }

    private int dantzig() {
        int q = 0;
        for (int j = 1; j < this.M + this.N; ++j) {
            if (!(this.a[this.M][j] > this.a[this.M][q])) continue;
            q = j;
        }
        if (this.a[this.M][q] <= 0.0) {
            return -1;
        }
        return q;
    }

    private int minRatioRule(int q) {
        int p = -1;
        for (int i = 0; i < this.M; ++i) {
            if (this.a[i][q] <= 0.0) continue;
            if (p == -1) {
                p = i;
                continue;
            }
            if (!(this.a[i][this.M + this.N] / this.a[i][q] < this.a[p][this.M + this.N] / this.a[p][q])) continue;
            p = i;
        }
        return p;
    }

    private void pivot(int p, int q) {
        int i;
        for (i = 0; i <= this.M; ++i) {
            for (int j = 0; j <= this.M + this.N; ++j) {
                if (i == p || j == q) continue;
                double[] dArray = this.a[i];
                int n = j;
                dArray[n] = dArray[n] - this.a[p][j] * this.a[i][q] / this.a[p][q];
            }
        }
        for (i = 0; i <= this.M; ++i) {
            if (i == p) continue;
            this.a[i][q] = 0.0;
        }
        for (int j = 0; j <= this.M + this.N; ++j) {
            if (j == q) continue;
            double[] dArray = this.a[p];
            int n = j;
            dArray[n] = dArray[n] / this.a[p][q];
        }
        this.a[p][q] = 1.0;
    }

    public double value() {
        return -this.a[this.M][this.M + this.N];
    }

    public double[] primal() {
        double[] x = new double[this.N];
        for (int i = 0; i < this.M; ++i) {
            if (this.basis[i] >= this.N) continue;
            x[this.basis[i]] = this.a[i][this.M + this.N];
        }
        return x;
    }

    public double[] dual() {
        double[] y = new double[this.M];
        for (int i = 0; i < this.M; ++i) {
            y[i] = -this.a[this.M][this.N + i];
        }
        return y;
    }

    private boolean isPrimalFeasible(double[][] A, double[] b) {
        double[] x = this.primal();
        for (int j = 0; j < x.length; ++j) {
            if (!(x[j] < 0.0)) continue;
            StdOut.println((Object)("x[" + j + "] = " + x[j] + " is negative"));
            return false;
        }
        for (int i = 0; i < this.M; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.N; ++j) {
                sum += A[i][j] * x[j];
            }
            if (!(sum > b[i] + 1.0E-10)) continue;
            StdOut.println((Object)"not primal feasible");
            StdOut.println((Object)("b[" + i + "] = " + b[i] + ", sum = " + sum));
            return false;
        }
        return true;
    }

    private boolean isDualFeasible(double[][] A, double[] c) {
        double[] y = this.dual();
        for (int i = 0; i < y.length; ++i) {
            if (!(y[i] < 0.0)) continue;
            StdOut.println((Object)("y[" + i + "] = " + y[i] + " is negative"));
            return false;
        }
        for (int j = 0; j < this.N; ++j) {
            double sum = 0.0;
            for (int i = 0; i < this.M; ++i) {
                sum += A[i][j] * y[i];
            }
            if (!(sum < c[j] - 1.0E-10)) continue;
            StdOut.println((Object)"not dual feasible");
            StdOut.println((Object)("c[" + j + "] = " + c[j] + ", sum = " + sum));
            return false;
        }
        return true;
    }

    private boolean isOptimal(double[] b, double[] c) {
        double[] x = this.primal();
        double[] y = this.dual();
        double value = this.value();
        double value1 = 0.0;
        for (int j = 0; j < x.length; ++j) {
            value1 += c[j] * x[j];
        }
        double value2 = 0.0;
        for (int i = 0; i < y.length; ++i) {
            value2 += y[i] * b[i];
        }
        if (Math.abs(value - value1) > 1.0E-10 || Math.abs(value - value2) > 1.0E-10) {
            StdOut.println((Object)("value = " + value + ", cx = " + value1 + ", yb = " + value2));
            return false;
        }
        return true;
    }

    private boolean check(double[][] A, double[] b, double[] c) {
        return this.isPrimalFeasible(A, b) && this.isDualFeasible(A, c) && this.isOptimal(b, c);
    }

    public void show() {
        int i;
        StdOut.println((Object)("M = " + this.M));
        StdOut.println((Object)("N = " + this.N));
        for (i = 0; i <= this.M; ++i) {
            for (int j = 0; j <= this.M + this.N; ++j) {
                StdOut.printf((String)"%7.2f ", (Object[])new Object[]{this.a[i][j]});
            }
            StdOut.println();
        }
        StdOut.println((Object)("value = " + this.value()));
        for (i = 0; i < this.M; ++i) {
            if (this.basis[i] >= this.N) continue;
            StdOut.println((Object)("x_" + this.basis[i] + " = " + this.a[i][this.M + this.N]));
        }
        StdOut.println();
    }

    public static void test(double[][] A, double[] b, double[] c) {
        Simplex lp = new Simplex(A, b, c);
        StdOut.println((Object)("value = " + lp.value()));
        double[] x = lp.primal();
        for (int i = 0; i < x.length; ++i) {
            StdOut.println((Object)("x[" + i + "] = " + x[i]));
        }
        double[] y = lp.dual();
        for (int j = 0; j < y.length; ++j) {
            StdOut.println((Object)("y[" + j + "] = " + y[j]));
        }
    }

    public static void test1() {
        double[][] A = new double[][]{{-1.0, 1.0, 0.0}, {1.0, 4.0, 0.0}, {2.0, 1.0, 0.0}, {3.0, -4.0, 0.0}, {0.0, 0.0, 1.0}};
        double[] c = new double[]{1.0, 1.0, 1.0};
        double[] b = new double[]{5.0, 45.0, 27.0, 24.0, 4.0};
        Simplex.test(A, b, c);
    }

    public static void test2() {
        double[] c = new double[]{13.0, 23.0};
        double[] b = new double[]{480.0, 160.0, 1190.0};
        double[][] A = new double[][]{{5.0, 15.0}, {4.0, 4.0}, {35.0, 20.0}};
        Simplex.test(A, b, c);
    }

    public static void test3() {
        double[] c = new double[]{2.0, 3.0, -1.0, -12.0};
        double[] b = new double[]{3.0, 2.0};
        double[][] A = new double[][]{{-2.0, -9.0, 1.0, 9.0}, {1.0, 1.0, -1.0, -2.0}};
        Simplex.test(A, b, c);
    }

    public static void test4() {
        double[] c = new double[]{10.0, -57.0, -9.0, -24.0};
        double[] b = new double[]{0.0, 0.0, 1.0};
        double[][] A = new double[][]{{0.5, -5.5, -2.5, 9.0}, {0.5, -1.5, -0.5, 1.0}, {1.0, 0.0, 0.0, 0.0}};
        Simplex.test(A, b, c);
    }

    public static void main(String[] args) {
        int i;
        try {
            Simplex.test1();
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
        }
        StdOut.println((Object)"--------------------------------");
        try {
            Simplex.test2();
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
        }
        StdOut.println((Object)"--------------------------------");
        try {
            Simplex.test3();
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
        }
        StdOut.println((Object)"--------------------------------");
        try {
            Simplex.test4();
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
        }
        StdOut.println((Object)"--------------------------------");
        int M = Integer.parseInt(args[0]);
        int N = Integer.parseInt(args[1]);
        double[] c = new double[N];
        double[] b = new double[M];
        double[][] A = new double[M][N];
        for (int j = 0; j < N; ++j) {
            c[j] = StdRandom.uniform((int)1000);
        }
        for (i = 0; i < M; ++i) {
            b[i] = StdRandom.uniform((int)1000);
        }
        for (i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                A[i][j] = StdRandom.uniform((int)100);
            }
        }
        Simplex lp = new Simplex(A, b, c);
        StdOut.println((double)lp.value());
    }
}

