/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.ST;
import edu.princeton.cs.introcs.StdOut;

public class SparseVector {
    private int N;
    private ST<Integer, Double> st;

    public SparseVector(int N) {
        this.N = N;
        this.st = new ST();
    }

    public void put(int i, double value) {
        if (i < 0 || i >= this.N) {
            throw new IndexOutOfBoundsException("Illegal index");
        }
        if (value == 0.0) {
            this.st.delete(i);
        } else {
            this.st.put(i, value);
        }
    }

    public double get(int i) {
        if (i < 0 || i >= this.N) {
            throw new IndexOutOfBoundsException("Illegal index");
        }
        if (this.st.contains(i)) {
            return this.st.get(i);
        }
        return 0.0;
    }

    public int nnz() {
        return this.st.size();
    }

    public int size() {
        return this.N;
    }

    public double dot(SparseVector that) {
        if (this.N != that.N) {
            throw new IllegalArgumentException("Vector lengths disagree");
        }
        double sum = 0.0;
        if (this.st.size() <= that.st.size()) {
            for (int i : this.st.keys()) {
                if (!that.st.contains(i)) continue;
                sum += this.get(i) * that.get(i);
            }
        } else {
            for (int i : that.st.keys()) {
                if (!this.st.contains(i)) continue;
                sum += this.get(i) * that.get(i);
            }
        }
        return sum;
    }

    public double dot(double[] that) {
        double sum = 0.0;
        for (int i : this.st.keys()) {
            sum += that[i] * this.get(i);
        }
        return sum;
    }

    public double norm() {
        SparseVector a = this;
        return Math.sqrt(a.dot(a));
    }

    public SparseVector scale(double alpha) {
        SparseVector c = new SparseVector(this.N);
        for (int i : this.st.keys()) {
            c.put(i, alpha * this.get(i));
        }
        return c;
    }

    public SparseVector plus(SparseVector that) {
        if (this.N != that.N) {
            throw new IllegalArgumentException("Vector lengths disagree");
        }
        SparseVector c = new SparseVector(this.N);
        for (int i : this.st.keys()) {
            c.put(i, this.get(i));
        }
        for (int i : that.st.keys()) {
            c.put(i, that.get(i) + c.get(i));
        }
        return c;
    }

    public String toString() {
        String s = "";
        for (int i : this.st.keys()) {
            s = s + "(" + i + ", " + this.st.get(i) + ") ";
        }
        return s;
    }

    public static void main(String[] args) {
        SparseVector a = new SparseVector(10);
        SparseVector b = new SparseVector(10);
        a.put(3, 0.5);
        a.put(9, 0.75);
        a.put(6, 0.11);
        a.put(6, 0.0);
        b.put(3, 0.6);
        b.put(4, 0.9);
        StdOut.println((Object)("a = " + a));
        StdOut.println((Object)("b = " + b));
        StdOut.println((Object)("a dot b = " + a.dot(b)));
        StdOut.println((Object)("a + b   = " + a.plus(b)));
    }
}

