/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Digraph;
import edu.princeton.cs.algorithms.ST;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class SymbolDigraph {
    private ST<String, Integer> st = new ST();
    private String[] keys;
    private Digraph G;

    public SymbolDigraph(String filename, String delimiter) {
        Object a;
        In in = new In(filename);
        while (in.hasNextLine()) {
            a = in.readLine().split(delimiter);
            for (int i = 0; i < ((String[])a).length; ++i) {
                if (this.st.contains((String)a[i])) continue;
                this.st.put((String)a[i], this.st.size());
            }
        }
        this.keys = new String[this.st.size()];
        a = this.st.keys().iterator();
        while (a.hasNext()) {
            String name;
            this.keys[this.st.get((String)name).intValue()] = name = (String)a.next();
        }
        this.G = new Digraph(this.st.size());
        in = new In(filename);
        while (in.hasNextLine()) {
            a = in.readLine().split(delimiter);
            int v = this.st.get((String)a[0]);
            for (int i = 1; i < ((Object)a).length; ++i) {
                int w = this.st.get((String)a[i]);
                this.G.addEdge(v, w);
            }
        }
    }

    public boolean contains(String s) {
        return this.st.contains(s);
    }

    public int index(String s) {
        return this.st.get(s);
    }

    public String name(int v) {
        return this.keys[v];
    }

    public Digraph G() {
        return this.G;
    }

    public static void main(String[] args) {
        String filename = args[0];
        String delimiter = args[1];
        SymbolDigraph sg = new SymbolDigraph(filename, delimiter);
        Digraph G = sg.G();
        while (!StdIn.isEmpty()) {
            String t = StdIn.readLine();
            for (int v : G.adj(sg.index(t))) {
                StdOut.println((Object)("   " + sg.name(v)));
            }
        }
    }
}

