/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class WeightedQuickUnionUF {
    private int[] id;
    private int[] sz;
    private int count;

    public WeightedQuickUnionUF(int N) {
        this.count = N;
        this.id = new int[N];
        this.sz = new int[N];
        for (int i = 0; i < N; ++i) {
            this.id[i] = i;
            this.sz[i] = 1;
        }
    }

    public int count() {
        return this.count;
    }

    public int find(int p) {
        while (p != this.id[p]) {
            p = this.id[p];
        }
        return p;
    }

    public boolean connected(int p, int q) {
        return this.find(p) == this.find(q);
    }

    public void union(int p, int q) {
        int rootQ;
        int rootP = this.find(p);
        if (rootP == (rootQ = this.find(q))) {
            return;
        }
        if (this.sz[rootP] < this.sz[rootQ]) {
            this.id[rootP] = rootQ;
            int n = rootQ;
            this.sz[n] = this.sz[n] + this.sz[rootP];
        } else {
            this.id[rootQ] = rootP;
            int n = rootP;
            this.sz[n] = this.sz[n] + this.sz[rootQ];
        }
        --this.count;
    }

    public static void main(String[] args) {
        int N = StdIn.readInt();
        WeightedQuickUnionUF uf = new WeightedQuickUnionUF(N);
        while (!StdIn.isEmpty()) {
            int q;
            int p = StdIn.readInt();
            if (uf.connected(p, q = StdIn.readInt())) continue;
            uf.union(p, q);
            StdOut.println((Object)(p + " " + q));
        }
        StdOut.println((Object)(uf.count() + " components"));
    }
}

