/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.introcs;

import edu.princeton.cs.introcs.BinaryStdOut;
import java.io.BufferedInputStream;
import java.io.IOException;

public final class BinaryStdIn {
    private static BufferedInputStream in = new BufferedInputStream(System.in);
    private static final int EOF = -1;
    private static int buffer;
    private static int N;

    private BinaryStdIn() {
    }

    private static void fillBuffer() {
        try {
            buffer = in.read();
            N = 8;
        }
        catch (IOException e) {
            System.out.println("EOF");
            buffer = -1;
            N = -1;
        }
    }

    public static void close() {
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not close BinaryStdIn");
        }
    }

    public static boolean isEmpty() {
        return buffer == -1;
    }

    public static boolean readBoolean() {
        boolean bit;
        if (BinaryStdIn.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        boolean bl = bit = (buffer >> --N & 1) == 1;
        if (N == 0) {
            BinaryStdIn.fillBuffer();
        }
        return bit;
    }

    public static char readChar() {
        if (BinaryStdIn.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        if (N == 8) {
            int x = buffer;
            BinaryStdIn.fillBuffer();
            return (char)(x & 0xFF);
        }
        int x = buffer;
        x <<= 8 - N;
        int oldN = N;
        BinaryStdIn.fillBuffer();
        if (BinaryStdIn.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        N = oldN;
        return (char)((x |= buffer >>> N) & 0xFF);
    }

    public static char readChar(int r) {
        if (r < 1 || r > 16) {
            throw new RuntimeException("Illegal value of r = " + r);
        }
        if (r == 8) {
            return BinaryStdIn.readChar();
        }
        char x = '\u0000';
        for (int i = 0; i < r; ++i) {
            x = (char)(x << 1);
            boolean bit = BinaryStdIn.readBoolean();
            if (!bit) continue;
            x = (char)(x | '\u0001');
        }
        return x;
    }

    public static String readString() {
        if (BinaryStdIn.isEmpty()) {
            throw new RuntimeException("Reading from empty input stream");
        }
        StringBuilder sb = new StringBuilder();
        while (!BinaryStdIn.isEmpty()) {
            char c = BinaryStdIn.readChar();
            sb.append(c);
        }
        return sb.toString();
    }

    public static short readShort() {
        short x = 0;
        for (int i = 0; i < 2; ++i) {
            char c = BinaryStdIn.readChar();
            x = (short)(x << 8);
            x = (short)(x | c);
        }
        return x;
    }

    public static int readInt() {
        int x = 0;
        for (int i = 0; i < 4; ++i) {
            char c = BinaryStdIn.readChar();
            x <<= 8;
            x |= c;
        }
        return x;
    }

    public static int readInt(int r) {
        if (r < 1 || r > 32) {
            throw new RuntimeException("Illegal value of r = " + r);
        }
        if (r == 32) {
            return BinaryStdIn.readInt();
        }
        int x = 0;
        for (int i = 0; i < r; ++i) {
            x <<= 1;
            boolean bit = BinaryStdIn.readBoolean();
            if (!bit) continue;
            x |= 1;
        }
        return x;
    }

    public static long readLong() {
        long x = 0L;
        for (int i = 0; i < 8; ++i) {
            char c = BinaryStdIn.readChar();
            x <<= 8;
            x |= (long)c;
        }
        return x;
    }

    public static double readDouble() {
        return Double.longBitsToDouble(BinaryStdIn.readLong());
    }

    public static float readFloat() {
        return Float.intBitsToFloat(BinaryStdIn.readInt());
    }

    public static byte readByte() {
        char c = BinaryStdIn.readChar();
        byte x = (byte)(c & 0xFF);
        return x;
    }

    public static void main(String[] args) {
        while (!BinaryStdIn.isEmpty()) {
            char c = BinaryStdIn.readChar();
            BinaryStdOut.write(c);
        }
        BinaryStdOut.flush();
    }

    static {
        BinaryStdIn.fillBuffer();
    }
}

