/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.introcs;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class Picture
implements ActionListener {
    private BufferedImage image;
    private JFrame frame;
    private String filename;
    private boolean isOriginUpperLeft = true;
    private final int width;
    private final int height;

    public Picture(int w, int h) {
        if (w < 0) {
            throw new IllegalArgumentException("width must be nonnegative");
        }
        if (h < 0) {
            throw new IllegalArgumentException("height must be nonnegative");
        }
        this.width = w;
        this.height = h;
        this.image = new BufferedImage(w, h, 1);
        this.filename = w + "-by-" + h;
    }

    public Picture(Picture pic) {
        this.width = pic.width();
        this.height = pic.height();
        this.image = new BufferedImage(this.width, this.height, 1);
        this.filename = pic.filename;
        for (int x = 0; x < this.width(); ++x) {
            for (int y = 0; y < this.height(); ++y) {
                this.image.setRGB(x, y, pic.get(x, y).getRGB());
            }
        }
    }

    public Picture(String filename) {
        this.filename = filename;
        try {
            File file = new File(filename);
            if (file.isFile()) {
                this.image = ImageIO.read(file);
            } else {
                URL url = this.getClass().getResource(filename);
                if (url == null) {
                    url = new URL(filename);
                }
                this.image = ImageIO.read(url);
            }
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open file: " + filename);
        }
    }

    public Picture(File file) {
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not open file: " + file);
        }
        if (this.image == null) {
            throw new RuntimeException("Invalid image file: " + file);
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.filename = file.getName();
    }

    public JLabel getJLabel() {
        if (this.image == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(this.image);
        return new JLabel(icon);
    }

    public void setOriginUpperLeft() {
        this.isOriginUpperLeft = true;
    }

    public void setOriginLowerLeft() {
        this.isOriginUpperLeft = false;
    }

    public void show() {
        if (this.frame == null) {
            this.frame = new JFrame();
            JMenuBar menuBar = new JMenuBar();
            JMenu menu = new JMenu("File");
            menuBar.add(menu);
            JMenuItem menuItem1 = new JMenuItem(" Save...   ");
            menuItem1.addActionListener(this);
            menuItem1.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            menu.add(menuItem1);
            this.frame.setJMenuBar(menuBar);
            this.frame.setContentPane(this.getJLabel());
            this.frame.setDefaultCloseOperation(2);
            this.frame.setTitle(this.filename);
            this.frame.setResizable(false);
            this.frame.pack();
            this.frame.setVisible(true);
        }
        this.frame.repaint();
    }

    public int height() {
        return this.height;
    }

    public int width() {
        return this.width;
    }

    public Color get(int x, int y) {
        if (x < 0 || x >= this.width()) {
            throw new IndexOutOfBoundsException("x must be between 0 and " + (this.width() - 1));
        }
        if (y < 0 || y >= this.height()) {
            throw new IndexOutOfBoundsException("y must be between 0 and " + (this.height() - 1));
        }
        if (this.isOriginUpperLeft) {
            return new Color(this.image.getRGB(x, y));
        }
        return new Color(this.image.getRGB(x, this.height - y - 1));
    }

    public void set(int x, int y, Color color) {
        if (x < 0 || x >= this.width()) {
            throw new IndexOutOfBoundsException("x must be between 0 and " + (this.width() - 1));
        }
        if (y < 0 || y >= this.height()) {
            throw new IndexOutOfBoundsException("y must be between 0 and " + (this.height() - 1));
        }
        if (color == null) {
            throw new NullPointerException("can't set Color to null");
        }
        if (this.isOriginUpperLeft) {
            this.image.setRGB(x, y, color.getRGB());
        } else {
            this.image.setRGB(x, this.height - y - 1, color.getRGB());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Picture that = (Picture)obj;
        if (this.width() != that.width()) {
            return false;
        }
        if (this.height() != that.height()) {
            return false;
        }
        for (int x = 0; x < this.width(); ++x) {
            for (int y = 0; y < this.height(); ++y) {
                if (this.get(x, y).equals(that.get(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public void save(String name) {
        this.save(new File(name));
    }

    public void save(File file) {
        this.filename = file.getName();
        if (this.frame != null) {
            this.frame.setTitle(this.filename);
        }
        String suffix = this.filename.substring(this.filename.lastIndexOf(46) + 1);
        if ((suffix = suffix.toLowerCase()).equals("jpg") || suffix.equals("png")) {
            try {
                ImageIO.write((RenderedImage)this.image, suffix, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Error: filename must end in .jpg or .png");
        }
    }

    public void actionPerformed(ActionEvent e) {
        FileDialog chooser = new FileDialog((Frame)this.frame, "Use a .png or .jpg extension", 1);
        chooser.setVisible(true);
        if (chooser.getFile() != null) {
            this.save(chooser.getDirectory() + File.separator + chooser.getFile());
        }
    }

    public static void main(String[] args) {
        Picture pic = new Picture(args[0]);
        System.out.printf("%d-by-%d\n", pic.width(), pic.height());
        pic.show();
    }
}

