/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.introcs;

import com.sun.j3d.loaders.lw3d.Lw3dLoader;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.scenegraph.io.SceneGraphFileReader;
import com.sun.j3d.utils.scenegraph.io.SceneGraphFileWriter;
import com.sun.j3d.utils.scenegraph.io.UnsupportedUniverseException;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BackgroundSound;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.LinearFog;
import javax.media.j3d.Material;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Raster;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.View;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public final class StdDraw3D
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
ActionListener,
ChangeListener,
ComponentListener,
WindowFocusListener {
    public static final Color BLACK = Color.BLACK;
    public static final Color BLUE = Color.BLUE;
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color GRAY = Color.GRAY;
    public static final Color GREEN = Color.GREEN;
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color RED = Color.RED;
    public static final Color WHITE = Color.WHITE;
    public static final Color YELLOW = Color.YELLOW;
    public static final int ORBIT_MODE = 0;
    public static final int FPS_MODE = 1;
    public static final int AIRPLANE_MODE = 2;
    public static final int LOOK_MODE = 3;
    public static final int FIXED_MODE = 4;
    public static final int IMMERSIVE_MODE = 5;
    private static JFrame frame;
    private static Panel canvasPanel;
    private static JMenuBar menuBar;
    private static JMenu fileMenu;
    private static JMenu cameraMenu;
    private static JMenu graphicsMenu;
    private static JMenuItem loadButton;
    private static JMenuItem saveButton;
    private static JMenuItem save3DButton;
    private static JMenuItem quitButton;
    private static JSpinner fovSpinner;
    private static JRadioButtonMenuItem orbitModeButton;
    private static JRadioButtonMenuItem fpsModeButton;
    private static JRadioButtonMenuItem airplaneModeButton;
    private static JRadioButtonMenuItem lookModeButton;
    private static JRadioButtonMenuItem fixedModeButton;
    private static JRadioButtonMenuItem perspectiveButton;
    private static JRadioButtonMenuItem parallelButton;
    private static JCheckBoxMenuItem antiAliasingButton;
    private static JSpinner numDivSpinner;
    private static JCheckBox infoCheckBox;
    private static SimpleUniverse universe;
    private static BranchGroup rootGroup;
    private static BranchGroup lightGroup;
    private static BranchGroup soundGroup;
    private static BranchGroup fogGroup;
    private static BranchGroup appearanceGroup;
    private static BranchGroup onscreenGroup;
    private static BranchGroup offscreenGroup;
    private static OrbitBehavior orbit;
    private static Background background;
    private static Group bgGroup;
    private static View view;
    private static Canvas3D canvas;
    private static Camera camera;
    private static BufferedImage offscreenImage;
    private static BufferedImage onscreenImage;
    private static BufferedImage infoImage;
    private static int width;
    private static int height;
    private static double aspectRatio;
    private static int cameraMode;
    private static Point3d orbitCenter;
    private static double min;
    private static double max;
    private static double zoom;
    private static Color bgColor;
    private static Color penColor;
    private static float penRadius;
    private static Font font;
    private static boolean clear3D;
    private static boolean clearOverlay;
    private static boolean infoDisplay;
    private static int numDivisions;
    private static boolean mouse1;
    private static boolean mouse2;
    private static boolean mouse3;
    private static double mouseX;
    private static double mouseY;
    private static TreeSet<Integer> keysDown;
    private static LinkedList<Character> keysTyped;
    private static Object mouseLock;
    private static Object keyLock;
    private static boolean initialized;
    private static boolean fullscreen;
    private static boolean immersive;
    private static boolean showedOnce;
    private static boolean renderedOnce;
    private static final int DEFAULT_SIZE = 600;
    private static final double DEFAULT_MIN = 0.0;
    private static final double DEFAULT_MAX = 1.0;
    private static final int DEFAULT_CAMERA_MODE = 0;
    private static final double DEFAULT_FOV = 0.9;
    private static final int DEFAULT_NUM_DIVISIONS = 100;
    private static final double DEFAULT_FRONT_CLIP = 0.01;
    private static final double DEFAULT_BACK_CLIP = 10.0;
    private static final Font DEFAULT_FONT;
    private static final double DEFAULT_PEN_RADIUS = 0.002;
    private static final Color DEFAULT_PEN_COLOR;
    private static final Color DEFAULT_BGCOLOR;
    private static final double TEXT3D_SHRINK_FACTOR = 0.005;
    private static final double TEXT3D_DEPTH = 1.5;
    private static final int PRIMFLAGS = 3;
    private static final BoundingSphere INFINITE_BOUNDS;
    private static final Vector3D xAxis;
    private static final Vector3D yAxis;
    private static final Vector3D zAxis;
    private static StdDraw3D std;

    private StdDraw3D() {
    }

    private static void initialize() {
        numDivisions = 100;
        onscreenImage = StdDraw3D.createBufferedImage();
        offscreenImage = StdDraw3D.createBufferedImage();
        infoImage = StdDraw3D.createBufferedImage();
        StdDraw3D.initializeCanvas();
        if (frame != null) {
            frame.setVisible(false);
        }
        frame = new JFrame();
        frame.setVisible(false);
        frame.setResizable(fullscreen);
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Standard Draw 3D");
        frame.add(canvasPanel);
        frame.setJMenuBar(StdDraw3D.createMenuBar());
        frame.addComponentListener(std);
        frame.addWindowFocusListener(std);
        frame.pack();
        rootGroup = StdDraw3D.createBranchGroup();
        lightGroup = StdDraw3D.createBranchGroup();
        bgGroup = StdDraw3D.createBranchGroup();
        soundGroup = StdDraw3D.createBranchGroup();
        fogGroup = StdDraw3D.createBranchGroup();
        appearanceGroup = StdDraw3D.createBranchGroup();
        onscreenGroup = StdDraw3D.createBranchGroup();
        offscreenGroup = StdDraw3D.createBranchGroup();
        rootGroup.addChild((Node)onscreenGroup);
        rootGroup.addChild((Node)lightGroup);
        rootGroup.addChild((Node)bgGroup);
        rootGroup.addChild((Node)soundGroup);
        rootGroup.addChild((Node)fogGroup);
        rootGroup.addChild((Node)appearanceGroup);
        universe = new SimpleUniverse(canvas, 2);
        universe.addBranchGraph(rootGroup);
        StdDraw3D.setDefaultLight();
        Viewer viewer = universe.getViewer();
        viewer.createAudioDevice();
        view = viewer.getView();
        view.setTransparencySortingPolicy(1);
        view.setScreenScalePolicy(1);
        view.setLocalEyeLightingEnable(true);
        StdDraw3D.setAntiAliasing(false);
        ViewingPlatform viewingPlatform = universe.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        orbit = new OrbitBehavior(canvas, 368);
        BoundingSphere bounds = INFINITE_BOUNDS;
        orbit.setMinRadius(0.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        StdDraw3D.setOrbitCenter(new Point3d(0.0, 0.0, 0.0));
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        TransformGroup cameraTG = viewingPlatform.getViewPlatformTransform();
        Transform3D cameraTrans = new Transform3D();
        cameraTG.getTransform(cameraTrans);
        viewingPlatform.detach();
        cameraTG.setCapability(17);
        cameraTG.setCapability(18);
        camera = new Camera(cameraTG);
        universe.addBranchGraph((BranchGroup)viewingPlatform);
        StdDraw3D.setPerspectiveProjection();
        StdDraw3D.setCameraMode();
        StdDraw3D.setPenColor();
        StdDraw3D.setPenRadius();
        StdDraw3D.setFont();
        StdDraw3D.setScale();
        StdDraw3D.setInfoDisplay(true);
        StdDraw3D.setBackground(DEFAULT_BGCOLOR);
        frame.setVisible(true);
        frame.toFront();
        frame.setState(0);
        initialized = true;
    }

    private static void initializeCanvas() {
        Panel p = new Panel();
        GridBagLayout gl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        p.setLayout(gl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.gridheight = 5;
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        canvas = new Canvas3D(config){

            public void preRender() {
                if (camera.pair != null) {
                    camera.setPosition(camera.pair.getPosition());
                    camera.setOrientation(camera.pair.getOrientation());
                }
            }

            public void postRender() {
                J3DGraphics2D graphics = this.getGraphics2D();
                graphics.drawRenderedImage((RenderedImage)onscreenImage, new AffineTransform());
                if (infoDisplay) {
                    graphics.drawRenderedImage((RenderedImage)infoImage, new AffineTransform());
                }
                graphics.flush(false);
                Thread.yield();
            }
        };
        canvas.addKeyListener((KeyListener)std);
        canvas.addMouseListener((MouseListener)std);
        canvas.addMouseMotionListener((MouseMotionListener)std);
        canvas.addMouseWheelListener((MouseWheelListener)std);
        canvas.setSize(width, height);
        p.add((Component)canvas, gbc);
        canvasPanel = p;
    }

    private static JMenuBar createMenuBar() {
        menuBar = new JMenuBar();
        fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        loadButton = new JMenuItem(" Load 3D Model..  ");
        loadButton.addActionListener(std);
        loadButton.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileMenu.add(loadButton);
        saveButton = new JMenuItem(" Save Image...  ");
        saveButton.addActionListener(std);
        saveButton.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileMenu.add(saveButton);
        save3DButton = new JMenuItem(" Export 3D Scene...  ");
        save3DButton.addActionListener(std);
        save3DButton.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileMenu.addSeparator();
        quitButton = new JMenuItem(" Quit...   ");
        quitButton.addActionListener(std);
        quitButton.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileMenu.add(quitButton);
        cameraMenu = new JMenu("Camera");
        menuBar.add(cameraMenu);
        JLabel cameraLabel = new JLabel("Camera Mode");
        cameraLabel.setAlignmentX(0.5f);
        cameraLabel.setForeground(GRAY);
        cameraMenu.add(cameraLabel);
        cameraMenu.addSeparator();
        ButtonGroup cameraButtonGroup = new ButtonGroup();
        orbitModeButton = new JRadioButtonMenuItem("Orbit Mode");
        orbitModeButton.setSelected(true);
        cameraButtonGroup.add(orbitModeButton);
        cameraMenu.add(orbitModeButton);
        orbitModeButton.addActionListener(std);
        orbitModeButton.setAccelerator(KeyStroke.getKeyStroke(49, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fpsModeButton = new JRadioButtonMenuItem("First-Person Mode");
        cameraButtonGroup.add(fpsModeButton);
        cameraMenu.add(fpsModeButton);
        fpsModeButton.addActionListener(std);
        fpsModeButton.setAccelerator(KeyStroke.getKeyStroke(50, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        airplaneModeButton = new JRadioButtonMenuItem("Airplane Mode");
        cameraButtonGroup.add(airplaneModeButton);
        cameraMenu.add(airplaneModeButton);
        airplaneModeButton.addActionListener(std);
        airplaneModeButton.setAccelerator(KeyStroke.getKeyStroke(51, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        lookModeButton = new JRadioButtonMenuItem("Look Mode");
        cameraButtonGroup.add(lookModeButton);
        cameraMenu.add(lookModeButton);
        lookModeButton.addActionListener(std);
        lookModeButton.setAccelerator(KeyStroke.getKeyStroke(52, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fixedModeButton = new JRadioButtonMenuItem("Fixed Mode");
        cameraButtonGroup.add(fixedModeButton);
        cameraMenu.add(fixedModeButton);
        fixedModeButton.addActionListener(std);
        fixedModeButton.setAccelerator(KeyStroke.getKeyStroke(53, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        cameraMenu.addSeparator();
        JLabel projectionLabel = new JLabel("Projection Mode");
        projectionLabel.setAlignmentX(0.5f);
        projectionLabel.setForeground(GRAY);
        cameraMenu.add(projectionLabel);
        cameraMenu.addSeparator();
        SpinnerNumberModel snm = new SpinnerNumberModel(0.9, 0.5, 3.0, 0.05);
        fovSpinner = new JSpinner(snm);
        JPanel fovPanel = new JPanel();
        fovPanel.setLayout(new BoxLayout(fovPanel, 0));
        JLabel fovLabel = new JLabel("Field of View:");
        fovPanel.add(javax.swing.Box.createRigidArea(new Dimension(30, 5)));
        fovPanel.add(fovLabel);
        fovPanel.add(javax.swing.Box.createRigidArea(new Dimension(10, 5)));
        fovPanel.add(fovSpinner);
        ButtonGroup projectionButtons = new ButtonGroup();
        perspectiveButton = new JRadioButtonMenuItem("Perspective Projection");
        parallelButton = new JRadioButtonMenuItem("Parallel Projection");
        fovSpinner.addChangeListener(std);
        perspectiveButton.addActionListener(std);
        parallelButton.addActionListener(std);
        cameraMenu.add(parallelButton);
        cameraMenu.add(perspectiveButton);
        cameraMenu.add(fovPanel);
        projectionButtons.add(parallelButton);
        projectionButtons.add(perspectiveButton);
        perspectiveButton.setSelected(true);
        graphicsMenu = new JMenu("Graphics");
        JLabel graphicsLabel = new JLabel("Polygon Count");
        graphicsLabel.setAlignmentX(0.5f);
        graphicsLabel.setForeground(GRAY);
        graphicsMenu.add(graphicsLabel);
        graphicsMenu.addSeparator();
        SpinnerNumberModel snm2 = new SpinnerNumberModel(100, 4, 4000, 5);
        numDivSpinner = new JSpinner(snm2);
        JPanel numDivPanel = new JPanel();
        numDivPanel.setLayout(new BoxLayout(numDivPanel, 0));
        JLabel numDivLabel = new JLabel("Triangles:");
        numDivPanel.add(javax.swing.Box.createRigidArea(new Dimension(5, 5)));
        numDivPanel.add(numDivLabel);
        numDivPanel.add(javax.swing.Box.createRigidArea(new Dimension(15, 5)));
        numDivPanel.add(numDivSpinner);
        graphicsMenu.add(numDivPanel);
        numDivSpinner.addChangeListener(std);
        graphicsMenu.addSeparator();
        JLabel graphicsLabel2 = new JLabel("Advanced Rendering");
        graphicsLabel2.setAlignmentX(0.5f);
        graphicsLabel2.setForeground(GRAY);
        graphicsMenu.add(graphicsLabel2);
        graphicsMenu.addSeparator();
        antiAliasingButton = new JCheckBoxMenuItem("Enable Anti-Aliasing");
        antiAliasingButton.setSelected(false);
        antiAliasingButton.addActionListener(std);
        graphicsMenu.add(antiAliasingButton);
        infoCheckBox = new JCheckBox("Show Info Display");
        infoCheckBox.setFocusable(false);
        infoCheckBox.addActionListener(std);
        menuBar.add(javax.swing.Box.createRigidArea(new Dimension(50, 5)));
        menuBar.add(infoCheckBox);
        return menuBar;
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == numDivSpinner) {
            numDivisions = (Integer)numDivSpinner.getValue();
        }
        if (source == fovSpinner) {
            StdDraw3D.setPerspectiveProjection((Double)fovSpinner.getValue());
            perspectiveButton.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == saveButton) {
            StdDraw3D.saveAction();
        } else if (source == loadButton) {
            StdDraw3D.loadAction();
        } else if (source == save3DButton) {
            StdDraw3D.save3DAction();
        } else if (source == quitButton) {
            StdDraw3D.quitAction();
        } else if (source == orbitModeButton) {
            StdDraw3D.setCameraMode(0);
        } else if (source == fpsModeButton) {
            StdDraw3D.setCameraMode(1);
        } else if (source == airplaneModeButton) {
            StdDraw3D.setCameraMode(2);
        } else if (source == lookModeButton) {
            StdDraw3D.setCameraMode(3);
        } else if (source == fixedModeButton) {
            StdDraw3D.setCameraMode(4);
        } else if (source == perspectiveButton) {
            StdDraw3D.setPerspectiveProjection((Double)fovSpinner.getValue());
        } else if (source == parallelButton) {
            StdDraw3D.setParallelProjection();
        } else if (source == antiAliasingButton) {
            StdDraw3D.setAntiAliasing(antiAliasingButton.isSelected());
        } else if (source == infoCheckBox) {
            StdDraw3D.setInfoDisplay(infoCheckBox.isSelected());
        }
    }

    public void componentHidden(ComponentEvent e) {
        keysDown = new TreeSet();
    }

    public void componentMoved(ComponentEvent e) {
        keysDown = new TreeSet();
    }

    public void componentShown(ComponentEvent e) {
        keysDown = new TreeSet();
    }

    public void componentResized(ComponentEvent e) {
        keysDown = new TreeSet();
    }

    public void windowGainedFocus(WindowEvent e) {
        keysDown = new TreeSet();
    }

    public void windowLostFocus(WindowEvent e) {
        keysDown = new TreeSet();
    }

    private static BranchGroup createBranchGroup() {
        BranchGroup bg = new BranchGroup();
        bg.setCapability(12);
        bg.setCapability(13);
        bg.setCapability(14);
        bg.setCapability(17);
        bg.setPickable(false);
        bg.setCollidable(false);
        return bg;
    }

    private static TransformGroup createTransformGroup() {
        TransformGroup tg = new TransformGroup();
        tg.setCapability(17);
        tg.setCapability(18);
        tg.setPickable(false);
        tg.setCollidable(false);
        return tg;
    }

    private static Background createBackground() {
        Background background = new Background();
        background.setCapability(17);
        background.setCapability(15);
        background.setCapability(19);
        background.setApplicationBounds((Bounds)INFINITE_BOUNDS);
        return background;
    }

    private static Texture createTexture(String imageURL) {
        TextureLoader loader;
        try {
            loader = new TextureLoader(imageURL, "RGBA", 4, (Component)new Container());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read from the file '" + imageURL + "'");
        }
        Texture texture = loader.getTexture();
        texture.setBoundaryModeS(3);
        texture.setBoundaryModeT(3);
        texture.setBoundaryColor(new Color4f(0.0f, 1.0f, 0.0f, 0.0f));
        return texture;
    }

    private static Appearance createBlankAppearance() {
        Appearance ap = new Appearance();
        ap.setCapability(0);
        ap.setCapability(1);
        ap.setCapability(10);
        ap.setCapability(11);
        return ap;
    }

    private static Appearance createAppearance(String imageURL, boolean fill) {
        Appearance ap = StdDraw3D.createBlankAppearance();
        PolygonAttributes pa = new PolygonAttributes();
        if (!fill) {
            pa.setPolygonMode(1);
        }
        pa.setCullFace(0);
        ap.setPolygonAttributes(pa);
        if (imageURL != null) {
            Texture texture = StdDraw3D.createTexture(imageURL);
            TextureAttributes texAttr = new TextureAttributes();
            texAttr.setTextureMode(5);
            ap.setTexture(texture);
            ap.setTextureAttributes(texAttr);
        }
        Color3f col = new Color3f(penColor);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specular = new Color3f(GRAY);
        Material material = new Material(col, black, col, specular, 64.0f);
        material.setCapability(0);
        material.setCapability(1);
        material.setLightingEnable(true);
        ap.setMaterial(material);
        float alpha = (float)penColor.getAlpha() / 255.0f;
        if ((double)alpha < 1.0) {
            TransparencyAttributes t = new TransparencyAttributes();
            t.setTransparencyMode(2);
            t.setTransparency(1.0f - alpha);
            ap.setTransparencyAttributes(t);
        }
        LineAttributes la = new LineAttributes();
        la.setLineWidth(penRadius);
        la.setLineAntialiasingEnable(view.getSceneAntialiasingEnable());
        PointAttributes poa = new PointAttributes();
        poa.setPointAntialiasingEnable(view.getSceneAntialiasingEnable());
        ColoringAttributes ca = new ColoringAttributes();
        ca.setShadeModel(3);
        ca.setColor(col);
        ap.setLineAttributes(la);
        ap.setPointAttributes(poa);
        ap.setColoringAttributes(ca);
        return ap;
    }

    private static Appearance createCustomAppearance(boolean fill) {
        Appearance ap = StdDraw3D.createBlankAppearance();
        PolygonAttributes pa = new PolygonAttributes();
        if (!fill) {
            pa.setPolygonMode(1);
        }
        pa.setCullFace(0);
        LineAttributes la = new LineAttributes();
        la.setLineWidth(penRadius);
        la.setLineAntialiasingEnable(view.getSceneAntialiasingEnable());
        PointAttributes poa = new PointAttributes();
        poa.setPointAntialiasingEnable(view.getSceneAntialiasingEnable());
        ap.setPolygonAttributes(pa);
        ap.setLineAttributes(la);
        ap.setPointAttributes(poa);
        Color3f col = new Color3f(penColor);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f specular = new Color3f(GRAY);
        Material material = new Material(col, black, col, specular, 64.0f);
        material.setCapability(0);
        material.setCapability(1);
        material.setLightingEnable(true);
        ap.setMaterial(material);
        return ap;
    }

    private static Shape3D createShape3D(Geometry geom) {
        Shape3D shape = new Shape3D(geom);
        shape.setPickable(false);
        shape.setCollidable(false);
        shape.setCapability(14);
        shape.setCapability(15);
        shape.setCapability(18);
        shape.setCapability(19);
        return shape;
    }

    private static BufferedImage createBufferedImage() {
        return new BufferedImage(width, height, 2);
    }

    private static Vector3d createVector3d(Vector3D v) {
        return new Vector3d(v.x, v.y, v.z);
    }

    private static Vector3f createVector3f(double x, double y, double z) {
        return new Vector3f((float)x, (float)y, (float)z);
    }

    private static Vector3f createVector3f(Vector3D v) {
        return StdDraw3D.createVector3f(v.x, v.y, v.z);
    }

    private static Point3f createPoint3f(Vector3D v) {
        return StdDraw3D.createPoint3f(v.x, v.y, v.z);
    }

    private static Point3f createPoint3f(double x, double y, double z) {
        return new Point3f((float)x, (float)y, (float)z);
    }

    private static Scanner createScanner(String s) {
        String charsetName = "ISO-8859-1";
        Locale usLocale = new Locale("en", "US");
        try {
            File file = new File(s);
            if (file.exists()) {
                Scanner scanner = new Scanner(file, charsetName);
                scanner.useLocale(usLocale);
                return scanner;
            }
            URL url = new URL(s);
            URLConnection site = url.openConnection();
            InputStream is = site.getInputStream();
            Scanner scanner = new Scanner((InputStream)new BufferedInputStream(is), charsetName);
            scanner.useLocale(usLocale);
            return scanner;
        }
        catch (IOException ioe) {
            System.err.println("Could not open " + s + ".");
            return null;
        }
    }

    public static void setCanvasSize(int w, int h) {
        StdDraw3D.setCanvasSize(w, h, false);
    }

    private static void setCanvasSize(int w, int h, boolean fs) {
        fullscreen = fs;
        if (w < 1 || h < 1) {
            throw new RuntimeException("Dimensions must be positive integers!");
        }
        width = w;
        height = h;
        aspectRatio = (double)width / (double)height;
        StdDraw3D.initialize();
    }

    public static void setScale() {
        StdDraw3D.setScale(0.0, 1.0);
    }

    public static void setScale(double minimum, double maximum) {
        min = minimum;
        max = maximum;
        zoom = (max - min) / 2.0;
        double center = min + zoom;
        camera.setPosition(center, center, zoom * (2.0 + Math.sqrt(2.0)));
        double orbitScale = 0.5 * zoom;
        orbit.setZoomFactor(orbitScale);
        orbit.setTransFactors(orbitScale, orbitScale);
        StdDraw3D.setOrbitCenter(new Point3d(center, center, center));
        view.setFrontClipDistance(0.01 * zoom);
        view.setBackClipDistance(10.0 * zoom);
    }

    private static float scaleX(double x) {
        double scale = 1.0;
        if (width > height) {
            scale = 1.0 / aspectRatio;
        }
        return (float)((double)width * (x * scale - min) / (2.0 * zoom));
    }

    private static float scaleY(double y) {
        double scale = 1.0;
        if (height > width) {
            scale = aspectRatio;
        }
        return (float)((double)height * (max - y * scale) / (2.0 * zoom));
    }

    private static double factorX(double w) {
        double scaleDist = width;
        if (width > height) {
            scaleDist = height;
        }
        return scaleDist * (w / (2.0 * zoom));
    }

    private static double factorY(double h) {
        double scaleDist = height;
        if (height > width) {
            scaleDist = width;
        }
        return scaleDist * (h / (2.0 * zoom));
    }

    private static double unscaleX(double xs) {
        double scale = 1.0;
        if (width > height) {
            scale = 1.0 / aspectRatio;
        }
        return (xs * (2.0 * zoom) / (double)width + min) / scale;
    }

    private static double unscaleY(double ys) {
        double scale = 1.0;
        if (height > width) {
            scale = aspectRatio;
        }
        return (max - ys * (2.0 * zoom) / (double)height) / scale;
    }

    public static void setPenColor(Color col, int alpha) {
        StdDraw3D.setPenColor(new Color(col.getRed(), col.getGreen(), col.getBlue(), alpha));
    }

    public static void setPenColor() {
        penColor = DEFAULT_PEN_COLOR;
    }

    public static void setPenColor(Color col) {
        penColor = col;
    }

    public static void setPenColor(int r, int g, int b) {
        penColor = new Color(r, g, b);
    }

    public static Color getPenColor() {
        return penColor;
    }

    public static void setPenRadius() {
        StdDraw3D.setPenRadius(0.002);
    }

    public static void setPenRadius(double r) {
        penRadius = (float)r * 500.0f;
    }

    public static float getPenRadius() {
        return penRadius / 500.0f;
    }

    public static void setFont() {
        font = DEFAULT_FONT;
    }

    public static void setFont(Font f) {
        font = f;
    }

    public static Font getFont() {
        return font;
    }

    public static void setInfoDisplay(boolean enabled) {
        infoDisplay = enabled;
        infoCheckBox.setSelected(enabled);
        camera.move(0.0, 0.0, 0.0);
        StdDraw3D.infoDisplay();
    }

    public static void fullscreen() {
        frame.setResizable(true);
        frame.setExtendedState(6);
        int w = StdDraw3D.frame.getSize().width;
        int h = StdDraw3D.frame.getSize().height;
        int borderY = StdDraw3D.frame.getInsets().top + StdDraw3D.frame.getInsets().bottom;
        int borderX = StdDraw3D.frame.getInsets().left + StdDraw3D.frame.getInsets().right;
        StdDraw3D.setCanvasSize(w - borderX, h - borderY - menuBar.getHeight(), true);
        frame.setExtendedState(6);
    }

    public static void setAntiAliasing(boolean enabled) {
        view.setSceneAntialiasingEnable(enabled);
        antiAliasingButton.setSelected(enabled);
    }

    public static boolean getAntiAliasing() {
        return antiAliasingButton.isSelected();
    }

    public static void setNumDivisions(int N) {
        numDivisions = N;
    }

    public static int getNumDivisions() {
        return numDivisions;
    }

    public static int getCameraMode() {
        return cameraMode;
    }

    public static void setCameraMode(int mode) {
        cameraMode = mode;
        if (cameraMode == 0) {
            orbit.setRotateEnable(true);
            if (view.getProjectionPolicy() != 0) {
                orbit.setZoomEnable(true);
            }
            orbit.setTranslateEnable(true);
            orbit.setRotationCenter(orbitCenter);
            orbitModeButton.setSelected(true);
        } else {
            orbit.setRotateEnable(false);
            orbit.setZoomEnable(false);
            orbit.setTranslateEnable(false);
        }
        if (cameraMode == 1) {
            fpsModeButton.setSelected(true);
            camera.rotateFPS(0.0, 0.0, 0.0);
        }
        if (cameraMode == 2) {
            airplaneModeButton.setSelected(true);
        }
        if (cameraMode == 3) {
            lookModeButton.setSelected(true);
        }
        if (cameraMode == 4) {
            fixedModeButton.setSelected(true);
        }
        if (cameraMode == 5) {
            BufferedImage cursorImg = new BufferedImage(16, 16, 2);
            Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "blank cursor");
            frame.getContentPane().setCursor(blankCursor);
        } else {
            frame.getContentPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void setCameraMode() {
        StdDraw3D.setCameraMode(0);
    }

    public static void setOrbitCenter(double x, double y, double z) {
        StdDraw3D.setOrbitCenter(new Point3d(x, y, z));
    }

    public static void setOrbitCenter(Vector3D v) {
        StdDraw3D.setOrbitCenter(new Point3d(v.x, v.y, v.z));
    }

    private static void setOrbitCenter(Point3d center) {
        orbitCenter = center;
        orbit.setRotationCenter(orbitCenter);
    }

    public static Vector3D getOrbitCenter() {
        return new Vector3D(orbitCenter);
    }

    public static void setPerspectiveProjection() {
        StdDraw3D.setPerspectiveProjection(0.9);
    }

    public static void setPerspectiveProjection(double fov) {
        view.setProjectionPolicy(1);
        view.setWindowEyepointPolicy(2);
        view.setFieldOfView(fov);
        StdDraw3D.setScreenScale(1.0);
        orbit.setZoomEnable(true);
        perspectiveButton.setSelected(true);
        if ((Double)fovSpinner.getValue() != fov) {
            fovSpinner.setValue(fov);
        }
    }

    public static void setParallelProjection() {
        if (view.getProjectionPolicy() == 0) {
            return;
        }
        view.setProjectionPolicy(0);
        orbit.setZoomEnable(false);
        parallelButton.setSelected(true);
        StdDraw3D.setScreenScale(0.3 / zoom);
    }

    private static void setScreenScale(double scale) {
        double ratio = scale / view.getScreenScale();
        view.setScreenScale(scale);
        view.setFrontClipDistance(view.getFrontClipDistance() * ratio);
        view.setBackClipDistance(view.getBackClipDistance() * ratio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mousePressed() {
        Object object = mouseLock;
        synchronized (object) {
            return StdDraw3D.mouse1Pressed() || StdDraw3D.mouse2Pressed() || StdDraw3D.mouse3Pressed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mouse1Pressed() {
        Object object = mouseLock;
        synchronized (object) {
            return mouse1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mouse2Pressed() {
        Object object = mouseLock;
        synchronized (object) {
            return mouse2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mouse3Pressed() {
        Object object = mouseLock;
        synchronized (object) {
            return mouse3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double mouseX() {
        Object object = mouseLock;
        synchronized (object) {
            return StdDraw3D.unscaleX(mouseX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double mouseY() {
        Object object = mouseLock;
        synchronized (object) {
            return StdDraw3D.unscaleY(mouseY);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e) {
        Object object = mouseLock;
        synchronized (object) {
            mouseX = e.getX();
            mouseY = e.getY();
            if (e.getButton() == 1) {
                mouse1 = true;
            }
            if (e.getButton() == 2) {
                mouse2 = true;
            }
            if (e.getButton() == 3) {
                mouse3 = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        Object object = mouseLock;
        synchronized (object) {
            if (e.getButton() == 1) {
                mouse1 = false;
            }
            if (e.getButton() == 2) {
                mouse2 = false;
            }
            if (e.getButton() == 3) {
                mouse3 = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent e) {
        Object object = mouseLock;
        synchronized (object) {
            StdDraw3D.mouseMotionEvents(e, e.getX(), e.getY(), true);
            mouseX = e.getX();
            mouseY = e.getY();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(MouseEvent e) {
        Object object = mouseLock;
        synchronized (object) {
            StdDraw3D.mouseMotionEvents(e, e.getX(), e.getY(), false);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        double notches = e.getWheelRotation();
        if (cameraMode == 0 && view.getProjectionPolicy() == 0) {
            camera.moveRelative(0.0, 0.0, notches * zoom / 20.0);
        }
    }

    private static void mouseMotionEvents(MouseEvent e, double newX, double newY, boolean dragged) {
        if (cameraMode == 4) {
            return;
        }
        if (cameraMode == 1) {
            if (dragged || immersive) {
                camera.rotateFPS((mouseY - newY) / 4.0, (mouseX - newX) / 4.0, 0.0);
            }
            return;
        }
        if (cameraMode == 2) {
            if (dragged || immersive) {
                camera.rotateRelative((mouseY - newY) / 4.0, (mouseX - newX) / 4.0, 0.0);
            }
            return;
        }
        if (cameraMode == 3) {
            if (dragged || immersive) {
                camera.rotateFPS((mouseY - newY) / 4.0, (mouseX - newX) / 4.0, 0.0);
            }
            return;
        }
        if (cameraMode == 0 && dragged && StdDraw3D.isKeyPressed(18) && view.getProjectionPolicy() == 0) {
            camera.moveRelative(0.0, 0.0, (newY - mouseY) * zoom / 50.0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNextKeyTyped() {
        Object object = keyLock;
        synchronized (object) {
            return !keysTyped.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char nextKeyTyped() {
        Object object = keyLock;
        synchronized (object) {
            return keysTyped.removeLast().charValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKeyPressed(int key) {
        Object object = keyLock;
        synchronized (object) {
            return keysDown.contains(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent e) {
        Object object = keyLock;
        synchronized (object) {
            char c = e.getKeyChar();
            keysTyped.addFirst(Character.valueOf(c));
            if (c == '`') {
                StdDraw3D.setCameraMode((StdDraw3D.getCameraMode() + 1) % 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent e) {
        Object object = keyLock;
        synchronized (object) {
            keysDown.add(e.getKeyCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(KeyEvent e) {
        Object object = keyLock;
        synchronized (object) {
            keysDown.remove(e.getKeyCode());
        }
    }

    private static void moveEvents(int time) {
        double move;
        StdDraw3D.infoDisplay();
        if (StdDraw3D.isKeyPressed(17)) {
            return;
        }
        if (cameraMode == 1) {
            move = 1.5E-4 * (double)time * zoom;
            if (StdDraw3D.isKeyPressed(87) || StdDraw3D.isKeyPressed(38)) {
                camera.moveRelative(0.0, 0.0, move * 3.0);
            }
            if (StdDraw3D.isKeyPressed(83) || StdDraw3D.isKeyPressed(40)) {
                camera.moveRelative(0.0, 0.0, -move * 3.0);
            }
            if (StdDraw3D.isKeyPressed(65) || StdDraw3D.isKeyPressed(37)) {
                camera.moveRelative(-move, 0.0, 0.0);
            }
            if (StdDraw3D.isKeyPressed(68) || StdDraw3D.isKeyPressed(39)) {
                camera.moveRelative(move, 0.0, 0.0);
            }
            if (StdDraw3D.isKeyPressed(81) || StdDraw3D.isKeyPressed(33)) {
                camera.moveRelative(0.0, move, 0.0);
            }
            if (StdDraw3D.isKeyPressed(69) || StdDraw3D.isKeyPressed(34)) {
                camera.moveRelative(0.0, -move, 0.0);
            }
        }
        if (cameraMode == 2) {
            move = 1.5E-4 * (double)time * zoom;
            if (StdDraw3D.isKeyPressed(87) || StdDraw3D.isKeyPressed(38)) {
                camera.moveRelative(0.0, 0.0, move * 3.0);
            }
            if (StdDraw3D.isKeyPressed(83) || StdDraw3D.isKeyPressed(40)) {
                camera.moveRelative(0.0, 0.0, -move * 3.0);
            }
            if (StdDraw3D.isKeyPressed(65) || StdDraw3D.isKeyPressed(37)) {
                camera.moveRelative(-move, 0.0, 0.0);
            }
            if (StdDraw3D.isKeyPressed(68) || StdDraw3D.isKeyPressed(39)) {
                camera.moveRelative(move, 0.0, 0.0);
            }
            if (StdDraw3D.isKeyPressed(81) || StdDraw3D.isKeyPressed(33)) {
                camera.rotateRelative(0.0, 0.0, move * 250.0 / zoom);
            }
            if (StdDraw3D.isKeyPressed(69) || StdDraw3D.isKeyPressed(34)) {
                camera.rotateRelative(0.0, 0.0, -move * 250.0 / zoom);
            }
        }
    }

    private static void save3DAction() {
        FileDialog chooser = new FileDialog((Frame)frame, "Save as a 3D file for loading later.", 1);
        chooser.setVisible(true);
        String filename = chooser.getFile();
        if (filename != null) {
            StdDraw3D.saveScene3D(chooser.getDirectory() + File.separator + chooser.getFile());
        }
        keysDown.remove(157);
        keysDown.remove(17);
        keysDown.remove(69);
    }

    private static void loadAction() {
        FileDialog chooser = new FileDialog((Frame)frame, "Pick a .obj or .ply file to load.", 0);
        chooser.setVisible(true);
        String filename = chooser.getDirectory() + chooser.getFile();
        StdDraw3D.model(filename);
        keysDown.remove(157);
        keysDown.remove(17);
        keysDown.remove(76);
    }

    private static void saveAction() {
        FileDialog chooser = new FileDialog((Frame)frame, "Use a .png or .jpg extension.", 1);
        chooser.setVisible(true);
        String filename = chooser.getFile();
        if (filename != null) {
            StdDraw3D.save(chooser.getDirectory() + File.separator + chooser.getFile());
        }
        keysDown.remove(157);
        keysDown.remove(17);
        keysDown.remove(83);
    }

    private static void quitAction() {
        WindowEvent wev = new WindowEvent(frame, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
        keysDown.remove(157);
        keysDown.remove(17);
        keysDown.remove(81);
    }

    public static void setBackground(Color color) {
        if (!color.equals(bgColor)) {
            bgColor = color;
            rootGroup.removeChild((Node)bgGroup);
            bgGroup.removeChild((Node)background);
            background = StdDraw3D.createBackground();
            background.setColor(new Color3f(bgColor));
            bgGroup.addChild((Node)background);
            rootGroup.addChild((Node)bgGroup);
        }
    }

    public static void setBackground(String imageURL) {
        rootGroup.removeChild((Node)bgGroup);
        bgGroup.removeChild((Node)background);
        background = StdDraw3D.createBackground();
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(new File(imageURL));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (bi == null) {
            try {
                ImageIO.read(new URL(imageURL));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ImageComponent2D imageComp = new ImageComponent2D(1, bi);
        background.setImage(imageComp);
        background.setImageScaleMode(3);
        bgGroup.addChild((Node)background);
        rootGroup.addChild((Node)bgGroup);
    }

    public static void setBackgroundSphere(String imageURL) {
        Sphere sphere = new Sphere(1.1f, 7, numDivisions);
        Appearance ap = sphere.getAppearance();
        Texture texture = StdDraw3D.createTexture(imageURL);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(5);
        ap.setTexture(texture);
        ap.setTextureAttributes(texAttr);
        sphere.setAppearance(ap);
        BranchGroup backGeoBranch = StdDraw3D.createBranchGroup();
        backGeoBranch.addChild((Node)sphere);
        rootGroup.removeChild((Node)bgGroup);
        bgGroup.removeChild((Node)background);
        background = StdDraw3D.createBackground();
        background.setGeometry(backGeoBranch);
        bgGroup.addChild((Node)background);
        rootGroup.addChild((Node)bgGroup);
    }

    public static void clearSound() {
        soundGroup.removeAllChildren();
    }

    public static void playAmbientSound(String filename) {
        StdDraw3D.playAmbientSound(filename, 1.0, false);
    }

    public static void playAmbientSound(String filename, boolean loop) {
        StdDraw3D.playAmbientSound(filename, 1.0, loop);
    }

    private static void playAmbientSound(String filename, double volume, boolean loop) {
        MediaContainer mc = new MediaContainer("file:" + filename);
        mc.setCacheEnable(true);
        BackgroundSound sound = new BackgroundSound();
        sound.setInitialGain((float)volume);
        sound.setSoundData(mc);
        sound.setBounds((Bounds)INFINITE_BOUNDS);
        sound.setSchedulingBounds((Bounds)INFINITE_BOUNDS);
        if (loop) {
            sound.setLoop(-1);
        }
        sound.setEnable(true);
        BranchGroup bg = StdDraw3D.createBranchGroup();
        bg.addChild((Node)sound);
        soundGroup.addChild((Node)bg);
    }

    public static void clearFog() {
        fogGroup.removeAllChildren();
    }

    public static void addFog(Color col, double frontDistance, double backDistance) {
        LinearFog fog = new LinearFog(new Color3f(col), frontDistance, backDistance);
        fog.setInfluencingBounds((Bounds)INFINITE_BOUNDS);
        BranchGroup bg = StdDraw3D.createBranchGroup();
        bg.addChild((Node)fog);
        fogGroup.addChild((Node)bg);
    }

    public static void clearLight() {
        lightGroup.removeAllChildren();
    }

    public static void setDefaultLight() {
        StdDraw3D.clearLight();
        StdDraw3D.directionalLight(-4.0, 7.0, 12.0, LIGHT_GRAY);
        StdDraw3D.directionalLight(4.0, -7.0, -12.0, WHITE);
        StdDraw3D.ambientLight(new Color(0.1f, 0.1f, 0.1f));
    }

    public static Light directionalLight(Vector3D dir, Color col) {
        return StdDraw3D.directionalLight(dir.x, dir.y, dir.z, col);
    }

    public static Light directionalLight(double x, double y, double z, Color col) {
        DirectionalLight light = new DirectionalLight();
        light.setColor(new Color3f(col));
        light.setInfluencingBounds((Bounds)INFINITE_BOUNDS);
        light.setCapability(13);
        light.setCapability(15);
        light.setEnable(true);
        BranchGroup bg = StdDraw3D.createBranchGroup();
        TransformGroup tg = StdDraw3D.createTransformGroup();
        tg.addChild((Node)light);
        bg.addChild((Node)tg);
        lightGroup.addChild((Node)bg);
        Light l = new Light(bg, tg, (javax.media.j3d.Light)light);
        l.setDirection(new Vector3D(x, y, z));
        return l;
    }

    public static Light ambientLight(Color col) {
        Color3f lightColor = new Color3f(col);
        AmbientLight light = new AmbientLight(lightColor);
        light.setInfluencingBounds((Bounds)INFINITE_BOUNDS);
        light.setCapability(13);
        light.setCapability(15);
        BranchGroup bg = StdDraw3D.createBranchGroup();
        TransformGroup tg = StdDraw3D.createTransformGroup();
        tg.addChild((Node)light);
        bg.addChild((Node)tg);
        lightGroup.addChild((Node)bg);
        return new Light(bg, tg, (javax.media.j3d.Light)light);
    }

    public static Light pointLight(Vector3D origin, Color col) {
        return StdDraw3D.pointLight(origin.x, origin.y, origin.z, col, 1.0);
    }

    public static Light pointLight(double x, double y, double z, Color col) {
        return StdDraw3D.pointLight(x, y, z, col, 1.0);
    }

    public static Light pointLight(Vector3D origin, Color col, double power) {
        return StdDraw3D.pointLight(origin.x, origin.y, origin.z, col, power);
    }

    public static Light pointLight(double x, double y, double z, Color col, double power) {
        PointLight light = new PointLight();
        light.setColor(new Color3f(col));
        light.setInfluencingBounds((Bounds)INFINITE_BOUNDS);
        light.setCapability(13);
        light.setCapability(15);
        light.setCapability(21);
        float scale = (float)zoom;
        float linearFade = 0.03f;
        float quadraticFade = 0.03f;
        light.setAttenuation(1.0f, linearFade / scale, quadraticFade / (scale * scale));
        BranchGroup bg = StdDraw3D.createBranchGroup();
        TransformGroup tg = StdDraw3D.createTransformGroup();
        tg.addChild((Node)light);
        bg.addChild((Node)tg);
        lightGroup.addChild((Node)bg);
        Light l = new Light(bg, tg, (javax.media.j3d.Light)light);
        l.setPosition(x, y, z);
        l.scalePower(power);
        return l;
    }

    public static Color randomColor() {
        return new Color(new Random().nextInt());
    }

    public static Color randomRainbowColor() {
        return Color.getHSBColor((float)Math.random(), 1.0f, 1.0f);
    }

    public static Vector3D randomDirection() {
        double theta = Math.random() * Math.PI * 2.0;
        double phi = Math.random() * Math.PI;
        return new Vector3D(Math.cos(theta) * Math.sin(phi), Math.sin(theta) * Math.sin(phi), Math.cos(phi));
    }

    public static void clear() {
        StdDraw3D.clear3D();
        StdDraw3D.clearOverlay();
    }

    public static void clear(Color color) {
        StdDraw3D.setBackground(color);
        StdDraw3D.clear();
    }

    public static void clear3D() {
        clear3D = true;
        offscreenGroup = StdDraw3D.createBranchGroup();
    }

    public static void clearOverlay() {
        clearOverlay = true;
        offscreenImage = StdDraw3D.createBufferedImage();
    }

    public static void pause(int time) {
        int t;
        int dt = 15;
        for (t = time; t > dt; t -= dt) {
            StdDraw3D.moveEvents(dt);
            Toolkit.getDefaultToolkit().sync();
            try {
                Thread.currentThread();
                Thread.sleep(dt);
                continue;
            }
            catch (InterruptedException e) {
                System.out.println("Error sleeping");
            }
        }
        StdDraw3D.moveEvents(t);
        if (t == 0) {
            return;
        }
        try {
            Thread.currentThread();
            Thread.sleep(t);
        }
        catch (InterruptedException e) {
            System.out.println("Error sleeping");
        }
    }

    public static void finished() {
        StdDraw3D.show(1000000000);
    }

    public static void show() {
        StdDraw3D.show(0);
    }

    public static void show(int time) {
        StdDraw3D.renderOverlay();
        StdDraw3D.render3D();
        StdDraw3D.pause(time);
    }

    public static void showOverlay() {
        StdDraw3D.showOverlay(0);
    }

    public static void showOverlay(int time) {
        StdDraw3D.renderOverlay();
        StdDraw3D.pause(time);
    }

    private static void renderOverlay() {
        if (clearOverlay) {
            clearOverlay = false;
            onscreenImage = offscreenImage;
        } else {
            Graphics2D graphics = (Graphics2D)onscreenImage.getGraphics();
            graphics.drawRenderedImage(offscreenImage, new AffineTransform());
        }
        offscreenImage = StdDraw3D.createBufferedImage();
    }

    public static void show3D() {
        StdDraw3D.show3D(0);
    }

    public static void show3D(int time) {
        StdDraw3D.render3D();
        StdDraw3D.pause(time);
    }

    private static void render3D() {
        rootGroup.addChild((Node)offscreenGroup);
        if (clear3D) {
            clear3D = false;
            rootGroup.removeChild((Node)onscreenGroup);
            onscreenGroup = offscreenGroup;
        } else {
            Enumeration children = offscreenGroup.getAllChildren();
            while (children.hasMoreElements()) {
                Node child = (Node)children.nextElement();
                offscreenGroup.removeChild(child);
                onscreenGroup.addChild(child);
            }
        }
        offscreenGroup = StdDraw3D.createBranchGroup();
        rootGroup.removeChild((Node)offscreenGroup);
    }

    public static Shape sphere(double x, double y, double z, double r) {
        return StdDraw3D.sphere(x, y, z, r, 0.0, 0.0, 0.0, null);
    }

    public static Shape sphere(double x, double y, double z, double r, double xA, double yA, double zA) {
        return StdDraw3D.sphere(x, y, z, r, xA, yA, zA, null);
    }

    public static Shape sphere(double x, double y, double z, double r, String imageURL) {
        return StdDraw3D.sphere(x, y, z, r, 0.0, 0.0, 0.0, imageURL);
    }

    public static Shape sphere(double x, double y, double z, double r, double xA, double yA, double zA, String imageURL) {
        Vector3f dimensions = StdDraw3D.createVector3f(0.0, 0.0, r);
        Sphere sphere = new Sphere(dimensions.z, 3, numDivisions);
        sphere.setAppearance(StdDraw3D.createAppearance(imageURL, true));
        return StdDraw3D.primitive((Primitive)sphere, x, y, z, new Vector3d(xA, yA, zA), null);
    }

    public static Shape wireSphere(double x, double y, double z, double r) {
        return StdDraw3D.wireSphere(x, y, z, r, 0.0, 0.0, 0.0);
    }

    public static Shape wireSphere(double x, double y, double z, double r, double xA, double yA, double zA) {
        Vector3f dimensions = StdDraw3D.createVector3f(0.0, 0.0, r);
        Sphere sphere = new Sphere(dimensions.z, 3, numDivisions);
        sphere.setAppearance(StdDraw3D.createAppearance(null, false));
        return StdDraw3D.primitive((Primitive)sphere, x, y, z, new Vector3d(xA, yA, zA), null);
    }

    public static Shape ellipsoid(double x, double y, double z, double w, double h, double d) {
        return StdDraw3D.ellipsoid(x, y, z, w, h, d, 0.0, 0.0, 0.0, null);
    }

    public static Shape ellipsoid(double x, double y, double z, double w, double h, double d, double xA, double yA, double zA) {
        return StdDraw3D.ellipsoid(x, y, z, w, h, d, xA, yA, zA, null);
    }

    public static Shape ellipsoid(double x, double y, double z, double w, double h, double d, String imageURL) {
        return StdDraw3D.ellipsoid(x, y, z, w, h, d, 0.0, 0.0, 0.0, imageURL);
    }

    public static Shape ellipsoid(double x, double y, double z, double w, double h, double d, double xA, double yA, double zA, String imageURL) {
        Sphere sphere = new Sphere(1.0f, 3, numDivisions);
        sphere.setAppearance(StdDraw3D.createAppearance(imageURL, true));
        return StdDraw3D.primitive((Primitive)sphere, x, y, z, new Vector3d(xA, yA, zA), new Vector3d(w, h, d));
    }

    public static Shape wireEllipsoid(double x, double y, double z, double w, double h, double d) {
        return StdDraw3D.wireEllipsoid(x, y, z, w, h, d, 0.0, 0.0, 0.0);
    }

    public static Shape wireEllipsoid(double x, double y, double z, double w, double h, double d, double xA, double yA, double zA) {
        Sphere sphere = new Sphere(1.0f, 3, numDivisions);
        sphere.setAppearance(StdDraw3D.createAppearance(null, false));
        return StdDraw3D.primitive((Primitive)sphere, x, y, z, new Vector3d(xA, yA, zA), new Vector3d(w, h, d));
    }

    public static Shape cube(double x, double y, double z, double r) {
        return StdDraw3D.cube(x, y, z, r, 0.0, 0.0, 0.0, null);
    }

    public static Shape cube(double x, double y, double z, double r, double xA, double yA, double zA) {
        return StdDraw3D.cube(x, y, z, r, xA, yA, zA, null);
    }

    public static Shape cube(double x, double y, double z, double r, String imageURL) {
        return StdDraw3D.cube(x, y, z, r, 0.0, 0.0, 0.0, imageURL);
    }

    public static Shape cube(double x, double y, double z, double r, double xA, double yA, double zA, String imageURL) {
        return StdDraw3D.box(x, y, z, r, r, r, xA, yA, zA, imageURL);
    }

    public static Shape wireCube(double x, double y, double z, double r, double xA, double yA, double zA) {
        return StdDraw3D.wireBox(x, y, z, r, r, r, 0.0, 0.0, 0.0);
    }

    public static Shape wireCube(double x, double y, double z, double r) {
        double[] xC = new double[]{x + r, x + r, x - r, x - r, x + r, x + r, x + r, x - r, x - r, x + r, x + r, x + r, x - r, x - r, x - r, x - r};
        double[] yC = new double[]{y + r, y - r, y - r, y + r, y + r, y + r, y - r, y - r, y + r, y + r, y - r, y - r, y - r, y - r, y + r, y + r};
        double[] zC = new double[]{z + r, z + r, z + r, z + r, z + r, z - r, z - r, z - r, z - r, z - r, z - r, z + r, z + r, z - r, z - r, z + r};
        return StdDraw3D.lines(xC, yC, zC);
    }

    public static Shape box(double x, double y, double z, double w, double h, double d) {
        return StdDraw3D.box(x, y, z, w, h, d, 0.0, 0.0, 0.0, null);
    }

    public static Shape box(double x, double y, double z, double w, double h, double d, double xA, double yA, double zA) {
        return StdDraw3D.box(x, y, z, w, h, d, xA, yA, zA, null);
    }

    public static Shape box(double x, double y, double z, double w, double h, double d, String imageURL) {
        return StdDraw3D.box(x, y, z, w, h, d, 0.0, 0.0, 0.0, imageURL);
    }

    public static Shape box(double x, double y, double z, double w, double h, double d, double xA, double yA, double zA, String imageURL) {
        Appearance ap = StdDraw3D.createAppearance(imageURL, true);
        Vector3f dimensions = StdDraw3D.createVector3f(w, h, d);
        Box box = new Box(dimensions.x, dimensions.y, dimensions.z, 3, ap, numDivisions);
        return StdDraw3D.primitive((Primitive)box, x, y, z, new Vector3d(xA, yA, zA), null);
    }

    public static Shape wireBox(double x, double y, double z, double w, double h, double d) {
        return StdDraw3D.wireBox(x, y, z, w, h, d, 0.0, 0.0, 0.0);
    }

    public static Shape wireBox(double x, double y, double z, double w, double h, double d, double xA, double yA, double zA) {
        Appearance ap = StdDraw3D.createAppearance(null, false);
        Vector3f dimensions = StdDraw3D.createVector3f(w, h, d);
        Box box = new Box(dimensions.x, dimensions.y, dimensions.z, 3, ap, numDivisions);
        return StdDraw3D.primitive((Primitive)box, x, y, z, new Vector3d(xA, yA, zA), null);
    }

    public static Shape cylinder(double x, double y, double z, double r, double h) {
        return StdDraw3D.cylinder(x, y, z, r, h, 0.0, 0.0, 0.0, null);
    }

    public static Shape cylinder(double x, double y, double z, double r, double h, double xA, double yA, double zA) {
        return StdDraw3D.cylinder(x, y, z, r, h, xA, yA, zA, null);
    }

    public static Shape cylinder(double x, double y, double z, double r, double h, String imageURL) {
        return StdDraw3D.cylinder(x, y, z, r, h, 0.0, 0.0, 0.0, imageURL);
    }

    public static Shape cylinder(double x, double y, double z, double r, double h, double xA, double yA, double zA, String imageURL) {
        Appearance ap = StdDraw3D.createAppearance(imageURL, true);
        Vector3f dimensions = StdDraw3D.createVector3f(r, h, 0.0);
        Cylinder cyl = new Cylinder(dimensions.x, dimensions.y, 3, numDivisions, numDivisions, ap);
        return StdDraw3D.primitive((Primitive)cyl, x, y, z, new Vector3d(xA, yA, zA), null);
    }

    public static Shape wireCylinder(double x, double y, double z, double r, double h) {
        return StdDraw3D.wireCylinder(x, y, z, r, h, 0.0, 0.0, 0.0);
    }

    public static Shape wireCylinder(double x, double y, double z, double r, double h, double xA, double yA, double zA) {
        Appearance ap = StdDraw3D.createAppearance(null, false);
        Vector3f dimensions = StdDraw3D.createVector3f(r, h, 0.0);
        Cylinder cyl = new Cylinder(dimensions.x, dimensions.y, 3, numDivisions, numDivisions, ap);
        return StdDraw3D.primitive((Primitive)cyl, x, y, z, new Vector3d(xA, yA, zA), null);
    }

    public static Shape cone(double x, double y, double z, double r, double h) {
        return StdDraw3D.cone(x, y, z, r, h, 0.0, 0.0, 0.0, null);
    }

    public static Shape cone(double x, double y, double z, double r, double h, double xA, double yA, double zA) {
        return StdDraw3D.cone(x, y, z, r, h, xA, yA, zA, null);
    }

    public static Shape cone(double x, double y, double z, double r, double h, String imageURL) {
        return StdDraw3D.cone(x, y, z, r, h, 0.0, 0.0, 0.0, imageURL);
    }

    public static Shape cone(double x, double y, double z, double r, double h, double xA, double yA, double zA, String imageURL) {
        Appearance ap = StdDraw3D.createAppearance(imageURL, true);
        Vector3f dimensions = StdDraw3D.createVector3f(r, h, 0.0);
        Cone cone = new Cone(dimensions.x, dimensions.y, 3, numDivisions, numDivisions, ap);
        return StdDraw3D.primitive((Primitive)cone, x, y, z, new Vector3d(xA, yA, zA), null);
    }

    public static Shape wireCone(double x, double y, double z, double r, double h) {
        return StdDraw3D.wireCone(x, y, z, r, h, 0.0, 0.0, 0.0);
    }

    public static Shape wireCone(double x, double y, double z, double r, double h, double xA, double yA, double zA) {
        Appearance ap = StdDraw3D.createAppearance(null, false);
        Vector3f dimensions = StdDraw3D.createVector3f(r, h, 0.0);
        Cone cone = new Cone(dimensions.x, dimensions.y, 3, numDivisions, numDivisions, ap);
        return StdDraw3D.primitive((Primitive)cone, x, y, z, new Vector3d(xA, yA, zA), null);
    }

    private static Shape primitive(Primitive shape, double x, double y, double z, Vector3d angles, Vector3d scales) {
        shape.setCapability(64);
        shape.setPickable(false);
        shape.setCollidable(false);
        TransformGroup tgScale = StdDraw3D.createTransformGroup();
        Transform3D scaleTransform = new Transform3D();
        if (scales != null) {
            scaleTransform.setScale(scales);
        }
        tgScale.setTransform(scaleTransform);
        tgScale.addChild((Node)shape);
        TransformGroup tgShape = StdDraw3D.createTransformGroup();
        Transform3D transform = new Transform3D();
        if (angles != null) {
            angles.scale(Math.PI / 180);
            transform.setEuler(angles);
        }
        Vector3f vector = StdDraw3D.createVector3f(x, y, z);
        transform.setTranslation(vector);
        tgShape.setTransform(transform);
        tgShape.addChild((Node)tgScale);
        BranchGroup bg = StdDraw3D.createBranchGroup();
        bg.addChild((Node)tgShape);
        offscreenGroup.addChild((Node)bg);
        return new Shape(bg, tgShape);
    }

    public static Shape point(double x, double y, double z) {
        return StdDraw3D.points(new double[]{x}, new double[]{y}, new double[]{z});
    }

    public static Shape points(double[] x, double[] y, double[] z) {
        Point3f[] coords = StdDraw3D.constructPoint3f(x, y, z);
        PointArray geom = new PointArray(coords.length, 1);
        geom.setCoordinates(0, coords);
        Shape3D shape = StdDraw3D.createShape3D((Geometry)geom);
        return StdDraw3D.shape(shape);
    }

    public static Shape points(double[] x, double[] y, double[] z, Color[] colors) {
        Point3f[] coords = StdDraw3D.constructPoint3f(x, y, z);
        PointArray geom = new PointArray(coords.length, 13);
        geom.setCoordinates(0, coords);
        for (int i = 0; i < x.length; ++i) {
            geom.setColor(i, colors[i].getComponents(null));
        }
        Shape3D shape = StdDraw3D.createShape3D((Geometry)geom);
        return StdDraw3D.customShape(shape);
    }

    public static Shape line(double x1, double y1, double z1, double x2, double y2, double z2) {
        return StdDraw3D.lines(new double[]{x1, x2}, new double[]{y1, y2}, new double[]{z1, z2});
    }

    public static Shape lines(double[] x, double[] y, double[] z) {
        Point3f[] coords = StdDraw3D.constructPoint3f(x, y, z);
        LineStripArray geom = new LineStripArray(coords.length, 1, new int[]{coords.length});
        geom.setCoordinates(0, coords);
        Shape3D shape = StdDraw3D.createShape3D((Geometry)geom);
        return StdDraw3D.shape(shape);
    }

    public static Shape lines(double[] x, double[] y, double[] z, Color[] colors) {
        Point3f[] coords = StdDraw3D.constructPoint3f(x, y, z);
        LineStripArray geom = new LineStripArray(coords.length, 13, new int[]{coords.length});
        geom.setCoordinates(0, coords);
        for (int i = 0; i < x.length; ++i) {
            geom.setColor(i, colors[i].getComponents(null));
        }
        Shape3D shape = StdDraw3D.createShape3D((Geometry)geom);
        return StdDraw3D.customShape(shape);
    }

    public static Shape tube(double x1, double y1, double z1, double x2, double y2, double z2, double r) {
        Vector3D mid = new Vector3D(x1 + x2, y1 + y2, z1 + z2).times(0.5);
        Vector3D line = new Vector3D(x2 - x1, y2 - y1, z2 - z1);
        Shape s = StdDraw3D.cylinder(mid.x, mid.y, mid.z, r, line.mag());
        Vector3D yAxis = new Vector3D(0.0, 1.0, 0.0);
        Vector3D cross = line.cross(yAxis);
        double angle = line.angle(yAxis);
        s.rotateAxis(cross, -angle);
        return StdDraw3D.combine(s);
    }

    public static Shape tubes(double[] x, double[] y, double[] z, double r) {
        Shape[] shapes = new Shape[(x.length - 1) * 2];
        for (int i = 0; i < x.length - 1; ++i) {
            shapes[i] = StdDraw3D.tube(x[i], y[i], z[i], x[i + 1], y[i + 1], z[i + 1], r);
            shapes[i + x.length - 1] = StdDraw3D.sphere(x[i + 1], y[i + 1], z[i + 1], r);
        }
        return StdDraw3D.combine(shapes);
    }

    public static Shape tubes(double[] x, double[] y, double[] z, double r, Color[] colors) {
        Shape[] shapes = new Shape[(x.length - 1) * 2];
        for (int i = 0; i < x.length - 1; ++i) {
            StdDraw3D.setPenColor(colors[i]);
            shapes[i] = StdDraw3D.tube(x[i], y[i], z[i], x[i + 1], y[i + 1], z[i + 1], r);
            shapes[i + x.length - 1] = StdDraw3D.sphere(x[i + 1], y[i + 1], z[i + 1], r);
        }
        return StdDraw3D.combine(shapes);
    }

    public static Shape polygon(double[] x, double[] y, double[] z) {
        return StdDraw3D.polygon(x, y, z, true);
    }

    public static Shape wirePolygon(double[] x, double[] y, double[] z) {
        return StdDraw3D.polygon(x, y, z, false);
    }

    private static Shape polygon(double[] x, double[] y, double[] z, boolean filled) {
        Point3f[] coords = StdDraw3D.constructPoint3f(x, y, z);
        TriangleFanArray geom = new TriangleFanArray(coords.length, 1, new int[]{coords.length});
        geom.setCoordinates(0, coords);
        GeometryInfo geoinfo = new GeometryInfo((GeometryArray)geom);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geoinfo);
        Shape3D shape = StdDraw3D.createShape3D((Geometry)geoinfo.getIndexedGeometryArray());
        if (filled) {
            return StdDraw3D.shape(shape);
        }
        return StdDraw3D.wireShape(shape);
    }

    public static Shape triangles(double[][] points) {
        return StdDraw3D.triangles(points, true);
    }

    public static Shape wireTriangles(double[][] points) {
        return StdDraw3D.triangles(points, false);
    }

    private static Shape triangles(double[][] points, boolean filled) {
        int size = points.length;
        Point3f[] coords = new Point3f[size * 3];
        for (int i = 0; i < size; ++i) {
            coords[3 * i] = new Point3f((Tuple3f)StdDraw3D.createVector3f(points[i][0], points[i][1], points[i][2]));
            coords[3 * i + 1] = new Point3f((Tuple3f)StdDraw3D.createVector3f(points[i][3], points[i][4], points[i][5]));
            coords[3 * i + 2] = new Point3f((Tuple3f)StdDraw3D.createVector3f(points[i][6], points[i][7], points[i][8]));
        }
        TriangleArray geom = new TriangleArray(size * 3, 1);
        geom.setCoordinates(0, coords);
        GeometryInfo geoinfo = new GeometryInfo((GeometryArray)geom);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geoinfo);
        Shape3D shape = StdDraw3D.createShape3D((Geometry)geoinfo.getIndexedGeometryArray());
        if (filled) {
            return StdDraw3D.shape(shape);
        }
        return StdDraw3D.wireShape(shape);
    }

    public static Shape triangles(double[][] points, Color[] colors) {
        return StdDraw3D.triangles(points, colors, true);
    }

    public static Shape wireTriangles(double[][] points, Color[] colors) {
        return StdDraw3D.triangles(points, colors, false);
    }

    private static Shape triangles(double[][] points, Color[] colors, boolean filled) {
        int size = points.length;
        Point3f[] coords = new Point3f[size * 3];
        for (int i = 0; i < size; ++i) {
            coords[3 * i] = new Point3f((Tuple3f)StdDraw3D.createVector3f(points[i][0], points[i][1], points[i][2]));
            coords[3 * i + 1] = new Point3f((Tuple3f)StdDraw3D.createVector3f(points[i][3], points[i][4], points[i][5]));
            coords[3 * i + 2] = new Point3f((Tuple3f)StdDraw3D.createVector3f(points[i][6], points[i][7], points[i][8]));
        }
        TriangleArray geom = new TriangleArray(size * 3, 13);
        geom.setCoordinates(0, coords);
        for (int i = 0; i < colors.length; ++i) {
            geom.setColor(3 * i + 0, colors[i].getComponents(null));
            geom.setColor(3 * i + 1, colors[i].getComponents(null));
            geom.setColor(3 * i + 2, colors[i].getComponents(null));
        }
        GeometryInfo geoinfo = new GeometryInfo((GeometryArray)geom);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geoinfo);
        Shape3D shape = StdDraw3D.createShape3D((Geometry)geoinfo.getIndexedGeometryArray());
        if (filled) {
            return StdDraw3D.shape(shape);
        }
        return StdDraw3D.wireShape(shape);
    }

    public static Shape text3D(double x, double y, double z, String text) {
        return StdDraw3D.text3D(x, y, z, text, 0.0, 0.0, 0.0);
    }

    public static Shape text3D(double x, double y, double z, String text, double xA, double yA, double zA) {
        Line2D.Double line = new Line2D.Double(0.0, 0.0, 1.5, 0.0);
        FontExtrusion extrudePath = new FontExtrusion((java.awt.Shape)line);
        Font3D font3D = new Font3D(font, extrudePath);
        Point3d pos = new Point3d(x, y, z);
        Text3D t = new Text3D(font3D, text, StdDraw3D.createPoint3f(x, y, z));
        Transform3D shrinker = new Transform3D();
        shrinker.setEuler(new Vector3d(xA, yA, zA));
        shrinker.setTranslation(new Vector3d(x, y, z));
        shrinker.setScale(0.005);
        Shape3D shape = StdDraw3D.createShape3D((Geometry)t);
        return StdDraw3D.shape(shape, true, shrinker, false);
    }

    private static Point3f[] constructPoint3f(double[] x, double[] y, double[] z) {
        int size = x.length;
        Point3f[] coords = new Point3f[size];
        for (int i = 0; i < size; ++i) {
            coords[i] = new Point3f((Tuple3f)StdDraw3D.createVector3f(x[i], y[i], z[i]));
        }
        return coords;
    }

    private static Shape drawPLY(String filename, boolean colored) {
        Scanner scanner = StdDraw3D.createScanner(filename);
        int vertices = -1;
        int triangles = -1;
        int properties = -1;
        while (true) {
            String s;
            if ((s = scanner.next()).equals("vertex")) {
                vertices = scanner.nextInt();
                continue;
            }
            if (s.equals("face")) {
                triangles = scanner.nextInt();
                continue;
            }
            if (s.equals("property")) {
                ++properties;
                scanner.next();
                scanner.next();
                continue;
            }
            if (s.equals("end_header")) break;
        }
        System.out.println(vertices + " " + triangles + " " + properties);
        if (vertices == -1 || triangles == -1 || properties == -1) {
            throw new RuntimeException("Cannot read format of .ply file!");
        }
        double[][] parameters = new double[properties][vertices];
        for (int i = 0; i < vertices; ++i) {
            if (i % 10000 == 0) {
                System.out.println("vertex " + i);
            }
            for (int j = 0; j < properties; ++j) {
                parameters[j][i] = scanner.nextDouble();
            }
        }
        double[][] points = new double[triangles][9];
        for (int i = 0; i < triangles; ++i) {
            int edges = scanner.nextInt();
            if (edges != 3) {
                throw new RuntimeException("Only triangular faces supported!");
            }
            if (i % 10000 == 0) {
                System.out.println("face " + i);
            }
            int index = scanner.nextInt();
            points[i][0] = parameters[0][index];
            points[i][1] = parameters[1][index];
            points[i][2] = parameters[2][index];
            index = scanner.nextInt();
            points[i][3] = parameters[0][index];
            points[i][4] = parameters[1][index];
            points[i][5] = parameters[2][index];
            index = scanner.nextInt();
            points[i][6] = parameters[0][index];
            points[i][7] = parameters[1][index];
            points[i][8] = parameters[2][index];
        }
        return StdDraw3D.triangles(points);
    }

    private static Shape drawLWS(String filename) {
        Lw3dLoader loader = new Lw3dLoader();
        try {
            BranchGroup bg = loader.load(filename).getSceneGroup();
            bg.setCapability(12);
            bg.setCapability(13);
            bg.setCapability(14);
            bg.setCapability(17);
            TransformGroup transGroup = new TransformGroup();
            transGroup.addChild((Node)bg);
            BranchGroup bg2 = StdDraw3D.createBranchGroup();
            bg2.addChild((Node)transGroup);
            offscreenGroup.addChild((Node)bg2);
            return new Shape(bg2, transGroup);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return null;
        }
    }

    private static Shape drawOBJ(String filename, boolean colored, boolean resize) {
        int params = 0;
        if (resize) {
            params = -1;
        }
        ObjectFile loader = new ObjectFile(params);
        try {
            BranchGroup bg = loader.load(filename).getSceneGroup();
            bg.setCapability(12);
            bg.setCapability(13);
            bg.setCapability(14);
            bg.setCapability(17);
            for (int i = 0; i < bg.numChildren(); ++i) {
                Node child = bg.getChild(i);
                if (!(child instanceof Shape3D)) continue;
                Shape3D shape = (Shape3D)child;
                if (colored) {
                    shape.setAppearance(StdDraw3D.createAppearance(null, true));
                    continue;
                }
                Appearance ap = shape.getAppearance();
                PolygonAttributes pa = ap.getPolygonAttributes();
                if (pa == null) {
                    pa = new PolygonAttributes();
                }
                pa.setCullFace(0);
                ap.setPolygonAttributes(pa);
            }
            TransformGroup transGroup = new TransformGroup();
            transGroup.addChild((Node)bg);
            BranchGroup bg2 = StdDraw3D.createBranchGroup();
            bg2.addChild((Node)transGroup);
            offscreenGroup.addChild((Node)bg2);
            return new Shape(bg2, transGroup);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return null;
        }
    }

    public static Shape model(String filename) {
        return StdDraw3D.model(filename, false);
    }

    public static Shape model(String filename, boolean resize) {
        return StdDraw3D.model(filename, false, resize);
    }

    public static Shape coloredModel(String filename) {
        return StdDraw3D.model(filename, true, true);
    }

    public static Shape coloredModel(String filename, boolean resize) {
        return StdDraw3D.model(filename, true, resize);
    }

    private static Shape model(String filename, boolean colored, boolean resize) {
        if (filename == null) {
            return null;
        }
        String suffix = filename.substring(filename.lastIndexOf(46) + 1);
        String extension = suffix.toLowerCase();
        if (suffix.equals("ply")) {
            return StdDraw3D.drawPLY(filename, colored);
        }
        if (suffix.equals("obj")) {
            return StdDraw3D.drawOBJ(filename, colored, resize);
        }
        throw new RuntimeException("Format not supported!");
    }

    private static Shape shape(Shape3D shape) {
        return StdDraw3D.shape(shape, true, null, false);
    }

    private static Shape wireShape(Shape3D shape) {
        return StdDraw3D.shape(shape, false, null, false);
    }

    private static Shape customShape(Shape3D shape) {
        return StdDraw3D.shape(shape, true, null, true);
    }

    private static Shape customWireShape(Shape3D shape) {
        return StdDraw3D.shape(shape, false, null, true);
    }

    private static Shape shape(Shape3D shape, boolean fill, Transform3D transform, boolean custom) {
        Appearance ap = custom ? StdDraw3D.createCustomAppearance(fill) : StdDraw3D.createAppearance(null, fill);
        shape.setAppearance(ap);
        TransformGroup transGroup = new TransformGroup();
        if (transform != null) {
            transGroup.setTransform(transform);
        }
        transGroup.addChild((Node)shape);
        BranchGroup bg = StdDraw3D.createBranchGroup();
        bg.addChild((Node)transGroup);
        offscreenGroup.addChild((Node)bg);
        return new Shape(bg, transGroup);
    }

    public static void overlayPixel(double x, double y) {
        StdDraw3D.getGraphics2D(offscreenImage).fillRect(Math.round(StdDraw3D.scaleX(x)), Math.round(StdDraw3D.scaleY(y)), 1, 1);
    }

    public static void overlayPoint(double x, double y) {
        float r = penRadius;
        if (r <= 1.0f) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).fill(new Ellipse2D.Double(StdDraw3D.scaleX(x) - r / 2.0f, StdDraw3D.scaleY(y) - r / 2.0f, r, r));
        }
    }

    public static void overlayLine(double x0, double y0, double x1, double y1) {
        StdDraw3D.getGraphics2D(offscreenImage).draw(new Line2D.Double(StdDraw3D.scaleX(x0), StdDraw3D.scaleY(y0), StdDraw3D.scaleX(x1), StdDraw3D.scaleY(y1)));
    }

    public static void overlayCircle(double x, double y, double r) {
        if (r < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(2.0 * r);
        double hs = StdDraw3D.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).draw(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
    }

    public static void overlayFilledCircle(double x, double y, double r) {
        if (r < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(2.0 * r);
        double hs = StdDraw3D.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).fill(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
    }

    public static void overlayEllipse(double x, double y, double semiMajorAxis, double semiMinorAxis) {
        if (semiMajorAxis < 0.0) {
            throw new RuntimeException("ellipse semimajor axis can't be negative");
        }
        if (semiMinorAxis < 0.0) {
            throw new RuntimeException("ellipse semiminor axis can't be negative");
        }
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(2.0 * semiMajorAxis);
        double hs = StdDraw3D.factorY(2.0 * semiMinorAxis);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).draw(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
    }

    public static void overlayFilledEllipse(double x, double y, double semiMajorAxis, double semiMinorAxis) {
        if (semiMajorAxis < 0.0) {
            throw new RuntimeException("ellipse semimajor axis can't be negative");
        }
        if (semiMinorAxis < 0.0) {
            throw new RuntimeException("ellipse semiminor axis can't be negative");
        }
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(2.0 * semiMajorAxis);
        double hs = StdDraw3D.factorY(2.0 * semiMinorAxis);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).fill(new Ellipse2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
    }

    public static void overlayArc(double x, double y, double r, double angle1, double angle2) {
        if (r < 0.0) {
            throw new RuntimeException("arc radius can't be negative");
        }
        while (angle2 < angle1) {
            angle2 += 360.0;
        }
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(2.0 * r);
        double hs = StdDraw3D.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).draw(new Arc2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs, angle1, angle2 - angle1, 0));
        }
    }

    public static void overlaySquare(double x, double y, double r) {
        if (r < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(2.0 * r);
        double hs = StdDraw3D.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).draw(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
    }

    public static void overlayFilledSquare(double x, double y, double r) {
        if (r < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(2.0 * r);
        double hs = StdDraw3D.factorY(2.0 * r);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).fill(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
    }

    public static void overlayRectangle(double x, double y, double halfWidth, double halfHeight) {
        if (halfWidth < 0.0) {
            throw new RuntimeException("half width can't be negative");
        }
        if (halfHeight < 0.0) {
            throw new RuntimeException("half height can't be negative");
        }
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(2.0 * halfWidth);
        double hs = StdDraw3D.factorY(2.0 * halfHeight);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).draw(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
    }

    public static void overlayFilledRectangle(double x, double y, double halfWidth, double halfHeight) {
        if (halfWidth < 0.0) {
            throw new RuntimeException("half width can't be negative");
        }
        if (halfHeight < 0.0) {
            throw new RuntimeException("half height can't be negative");
        }
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(2.0 * halfWidth);
        double hs = StdDraw3D.factorY(2.0 * halfHeight);
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).fill(new Rectangle2D.Double(xs - ws / 2.0, ys - hs / 2.0, ws, hs));
        }
    }

    public static void overlayPolygon(double[] x, double[] y) {
        int N = x.length;
        GeneralPath path = new GeneralPath();
        path.moveTo(StdDraw3D.scaleX(x[0]), StdDraw3D.scaleY(y[0]));
        for (int i = 0; i < N; ++i) {
            path.lineTo(StdDraw3D.scaleX(x[i]), StdDraw3D.scaleY(y[i]));
        }
        path.closePath();
        StdDraw3D.getGraphics2D(offscreenImage).draw(path);
    }

    public static void overlayFilledPolygon(double[] x, double[] y) {
        int N = x.length;
        GeneralPath path = new GeneralPath();
        path.moveTo(StdDraw3D.scaleX(x[0]), StdDraw3D.scaleY(y[0]));
        for (int i = 0; i < N; ++i) {
            path.lineTo(StdDraw3D.scaleX(x[i]), StdDraw3D.scaleY(y[i]));
        }
        path.closePath();
        StdDraw3D.getGraphics2D(offscreenImage).fill(path);
    }

    public static void overlayText(double x, double y, String text) {
        Graphics2D graphics = StdDraw3D.getGraphics2D(offscreenImage);
        FontMetrics metrics = graphics.getFontMetrics();
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        int ws = metrics.stringWidth(text);
        int hs = metrics.getDescent();
        graphics.drawString(text, (float)(xs - (double)ws / 2.0), (float)(ys + (double)hs));
    }

    public static void overlayText(double x, double y, String text, double degrees) {
        Graphics2D graphics = StdDraw3D.getGraphics2D(offscreenImage);
        FontMetrics metrics = graphics.getFontMetrics();
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        int ws = metrics.stringWidth(text);
        int hs = metrics.getDescent();
        graphics.rotate(Math.toRadians(-degrees), xs, ys);
        graphics.drawString(text, (float)(xs - (double)ws / 2.0), (float)(ys + (double)hs));
        graphics.rotate(Math.toRadians(degrees), xs, ys);
    }

    public static void overlayTextLeft(double x, double y, String text) {
        Graphics2D graphics = StdDraw3D.getGraphics2D(offscreenImage);
        FontMetrics metrics = graphics.getFontMetrics();
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        int ws = metrics.stringWidth(text);
        int hs = metrics.getDescent();
        graphics.drawString(text, (float)xs, (float)(ys + (double)hs));
    }

    public static void overlayTextRight(double x, double y, String text) {
        Graphics2D graphics = StdDraw3D.getGraphics2D(offscreenImage);
        FontMetrics metrics = graphics.getFontMetrics();
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        int ws = metrics.stringWidth(text);
        int hs = metrics.getDescent();
        graphics.drawString(text, (float)(xs - (double)ws), (float)(ys + (double)hs));
    }

    public static void overlayPicture(double x, double y, String s) {
        Image image = StdDraw3D.getImage(s);
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        int ws = image.getWidth(null);
        int hs = image.getHeight(null);
        if (ws < 0 || hs < 0) {
            throw new RuntimeException("image " + s + " is corrupt");
        }
        StdDraw3D.getGraphics2D(offscreenImage).drawImage(image, (int)Math.round(xs - (double)ws / 2.0), (int)Math.round(ys - (double)hs / 2.0), null);
    }

    public static void overlayPicture(double x, double y, String s, double degrees) {
        Image image = StdDraw3D.getImage(s);
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        int ws = image.getWidth(null);
        int hs = image.getHeight(null);
        if (ws < 0 || hs < 0) {
            throw new RuntimeException("image " + s + " is corrupt");
        }
        Graphics2D graphics = StdDraw3D.getGraphics2D(offscreenImage);
        graphics.rotate(Math.toRadians(-degrees), xs, ys);
        graphics.drawImage(image, (int)Math.round(xs - (double)ws / 2.0), (int)Math.round(ys - (double)hs / 2.0), null);
        graphics.rotate(Math.toRadians(degrees), xs, ys);
    }

    public static void overlayPicture(double x, double y, String s, double w, double h) {
        Image image = StdDraw3D.getImage(s);
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        if (w < 0.0) {
            throw new RuntimeException("width is negative: " + w);
        }
        if (h < 0.0) {
            throw new RuntimeException("height is negative: " + h);
        }
        double ws = StdDraw3D.factorX(w);
        double hs = StdDraw3D.factorY(h);
        if (ws < 0.0 || hs < 0.0) {
            throw new RuntimeException("image " + s + " is corrupt");
        }
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        } else {
            StdDraw3D.getGraphics2D(offscreenImage).drawImage(image, (int)Math.round(xs - ws / 2.0), (int)Math.round(ys - hs / 2.0), (int)Math.round(ws), (int)Math.round(hs), null);
        }
    }

    public static void overlayPicture(double x, double y, String s, double w, double h, double degrees) {
        Image image = StdDraw3D.getImage(s);
        double xs = StdDraw3D.scaleX(x);
        double ys = StdDraw3D.scaleY(y);
        double ws = StdDraw3D.factorX(w);
        double hs = StdDraw3D.factorY(h);
        if (ws < 0.0 || hs < 0.0) {
            throw new RuntimeException("image " + s + " is corrupt");
        }
        if (ws <= 1.0 && hs <= 1.0) {
            StdDraw3D.overlayPixel(x, y);
        }
        Graphics2D graphics = StdDraw3D.getGraphics2D(offscreenImage);
        graphics.rotate(Math.toRadians(-degrees), xs, ys);
        graphics.drawImage(image, (int)Math.round(xs - ws / 2.0), (int)Math.round(ys - hs / 2.0), (int)Math.round(ws), (int)Math.round(hs), null);
        graphics.rotate(Math.toRadians(degrees), xs, ys);
    }

    private static Image getImage(String filename) {
        URL url;
        ImageIcon icon = new ImageIcon(filename);
        if (icon == null || icon.getImageLoadStatus() != 8) {
            try {
                url = new URL(filename);
                icon = new ImageIcon(url);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (icon == null || icon.getImageLoadStatus() != 8) {
            url = StdDraw3D.class.getResource(filename);
            if (url == null) {
                throw new RuntimeException("image " + filename + " not found");
            }
            icon = new ImageIcon(url);
        }
        return icon.getImage();
    }

    private static Graphics2D getGraphics2D(BufferedImage image) {
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(penColor);
        graphics.setFont(font);
        BasicStroke stroke = new BasicStroke(penRadius, 1, 1);
        graphics.setStroke(stroke);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return graphics;
    }

    private static void infoDisplay() {
        String mode;
        if (!infoDisplay) {
            infoImage = StdDraw3D.createBufferedImage();
            return;
        }
        BufferedImage bi = StdDraw3D.createBufferedImage();
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setFont(new Font("Courier", 0, 11));
        g.setStroke(new BasicStroke(1.0f, 1, 1));
        double center = (min + max) / 2.0;
        double r = zoom;
        double b = zoom * (double)0.1f;
        DecimalFormat df = new DecimalFormat(" 0.000;-0.000");
        Vector3D pos = camera.getPosition();
        String s = "(" + df.format(pos.x) + "," + df.format(pos.y) + "," + df.format(pos.z) + ")";
        g.setColor(BLACK);
        g.drawString("Position: " + s, 21, 26);
        g.setColor(LIGHT_GRAY);
        g.drawString("Position: " + s, 20, 25);
        Vector3D rot = camera.getOrientation();
        String s2 = "(" + df.format(rot.x) + "," + df.format(rot.y) + "," + df.format(rot.z) + ")";
        g.setColor(BLACK);
        g.drawString("Rotation: " + s2, 21, 41);
        g.setColor(LIGHT_GRAY);
        g.drawString("Rotation: " + s2, 20, 40);
        if (cameraMode == 0) {
            mode = "Camera: ORBIT_MODE";
        } else if (cameraMode == 1) {
            mode = "Camera: FPS_MODE";
        } else if (cameraMode == 2) {
            mode = "Camera: AIRPLANE_MODE";
        } else if (cameraMode == 3) {
            mode = "Camera: LOOK_MODE";
        } else if (cameraMode == 4) {
            mode = "Camera: FIXED_MODE";
        } else {
            throw new RuntimeException("Unknown camera mode!");
        }
        g.setColor(BLACK);
        g.drawString(mode, 21, 56);
        g.setColor(LIGHT_GRAY);
        g.drawString(mode, 20, 55);
        double d = b / 4.0;
        g.draw(new Line2D.Double(StdDraw3D.scaleX(d + center), StdDraw3D.scaleY(0.0 + center), StdDraw3D.scaleX(-d + center), StdDraw3D.scaleY(0.0 + center)));
        g.draw(new Line2D.Double(StdDraw3D.scaleX(0.0 + center), StdDraw3D.scaleY(d + center), StdDraw3D.scaleX(0.0 + center), StdDraw3D.scaleY(-d + center)));
        infoImage = bi;
    }

    public static void save(String filename) {
        int oldCameraMode = StdDraw3D.getCameraMode();
        StdDraw3D.setCameraMode(4);
        GraphicsContext3D context = canvas.getGraphicsContext3D();
        BufferedImage buf = StdDraw3D.createBufferedImage();
        ImageComponent2D imageComp = new ImageComponent2D(1, buf);
        Raster ras = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, 0, 0, width, height, imageComp, null);
        context.readRaster(ras);
        BufferedImage image = ras.getImage().getImage();
        File file = new File(filename);
        String suffix = filename.substring(filename.lastIndexOf(46) + 1);
        String extension = suffix.toLowerCase();
        if (extension.equals("png")) {
            try {
                ImageIO.write((RenderedImage)image, suffix, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (extension.equals("jpg")) {
            WritableRaster raster = image.getRaster();
            WritableRaster newRaster = raster.createWritableChild(0, 0, width, height, 0, 0, new int[]{0, 1, 2});
            BufferedImage rgbBuffer = new BufferedImage(image.getColorModel(), newRaster, false, null);
            try {
                ImageIO.write((RenderedImage)rgbBuffer, suffix, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Invalid image file type: " + suffix);
        }
        StdDraw3D.setCameraMode(oldCameraMode);
    }

    public static void saveScene3D(String filename) {
        File file = new File(filename);
        try {
            SceneGraphFileWriter writer = new SceneGraphFileWriter(file, universe, false, "3D scene saved from StdDraw3D.", null);
            writer.writeBranchGraph(offscreenGroup);
            writer.close();
            System.out.println("Scene successfully written to " + filename + "!");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (UnsupportedUniverseException uue) {
            uue.printStackTrace();
        }
    }

    public static void loadScene3D(String filename) {
        File file = new File(filename);
        try {
            BranchGroup bg;
            SceneGraphFileReader reader = new SceneGraphFileReader(file);
            System.out.println("Branch graph count = " + reader.getBranchGraphCount());
            offscreenGroup = bg = reader.readBranchGraph(0)[0];
            System.out.println("Scene successfully loaded from " + filename + "!");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static Shape combine(Shape ... shapes) {
        BranchGroup combinedGroup = StdDraw3D.createBranchGroup();
        TransformGroup combinedTransform = new TransformGroup();
        for (int i = 0; i < shapes.length; ++i) {
            BranchGroup bg = shapes[i].bg;
            TransformGroup tg = shapes[i].tg;
            offscreenGroup.removeChild((Node)bg);
            onscreenGroup.removeChild((Node)bg);
            bg.removeChild((Node)tg);
            combinedTransform.addChild((Node)shapes[i].tg);
        }
        combinedGroup.addChild((Node)combinedTransform);
        offscreenGroup.addChild((Node)combinedGroup);
        return new Shape(combinedGroup, combinedTransform);
    }

    public static Shape copy(Shape shape) {
        TransformGroup tg = shape.tg;
        BranchGroup bg = shape.bg;
        TransformGroup tg2 = (TransformGroup)tg.cloneTree();
        BranchGroup bg2 = StdDraw3D.createBranchGroup();
        bg2.addChild((Node)tg2);
        offscreenGroup.addChild((Node)bg2);
        return new Shape(bg2, tg2);
    }

    public static Vector3D getCameraPosition() {
        return camera.getPosition();
    }

    public static Vector3D getCameraOrientation() {
        return camera.getOrientation();
    }

    public static Vector3D getCameraDirection() {
        return camera.getDirection();
    }

    public static void setCameraPosition(double x, double y, double z) {
        StdDraw3D.setCameraPosition(new Vector3D(x, y, z));
    }

    public static void setCameraPosition(Vector3D position) {
        camera.setPosition(position);
    }

    public static void setCameraOrientation(double xAngle, double yAngle, double zAngle) {
        StdDraw3D.setCameraOrientation(new Vector3D(xAngle, yAngle, zAngle));
    }

    public static void setCameraOrientation(Vector3D angles) {
        camera.setOrientation(angles);
    }

    public static void setCameraDirection(double x, double y, double z) {
        StdDraw3D.setCameraDirection(new Vector3D(x, y, z));
    }

    public static void setCameraDirection(Vector3D direction) {
        camera.setDirection(direction);
    }

    public static void setCamera(double x, double y, double z, double xAngle, double yAngle, double zAngle) {
        camera.setPosition(x, y, z);
        camera.setOrientation(xAngle, yAngle, zAngle);
    }

    public static void setCamera(Vector3D position, Vector3D angles) {
        camera.setPosition(position);
        camera.setOrientation(angles);
    }

    public static Camera camera() {
        return camera;
    }

    public static void main(String[] args) {
        StdDraw3D.setScale(-1.0, 1.0);
        StdDraw3D.setInfoDisplay(false);
        StdDraw3D.setPenColor(WHITE);
        StdDraw3D.overlaySquare(0.0, 0.0, 0.98);
        StdDraw3D.setPenRadius(0.06);
        StdDraw3D.setPenColor(RED, 220);
        StdDraw3D.overlayCircle(0.0, 0.0, 0.8);
        StdDraw3D.setPenColor(RED, 220);
        StdDraw3D.overlayCircle(0.0, 0.0, 0.6);
        StdDraw3D.setPenColor(WHITE);
        StdDraw3D.overlayText(0.0, 0.91, "Standard Draw 3D - Test Program");
        StdDraw3D.overlayText(0.0, -0.95, "You should see rotating text. Drag the mouse to orbit.");
        StdDraw3D.setPenColor(YELLOW);
        StdDraw3D.setFont(new Font("Arial", 1, 16));
        Shape text = StdDraw3D.text3D(0.0, 0.0, 0.0, "StdDraw3D");
        text.scale(3.5);
        text.move(-0.7, -0.1, 0.0);
        text = StdDraw3D.combine(text);
        while (true) {
            text.rotate(0.0, 1.2, 0.0);
            StdDraw3D.show(20);
        }
    }

    static {
        keysDown = new TreeSet();
        keysTyped = new LinkedList();
        mouseLock = new Object();
        keyLock = new Object();
        initialized = false;
        fullscreen = false;
        immersive = false;
        showedOnce = true;
        renderedOnce = false;
        DEFAULT_FONT = new Font("Arial", 0, 16);
        DEFAULT_PEN_COLOR = WHITE;
        DEFAULT_BGCOLOR = BLACK;
        INFINITE_BOUNDS = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1.0E100);
        xAxis = new Vector3D(1.0, 0.0, 0.0);
        yAxis = new Vector3D(0.0, 1.0, 0.0);
        zAxis = new Vector3D(0.0, 0.0, 1.0);
        std = new StdDraw3D();
        System.setProperty("j3d.audiodevice", "com.sun.j3d.audioengines.javasound.JavaSoundMixer");
        StdDraw3D.setCanvasSize(600, 600);
    }

    public static class Vector3D {
        public final double x;
        public final double y;
        public final double z;

        public Vector3D() {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        }

        public Vector3D(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3D(double[] c) {
            if (c.length != 3) {
                throw new RuntimeException("Incorrect number of dimensions!");
            }
            this.x = c[0];
            this.y = c[1];
            this.z = c[2];
        }

        private Vector3D(Vector3d v) {
            this.x = v.x;
            this.y = v.y;
            this.z = v.z;
        }

        private Vector3D(Vector3f v) {
            this.x = v.x;
            this.y = v.y;
            this.z = v.z;
        }

        private Vector3D(Point3d p) {
            this.x = p.x;
            this.y = p.y;
            this.z = p.z;
        }

        private Vector3D(Point3f p) {
            this.x = p.x;
            this.y = p.y;
            this.z = p.z;
        }

        public double dot(Vector3D that) {
            return this.x * that.x + this.y * that.y + this.z * that.z;
        }

        public double mag() {
            return Math.sqrt(this.dot(this));
        }

        public double angle(Vector3D that) {
            return Math.toDegrees(Math.acos(this.dot(that) / (this.mag() * that.mag())));
        }

        public double distanceTo(Vector3D that) {
            return this.minus(that).mag();
        }

        public Vector3D plus(Vector3D that) {
            double cx = this.x + that.x;
            double cy = this.y + that.y;
            double cz = this.z + that.z;
            Vector3D c = new Vector3D(cx, cy, cz);
            return c;
        }

        public Vector3D plus(double x, double y, double z) {
            double cx = this.x + x;
            double cy = this.y + y;
            double cz = this.z + z;
            return new Vector3D(cx, cy, cz);
        }

        public Vector3D minus(Vector3D that) {
            double cx = this.x - that.x;
            double cy = this.y - that.y;
            double cz = this.z - that.z;
            Vector3D c = new Vector3D(cx, cy, cz);
            return c;
        }

        public Vector3D minus(double x, double y, double z) {
            double cx = this.x - x;
            double cy = this.y - y;
            double cz = this.z - z;
            return new Vector3D(cx, cy, cz);
        }

        public Vector3D times(double k) {
            return this.times(k, k, k);
        }

        public Vector3D times(double a, double b, double c) {
            double vx = this.x * a;
            double vy = this.y * b;
            double vz = this.z * c;
            Vector3D v = new Vector3D(vx, vy, vz);
            return v;
        }

        public Vector3D direction() {
            if (this.mag() == 0.0) {
                throw new RuntimeException("Zero-vector has no direction");
            }
            return this.times(1.0 / this.mag());
        }

        public Vector3D proj(Vector3D line) {
            Vector3D normal = line.direction();
            return normal.times(this.dot(normal));
        }

        public Vector3D cross(Vector3D that) {
            Vector3D a = this;
            Vector3D b = that;
            return new Vector3D(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
        }

        public Vector3D reflect(Vector3D line) {
            return this.proj(line).times(2.0).minus(this);
        }

        public String toString() {
            DecimalFormat df = new DecimalFormat("0.000000");
            return "( " + df.format(this.x) + ", " + df.format(this.y) + ", " + df.format(this.z) + " )";
        }

        public void draw() {
            StdDraw3D.sphere(this.x, this.y, this.z, 0.01);
        }
    }

    public static class Light
    extends Transformable {
        javax.media.j3d.Light light;
        BranchGroup bg;

        private Light(BranchGroup bg, TransformGroup tg, javax.media.j3d.Light light) {
            super(tg);
            this.light = light;
            this.bg = bg;
        }

        public void hide() {
            this.light.setEnable(false);
        }

        public void unhide() {
            this.light.setEnable(true);
        }

        public void match(Shape s) {
            ((Transformable)this).match((Transformable)s);
        }

        public void match(Camera c) {
            ((Transformable)this).match((Transformable)c);
        }

        public void setColor(Color col) {
            this.light.setColor(new Color3f(col));
        }

        public void scalePower(double power) {
            if (this.light instanceof PointLight) {
                double attenuationScale = 1.0 / (0.999 * power + 0.001);
                PointLight pl = (PointLight)this.light;
                Point3f attenuation = new Point3f();
                pl.getAttenuation(attenuation);
                attenuation.y = (float)((double)attenuation.y * attenuationScale);
                attenuation.z = (float)((double)attenuation.z * (attenuationScale * attenuationScale));
                pl.setAttenuation(attenuation);
            } else {
                System.err.println("Can only scale power for point lights!");
            }
        }
    }

    public static class Shape
    extends Transformable {
        private BranchGroup bg;
        private TransformGroup tg;

        private Shape(BranchGroup bg, TransformGroup tg) {
            super(tg);
            this.bg = bg;
            this.tg = tg;
            tg.setCapability(17);
            tg.setCapability(18);
        }

        public void scale(double scale) {
            Transform3D t = ((Transformable)this).getTransform();
            t.setScale(t.getScale() * scale);
            ((Transformable)this).setTransform(t);
        }

        public void hide() {
            offscreenGroup.removeChild((Node)this.bg);
            onscreenGroup.removeChild((Node)this.bg);
        }

        public void unhide() {
            this.hide();
            offscreenGroup.addChild((Node)this.bg);
        }

        public void match(Shape s) {
            ((Transformable)this).match((Transformable)s);
        }

        public void match(Camera c) {
            ((Transformable)this).match((Transformable)c);
        }

        public void setColor(Color c) {
            this.setColor((Group)this.tg, c);
        }

        public void setColor(Color c, int alpha) {
            this.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
        }

        private void setColor(Group g, Color c) {
            for (int i = 0; i < g.numChildren(); ++i) {
                Appearance ap;
                Node child = g.getChild(i);
                if (child instanceof Shape3D) {
                    Shape3D shape = (Shape3D)child;
                    ap = shape.getAppearance();
                    this.setColor(ap, c);
                    continue;
                }
                if (child instanceof Primitive) {
                    Primitive primitive = (Primitive)child;
                    ap = primitive.getAppearance();
                    this.setColor(ap, c);
                    continue;
                }
                if (!(child instanceof Group)) continue;
                this.setColor((Group)child, c);
            }
        }

        private void setColor(Appearance ap, Color c) {
            Material m = ap.getMaterial();
            m.setAmbientColor(new Color3f(c));
            m.setDiffuseColor(new Color3f(c));
            float alpha = (float)c.getAlpha() / 255.0f;
            if ((double)alpha < 1.0) {
                TransparencyAttributes t = new TransparencyAttributes();
                t.setTransparencyMode(2);
                t.setTransparency(1.0f - alpha);
                ap.setTransparencyAttributes(t);
            } else {
                ap.setTransparencyAttributes(null);
            }
        }
    }

    public static class Camera
    extends Transformable {
        private TransformGroup tg;
        private Shape pair;

        private Camera(TransformGroup tg) {
            super(tg);
            this.tg = tg;
        }

        public void match(Shape s) {
            ((Transformable)this).match((Transformable)s);
        }

        public void pair(Shape s) {
            this.pair = s;
        }

        public void unpair() {
            this.pair = null;
        }

        public void moveRelative(Vector3D move) {
            if (view.getProjectionPolicy() == 0) {
                StdDraw3D.setScreenScale(view.getScreenScale() * (1.0 + move.z / zoom));
                super.move(((Transformable)this).relToAbs(move.times(1.0, 1.0, 0.0)));
            } else {
                super.move(((Transformable)this).relToAbs(move.times(1.0, 1.0, -1.0)));
            }
        }

        public void rotateFPS(Vector3D angles) {
            this.rotateFPS(angles.x, angles.y, angles.z);
        }

        public void rotateFPS(double xAngle, double yAngle, double zAngle) {
            double xA = Math.toRadians(xAngle);
            double yA = Math.toRadians(yAngle);
            double zA = Math.toRadians(zAngle);
            Vector3D shift = ((Transformable)this).relToAbs(new Vector3D(-yA, xA, zA));
            Vector3D dir = super.getDirection().plus(shift);
            double angle = dir.angle(yAxis);
            if (angle > 90.0) {
                angle = 180.0 - angle;
            }
            if (angle < 5.0) {
                return;
            }
            super.setDirection(super.getDirection().plus(shift));
        }
    }

    private static class Transformable {
        private TransformGroup tg;

        private Transformable(TransformGroup tg0) {
            this.tg = tg0;
        }

        private Transform3D getTransform() {
            Transform3D t = new Transform3D();
            this.tg.getTransform(t);
            return t;
        }

        private void setTransform(Transform3D t) {
            this.tg.setTransform(t);
        }

        private Vector3D relToAbs(Vector3D r) {
            Transform3D t = this.getTransform();
            Matrix3d m = new Matrix3d();
            t.get(m);
            Vector3d zero = new Vector3d(0.0, 0.0, 0.0);
            Transform3D rotation = new Transform3D(m, zero, 1.0);
            Vector3f vec = StdDraw3D.createVector3f(r);
            rotation.transform(vec);
            return new Vector3D(vec);
        }

        private Vector3D absToRel(Vector3D r) {
            Transform3D t = this.getTransform();
            Matrix3d m = new Matrix3d();
            t.get(m);
            Vector3d zero = new Vector3d(0.0, 0.0, 0.0);
            Transform3D rotation = new Transform3D(m, zero, 1.0);
            Vector3f vec = StdDraw3D.createVector3f(r);
            rotation.invert();
            rotation.transform(vec);
            return new Vector3D(vec);
        }

        private void rotateQuat(double x, double y, double z, double w) {
            this.rotateQuat(new Quat4d(x, y, z, w));
        }

        private void rotateQuat(Quat4d quat) {
            Transform3D t = this.getTransform();
            Transform3D t1 = new Transform3D();
            t1.setRotation(quat);
            t.mul(t1);
            this.setTransform(t);
        }

        private void setQuaternion(double x, double y, double z, double w) {
            this.setQuaternion(new Quat4d(x, y, z, w));
        }

        private void setQuaternion(Quat4d quat) {
            Transform3D t = this.getTransform();
            t.setRotation(quat);
            this.setTransform(t);
        }

        private Quat4d getQuaternion() {
            Transform3D t = this.getTransform();
            Matrix3d m = new Matrix3d();
            t.get(m);
            double w = Math.sqrt(Math.max(0.0, 1.0 + m.m00 + m.m11 + m.m22)) / 2.0;
            double x = Math.sqrt(Math.max(0.0, 1.0 + m.m00 - m.m11 - m.m22)) / 2.0;
            double y = Math.sqrt(Math.max(0.0, 1.0 - m.m00 + m.m11 - m.m22)) / 2.0;
            double z = Math.sqrt(Math.max(0.0, 1.0 - m.m00 - m.m11 + m.m22)) / 2.0;
            if (m.m21 - m.m12 < 0.0) {
                x = -x;
            }
            if (m.m02 - m.m20 < 0.0) {
                y = -y;
            }
            if (m.m10 - m.m01 < 0.0) {
                z = -z;
            }
            return new Quat4d(x, y, z, w);
        }

        private void orientAxis(Vector3D axis, double angle) {
            Transform3D t = this.getTransform();
            AxisAngle4d aa = new AxisAngle4d(axis.x, axis.y, axis.z, Math.toRadians(angle));
            t.setRotation(aa);
            this.setTransform(t);
        }

        public void rotateAxis(Vector3D axis, double angle) {
            if (angle == 0.0) {
                return;
            }
            Transform3D t = this.getTransform();
            Vector3D aRel = this.absToRel(axis);
            AxisAngle4d aa = new AxisAngle4d(aRel.x, aRel.y, aRel.z, Math.toRadians(angle));
            Transform3D t1 = new Transform3D();
            t1.setRotation(aa);
            t.mul(t1);
            this.setTransform(t);
        }

        public void move(double x, double y, double z) {
            this.move(new Vector3D(x, y, z));
        }

        public void move(Vector3D move) {
            Transform3D t = this.getTransform();
            Vector3f r = new Vector3f();
            t.get(r);
            r.add((Tuple3f)StdDraw3D.createVector3f(move));
            t.setTranslation(r);
            this.setTransform(t);
        }

        public void moveRelative(double right, double up, double forward) {
            this.moveRelative(new Vector3D(right, up, forward));
        }

        public void moveRelative(Vector3D move) {
            this.move(this.relToAbs(move.times(1.0, 1.0, -1.0)));
        }

        public void setPosition(double x, double y, double z) {
            this.setPosition(new Vector3D(x, y, z));
        }

        public void setPosition(Vector3D pos) {
            Transform3D t = this.getTransform();
            t.setTranslation(StdDraw3D.createVector3f(pos));
            this.setTransform(t);
        }

        public Vector3D getPosition() {
            Transform3D t = this.getTransform();
            Vector3d r = new Vector3d();
            t.get(r);
            return new Vector3D(r);
        }

        public void rotate(double xAngle, double yAngle, double zAngle) {
            this.rotate(new Vector3D(xAngle, yAngle, zAngle));
        }

        public void rotate(Vector3D angles) {
            Transform3D t = this.getTransform();
            Transform3D tX = new Transform3D();
            Transform3D tY = new Transform3D();
            Transform3D tZ = new Transform3D();
            Vector3D xR = this.absToRel(xAxis);
            Vector3D yR = this.absToRel(yAxis);
            Vector3D zR = this.absToRel(zAxis);
            Vector3D radians = angles.times(Math.PI / 180);
            tX.setRotation(new AxisAngle4d(xR.x, xR.y, xR.z, radians.x));
            tY.setRotation(new AxisAngle4d(yR.x, yR.y, yR.z, radians.y));
            tZ.setRotation(new AxisAngle4d(zR.x, zR.y, zR.z, radians.z));
            t.mul(tX);
            t.mul(tY);
            t.mul(tZ);
            this.setTransform(t);
        }

        public void rotateRelative(double pitch, double yaw, double roll) {
            this.rotateRelative(new Vector3D(pitch, yaw, roll));
        }

        public void rotateRelative(Vector3D angles) {
            Transform3D t = this.getTransform();
            Transform3D tX = new Transform3D();
            Transform3D tY = new Transform3D();
            Transform3D tZ = new Transform3D();
            Vector3D radians = angles.times(Math.PI / 180);
            tX.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, radians.x));
            tY.setRotation(new AxisAngle4d(0.0, 1.0, 0.0, radians.y));
            tZ.setRotation(new AxisAngle4d(0.0, 0.0, 1.0, radians.z));
            t.mul(tX);
            t.mul(tY);
            t.mul(tZ);
            this.setTransform(t);
        }

        public void setOrientation(double xAngle, double yAngle, double zAngle) {
            this.setOrientation(new Vector3D(xAngle, yAngle, zAngle));
        }

        public void setOrientation(Vector3D angles) {
            if (Math.abs(angles.y) == 90.0) {
                System.err.println("Gimbal lock when the y-angle is vertical!");
            }
            Transform3D t = this.getTransform();
            Vector3D radians = angles.times(Math.PI / 180);
            Transform3D t1 = new Transform3D();
            t1.setEuler(StdDraw3D.createVector3d(radians));
            Vector3d r = new Vector3d();
            t.get(r);
            t1.setTranslation(r);
            t1.setScale(t.getScale());
            this.setTransform(t1);
        }

        public Vector3D getOrientation() {
            double zA;
            double xA;
            Transform3D t = this.getTransform();
            Matrix3d mat = new Matrix3d();
            t.get(mat);
            double yA = -Math.asin(mat.m20);
            double C = Math.cos(yA);
            if (Math.abs(C) > 0.005) {
                xA = -Math.atan2(-mat.m21 / C, mat.m22 / C);
                zA = -Math.atan2(-mat.m10 / C, mat.m00 / C);
            } else {
                xA = 0.0;
                zA = -Math.atan2(mat.m01, mat.m11);
            }
            xA = Math.toDegrees(xA);
            yA = Math.toDegrees(yA);
            zA = Math.toDegrees(zA);
            if (xA < 0.0) {
                xA += 360.0;
            }
            if (yA < 0.0) {
                yA += 360.0;
            }
            if (zA < 0.0) {
                zA += 360.0;
            }
            return new Vector3D(xA, yA, zA);
        }

        public void lookAt(Vector3D center) {
            this.lookAt(center, yAxis);
        }

        public void lookAt(Vector3D center, Vector3D up) {
            Transform3D t = this.getTransform();
            Transform3D t2 = new Transform3D(t);
            Vector3f translation = new Vector3f();
            t2.get(translation);
            Vector3d scales = new Vector3d();
            t2.getScale(scales);
            Point3d trans = new Point3d((Tuple3f)translation);
            Point3d c = new Point3d(center.x, center.y, center.z);
            Vector3d u = StdDraw3D.createVector3d(up);
            t2.lookAt(trans, c, u);
            try {
                t2.invert();
                t2.setScale(scales);
                this.setTransform(t2);
            }
            catch (SingularMatrixException sme) {
                System.out.println("Singular matrix, bad lookAt()!");
            }
        }

        public void setDirection(Vector3D direction) {
            this.setDirection(direction, yAxis);
        }

        public void setDirection(Vector3D direction, Vector3D up) {
            Vector3D center = this.getPosition().plus(direction);
            this.lookAt(center, up);
        }

        public Vector3D getDirection() {
            return this.relToAbs(zAxis.times(-1.0)).direction();
        }

        private void match(Transformable s) {
            this.setOrientation(s.getOrientation());
            this.setPosition(s.getPosition());
        }
    }
}

