package com.github.gpluscb.ggjava.entity.object.response.objects;

import com.github.gpluscb.ggjava.entity.EntityType;
import com.github.gpluscb.ggjava.entity.object.response.AbstractGGResponseObject;
import com.github.gpluscb.ggjava.entity.object.response.scalars.IDResponse;
import com.github.gpluscb.ggjava.entity.object.response.scalars.StringResponse;

/**
 * Used for league application tiers
 */
public class EventTierResponse extends AbstractGGResponseObject {
	private final IDResponse id;
	private final StringResponse name;

	public EventTierResponse() {
		super(EntityType.EVENT_TIER);

		id = null;
		name = null;
	}

	public EventTierResponse(IDResponse id, StringResponse name) {
		super(EntityType.EVENT_TIER, true);
		this.id = id;
		this.name = name;
	}

	public IDResponse getId() {
		checkProvided();
		return id;
	}

	/**
	 * Name of this tier
	 */
	public StringResponse getName() {
		checkProvided();
		return name;
	}
}
