package com.github.gpluscb.ggjava.entity.object.response.objects;

import com.github.gpluscb.ggjava.entity.EntityType;
import com.github.gpluscb.ggjava.entity.object.response.AbstractGGResponseObject;
import com.github.gpluscb.ggjava.entity.object.response.ListResponse;
import com.github.gpluscb.ggjava.entity.object.response.scalars.StringResponse;

/**
 * A Stream queue object
 */
public class StreamQueueResponse extends AbstractGGResponseObject {
	private final StringResponse id;
	private final ListResponse<SetResponse> sets;
	private final StreamsResponse stream;

	public StreamQueueResponse() {
		super(EntityType.STREAM_QUEUE);

		id = null;
		sets = null;
		stream = null;
	}

	public StreamQueueResponse(StringResponse id, ListResponse<SetResponse> sets, StreamsResponse stream) {
		super(EntityType.STREAM_QUEUE, true);
		this.id = id;
		this.sets = sets;
		this.stream = stream;
	}

	public StringResponse getId() {
		checkProvided();
		return id;
	}

	/**
	 * The sets on the stream
	 */
	public ListResponse<SetResponse> getSets() {
		checkProvided();
		return sets;
	}

	/**
	 * The stream on the queue
	 */
	public StreamsResponse getStream() {
		checkProvided();
		return stream;
	}
}
