package com.github.gpluscb.ggjava.entity.object.response.objects;

import com.github.gpluscb.ggjava.entity.EntityType;
import com.github.gpluscb.ggjava.entity.object.response.AbstractGGResponseObject;
import com.github.gpluscb.ggjava.entity.object.response.ListResponse;
import com.github.gpluscb.ggjava.entity.object.response.scalars.IDResponse;
import com.github.gpluscb.ggjava.entity.object.response.scalars.StringResponse;

/**
 * A team, usually within the context of an event
 */
public class TeamResponse extends AbstractGGResponseObject {
	private final IDResponse id;
	private final StringResponse discriminator;
	private final EntrantResponse entrant;
	private final EventResponse event;
	private final ListResponse<ImageResponse> images;
	private final StringResponse name;

	public TeamResponse() {
		super(EntityType.TEAM);

		id = null;
		discriminator = null;
		entrant = null;
		event = null;
		images = null;
		name = null;
	}

	public TeamResponse(IDResponse id, StringResponse discriminator, EntrantResponse entrant, EventResponse event, ListResponse<ImageResponse> images, StringResponse name) {
		super(EntityType.TEAM, true);
		this.id = id;
		this.discriminator = discriminator;
		this.entrant = entrant;
		this.event = event;
		this.images = images;
		this.name = name;
	}

	public IDResponse getId() {
		checkProvided();
		return id;
	}

	/**
	 * Uniquely identifying token for team. Same as the hashed part of the slug
	 */
	public StringResponse getDiscriminator() {
		checkProvided();
		return discriminator;
	}

	public EntrantResponse getEntrant() {
		checkProvided();
		return entrant;
	}

	public EventResponse getEvent() {
		checkProvided();
		return event;
	}

	public ListResponse<ImageResponse> getImages() {
		checkProvided();
		return images;
	}

	public StringResponse getName() {
		checkProvided();
		return name;
	}
}
