/*
 * Decompiled with CFR 0.152.
 */
package rx.testkit;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import rx.Completable;
import rx.Subscriber;
import rx.observers.TestSubscriber;
import rx.schedulers.TestScheduler;

public class AssertCompletable
extends AbstractAssert<AssertCompletable, Completable> {
    private final TestSubscriber subscriber = new TestSubscriber();
    private TestScheduler scheduler;

    private AssertCompletable(Completable completable) {
        super((Object)completable, AssertCompletable.class);
        completable.subscribe((Subscriber)this.subscriber);
    }

    private AssertCompletable(Completable completable, TestScheduler scheduler) {
        super((Object)completable, AssertCompletable.class);
        this.scheduler = scheduler;
        completable.subscribe((Subscriber)this.subscriber);
    }

    public static AssertCompletable assertThat(Completable completable) {
        return new AssertCompletable(completable);
    }

    public static AssertCompletable assertThat(Completable completable, TestScheduler scheduler) {
        return new AssertCompletable(completable, scheduler);
    }

    public AssertCompletable after(long duration, TimeUnit timeUnit) {
        if (this.scheduler == null) {
            throw new IllegalStateException("No TestScheduler provided. Perhaps you forgot to 'assertThat(Observable, TestScheduler)'?");
        }
        this.scheduler.advanceTimeBy(duration, timeUnit);
        return this;
    }

    public AssertCompletable hasCompleted() {
        this.subscriber.assertCompleted();
        return this;
    }

    public AssertCompletable hasNotCompleted() {
        this.subscriber.assertNotCompleted();
        return this;
    }

    public AbstractListAssert<?, ? extends List<? extends Throwable>, Throwable> failures() {
        return Assertions.assertThat((List)this.subscriber.getOnErrorEvents());
    }
}

