/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/jasync/sql/db/util/DaemonThreadsFactory;", "Ljava/util/concurrent/ThreadFactory;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "toString", "jasync-common"})
public final class DaemonThreadsFactory
implements ThreadFactory {
    @NotNull
    private final String name;
    @NotNull
    private final AtomicInteger threadNumber;

    public DaemonThreadsFactory(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.threadNumber = new AtomicInteger(1);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setDaemon(true);
        String threadName = this.name + "-thread-" + this.threadNumber.getAndIncrement();
        thread.setName(threadName);
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
        return thread;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final DaemonThreadsFactory copy(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new DaemonThreadsFactory(name);
    }

    public static /* synthetic */ DaemonThreadsFactory copy$default(DaemonThreadsFactory daemonThreadsFactory, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = daemonThreadsFactory.name;
        }
        return daemonThreadsFactory.copy(string);
    }

    @NotNull
    public String toString() {
        return "DaemonThreadsFactory(name=" + this.name + ')';
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DaemonThreadsFactory)) {
            return false;
        }
        DaemonThreadsFactory daemonThreadsFactory = (DaemonThreadsFactory)other;
        return Intrinsics.areEqual((Object)this.name, (Object)daemonThreadsFactory.name);
    }
}

