/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.codec;

import com.github.jasync.sql.db.column.BigDecimalEncoderDecoder;
import com.github.jasync.sql.db.column.ByteDecoder;
import com.github.jasync.sql.db.column.ColumnDecoder;
import com.github.jasync.sql.db.column.DateEncoderDecoder;
import com.github.jasync.sql.db.column.DoubleEncoderDecoder;
import com.github.jasync.sql.db.column.FloatEncoderDecoder;
import com.github.jasync.sql.db.column.IntegerEncoderDecoder;
import com.github.jasync.sql.db.column.LocalDateTimeEncoderDecoder;
import com.github.jasync.sql.db.column.LongEncoderDecoder;
import com.github.jasync.sql.db.column.ShortEncoderDecoder;
import com.github.jasync.sql.db.column.StringEncoderDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.BigDecimalDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.BinaryDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.ByteArrayDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.DateDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.DoubleDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.FloatDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.IntegerDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.LongDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.NullDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.ShortDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.StringDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.TimeDecoder;
import com.github.jasync.sql.db.mysql.binary.decoder.TimestampDecoder;
import com.github.jasync.sql.db.mysql.column.ByteArrayColumnDecoder;
import com.github.jasync.sql.db.mysql.column.ColumnTypes;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/jasync/sql/db/mysql/codec/DecoderRegistry;", "", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "bigDecimalDecoder", "Lcom/github/jasync/sql/db/mysql/binary/decoder/BigDecimalDecoder;", "stringDecoder", "Lcom/github/jasync/sql/db/mysql/binary/decoder/StringDecoder;", "binaryDecoderFor", "Lcom/github/jasync/sql/db/mysql/binary/decoder/BinaryDecoder;", "columnType", "", "charsetCode", "textDecoderFor", "Lcom/github/jasync/sql/db/column/ColumnDecoder;", "jasync-mysql"})
@SourceDebugExtension(value={"SMAP\nDecoderRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecoderRegistry.kt\ncom/github/jasync/sql/db/mysql/codec/DecoderRegistry\n+ 2 KotlinUtils.kt\ncom/github/jasync/sql/db/util/KotlinUtilsKt\n*L\n1#1,109:1\n6#2:110\n*S KotlinDebug\n*F\n+ 1 DecoderRegistry.kt\ncom/github/jasync/sql/db/mysql/codec/DecoderRegistry\n*L\n71#1:110\n*E\n"})
public final class DecoderRegistry {
    @NotNull
    private final BigDecimalDecoder bigDecimalDecoder;
    @NotNull
    private final StringDecoder stringDecoder;

    public DecoderRegistry(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.bigDecimalDecoder = new BigDecimalDecoder(charset);
        this.stringDecoder = new StringDecoder(charset);
    }

    @NotNull
    public final BinaryDecoder binaryDecoderFor(int columnType, int charsetCode) {
        BinaryDecoder binaryDecoder;
        int n = columnType;
        if ((n == ColumnTypes.INSTANCE.getFIELD_TYPE_VARCHAR() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_JSON()) ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_ENUM()) {
            binaryDecoder = this.stringDecoder;
        } else if (((((n == ColumnTypes.INSTANCE.getFIELD_TYPE_BLOB() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_LONG_BLOB()) ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_MEDIUM_BLOB()) ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_TINY_BLOB()) ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_VAR_STRING()) ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_STRING()) {
            binaryDecoder = charsetCode == 63 ? (BinaryDecoder)ByteArrayDecoder.INSTANCE : (BinaryDecoder)this.stringDecoder;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_BIT()) {
            binaryDecoder = ByteArrayDecoder.INSTANCE;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_LONGLONG()) {
            binaryDecoder = LongDecoder.INSTANCE;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_LONG() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_INT24()) {
            binaryDecoder = IntegerDecoder.INSTANCE;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_YEAR() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_SHORT()) {
            binaryDecoder = ShortDecoder.INSTANCE;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_TINY()) {
            binaryDecoder = com.github.jasync.sql.db.mysql.binary.decoder.ByteDecoder.INSTANCE;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_DOUBLE()) {
            binaryDecoder = DoubleDecoder.INSTANCE;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_FLOAT()) {
            binaryDecoder = FloatDecoder.INSTANCE;
        } else if ((n == ColumnTypes.INSTANCE.getFIELD_TYPE_NUMERIC() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_DECIMAL()) ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_NEW_DECIMAL()) {
            binaryDecoder = this.bigDecimalDecoder;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_DATETIME() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_TIMESTAMP()) {
            binaryDecoder = TimestampDecoder.INSTANCE;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_DATE()) {
            binaryDecoder = DateDecoder.INSTANCE;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_TIME()) {
            binaryDecoder = TimeDecoder.INSTANCE;
        } else if (n == ColumnTypes.INSTANCE.getFIELD_TYPE_NULL()) {
            binaryDecoder = NullDecoder.INSTANCE;
        } else {
            String reason$iv = "not implemenetd for " + columnType;
            boolean $i$f$XXX = false;
            throw new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
        }
        return binaryDecoder;
    }

    @NotNull
    public final ColumnDecoder textDecoderFor(int columnType, int charsetCode) {
        int n = columnType;
        return n == ColumnTypes.INSTANCE.getFIELD_TYPE_DATE() ? (ColumnDecoder)DateEncoderDecoder.INSTANCE : ((n == ColumnTypes.INSTANCE.getFIELD_TYPE_DATETIME() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_TIMESTAMP()) ? (ColumnDecoder)LocalDateTimeEncoderDecoder.INSTANCE : (((n == ColumnTypes.INSTANCE.getFIELD_TYPE_DECIMAL() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_NEW_DECIMAL()) ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_NUMERIC()) ? (ColumnDecoder)BigDecimalEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_DOUBLE() ? (ColumnDecoder)DoubleEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_FLOAT() ? (ColumnDecoder)FloatEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_INT24() ? (ColumnDecoder)IntegerEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_LONG() ? (ColumnDecoder)IntegerEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_LONGLONG() ? (ColumnDecoder)LongEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_NEWDATE() ? (ColumnDecoder)DateEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_SHORT() ? (ColumnDecoder)ShortEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_TIME() ? (ColumnDecoder)com.github.jasync.sql.db.mysql.column.TimeDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_TINY() ? (ColumnDecoder)ByteDecoder.INSTANCE : ((n == ColumnTypes.INSTANCE.getFIELD_TYPE_VARCHAR() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_ENUM()) ? (ColumnDecoder)StringEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_YEAR() ? (ColumnDecoder)ShortEncoderDecoder.INSTANCE : (n == ColumnTypes.INSTANCE.getFIELD_TYPE_BIT() ? (ColumnDecoder)ByteArrayColumnDecoder.INSTANCE : (((n == ColumnTypes.INSTANCE.getFIELD_TYPE_BLOB() ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_VAR_STRING()) ? true : n == ColumnTypes.INSTANCE.getFIELD_TYPE_STRING()) ? (charsetCode == 63 ? (ColumnDecoder)ByteArrayColumnDecoder.INSTANCE : (ColumnDecoder)StringEncoderDecoder.INSTANCE) : (ColumnDecoder)StringEncoderDecoder.INSTANCE)))))))))))))));
    }
}

