/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.exceptions;

import com.github.jasync.sql.db.exceptions.DatabaseException;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationResponseType;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/postgresql/exceptions/MissingCredentialInformationException;", "Lcom/github/jasync/sql/db/exceptions/DatabaseException;", "username", "", "password", "authenticationResponseType", "Lcom/github/jasync/sql/db/postgresql/messages/backend/AuthenticationResponseType;", "(Ljava/lang/String;Ljava/lang/String;Lcom/github/jasync/sql/db/postgresql/messages/backend/AuthenticationResponseType;)V", "getPassword", "()Ljava/lang/String;", "getUsername", "jasync-postgresql"})
public final class MissingCredentialInformationException
extends DatabaseException {
    @NotNull
    private final String username;
    @Nullable
    private final String password;
    private final AuthenticationResponseType authenticationResponseType;

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public MissingCredentialInformationException(@NotNull String username, @Nullable String password, @NotNull AuthenticationResponseType authenticationResponseType) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)((Object)authenticationResponseType), (String)"authenticationResponseType");
        String string = "Username and password were required by auth type %s but are not available (username=<%s> password=<%s>";
        Object[] objectArray = new Object[]{authenticationResponseType, username, password};
        MissingCredentialInformationException missingCredentialInformationException = this;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        String string3 = string2;
        super(string3);
        this.username = username;
        this.password = password;
        this.authenticationResponseType = authenticationResponseType;
    }
}

