/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.codec;

import com.github.jasync.sql.db.exceptions.NegativeMessageSizeException;
import com.github.jasync.sql.db.postgresql.codec.MessageDecoderKt;
import com.github.jasync.sql.db.postgresql.exceptions.MessageTooLongException;
import com.github.jasync.sql.db.postgresql.messages.backend.SSLResponseMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ServerMessage;
import com.github.jasync.sql.db.postgresql.parsers.AuthenticationStartupParser;
import com.github.jasync.sql.db.postgresql.parsers.MessageParsersRegistry;
import com.github.jasync.sql.db.util.BufferDumper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/jasync/sql/db/postgresql/codec/MessageDecoder;", "Lio/netty/handler/codec/ByteToMessageDecoder;", "sslEnabled", "", "charset", "Ljava/nio/charset/Charset;", "maximumMessageSize", "", "(ZLjava/nio/charset/Charset;I)V", "getCharset", "()Ljava/nio/charset/Charset;", "parser", "Lcom/github/jasync/sql/db/postgresql/parsers/MessageParsersRegistry;", "sslChecked", "decode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "b", "Lio/netty/buffer/ByteBuf;", "out", "", "", "jasync-postgresql"})
public final class MessageDecoder
extends ByteToMessageDecoder {
    private final MessageParsersRegistry parser;
    private boolean sslChecked;
    private final boolean sslEnabled;
    @NotNull
    private final Charset charset;
    private final int maximumMessageSize;

    public void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf b, @NotNull List<Object> out) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter(out, (String)"out");
        if (this.sslEnabled && !this.sslChecked) {
            byte code = b.readByte();
            MessageDecoderKt.access$getLogger$p().trace((Function0)new Function0<Object>(code, b){
                final /* synthetic */ byte $code;
                final /* synthetic */ ByteBuf $b;

                @Nullable
                public final Object invoke() {
                    return "Received buffer " + (char)this.$code + '(' + this.$code + ")\n" + BufferDumper.dumpAsHex((ByteBuf)this.$b);
                }
                {
                    this.$code = by;
                    this.$b = byteBuf;
                    super(0);
                }
            });
            this.sslChecked = true;
            out.add(new SSLResponseMessage((char)code == 'S'));
        } else if (b.readableBytes() >= 5) {
            b.markReaderIndex();
            byte code = b.readByte();
            int lengthWithSelf = b.readInt();
            int length = lengthWithSelf - 4;
            if (length < 0) {
                throw (Throwable)new NegativeMessageSizeException(code, length);
            }
            if (length > this.maximumMessageSize) {
                throw (Throwable)((Object)new MessageTooLongException(code, length, this.maximumMessageSize));
            }
            if (b.readableBytes() >= length) {
                ServerMessage serverMessage;
                MessageDecoderKt.access$getLogger$p().trace((Function0)new Function0<Object>(code, b){
                    final /* synthetic */ byte $code;
                    final /* synthetic */ ByteBuf $b;

                    @Nullable
                    public final Object invoke() {
                        return "Received buffer " + (char)this.$code + '(' + this.$code + ")\n" + BufferDumper.dumpAsHex((ByteBuf)this.$b);
                    }
                    {
                        this.$code = by;
                        this.$b = byteBuf;
                        super(0);
                    }
                });
                switch (code) {
                    case 82: {
                        ByteBuf byteBuf = b.readSlice(length);
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"b.readSlice(length)");
                        serverMessage = AuthenticationStartupParser.INSTANCE.parseMessage(byteBuf);
                        break;
                    }
                    default: {
                        ByteBuf byteBuf = b.readSlice(length);
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"b.readSlice(length)");
                        serverMessage = this.parser.parse(code, byteBuf);
                    }
                }
                ServerMessage result = serverMessage;
                out.add(result);
            } else {
                b.resetReaderIndex();
                return;
            }
        }
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public MessageDecoder(boolean sslEnabled, @NotNull Charset charset, int maximumMessageSize) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.sslEnabled = sslEnabled;
        this.charset = charset;
        this.maximumMessageSize = maximumMessageSize;
        this.parser = new MessageParsersRegistry(this.charset);
    }

    public /* synthetic */ MessageDecoder(boolean bl, Charset charset, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0x1000000;
        }
        this(bl, charset, n);
    }
}

