/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.encoders;

import com.github.jasync.sql.db.postgresql.encoders.Encoder;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PasswordMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.SASLInitialResponse;
import com.github.jasync.sql.db.postgresql.messages.frontend.SASLResponse;
import com.github.jasync.sql.db.postgresql.util.PasswordHelper;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/github/jasync/sql/db/postgresql/encoders/PasswordEncoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/Encoder;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "encodeSASLInitialResponse", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/SASLInitialResponse;", "encodeSASLResponse", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/SASLResponse;", "encodeSimplePassword", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/PasswordMessage;", "jasync-postgresql"})
public final class PasswordEncoder
implements Encoder {
    @NotNull
    private final Charset charset;

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        ByteBuf byteBuf;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = message.getKind() == 112;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ClientMessage clientMessage = message;
        if (clientMessage instanceof PasswordMessage) {
            byteBuf = this.encodeSimplePassword((PasswordMessage)message);
        } else if (clientMessage instanceof SASLInitialResponse) {
            byteBuf = this.encodeSASLInitialResponse((SASLInitialResponse)message);
        } else if (clientMessage instanceof SASLResponse) {
            byteBuf = this.encodeSASLResponse((SASLResponse)message);
        } else {
            String reason$iv = "Unknown password message type " + message.getClass();
            boolean $i$f$XXX = false;
            throw (Throwable)new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
        }
        return byteBuf;
    }

    private final ByteBuf encodeSimplePassword(PasswordMessage message) {
        byte[] byArray;
        boolean bl;
        String string;
        if (message.getSalt() == null) {
            string = message.getPassword();
            Charset charset = this.charset;
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string2.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        } else {
            byArray = PasswordHelper.encode(message.getUsername(), message.getPassword(), message.getSalt(), this.charset);
        }
        byte[] password = byArray;
        string = Unpooled.buffer((int)(5 + password.length + 1));
        boolean bl2 = false;
        bl = false;
        String $this$apply = string;
        boolean bl3 = false;
        $this$apply.writeByte(112);
        $this$apply.writeInt(0);
        $this$apply.writeBytes(password);
        $this$apply.writeByte(0);
        ByteBufferUtils.writeLength((ByteBuf)$this$apply);
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Unpooled.buffer(1 + 4 + \u2026iteLength(this)\n        }");
        return string3;
    }

    private final ByteBuf encodeSASLInitialResponse(SASLInitialResponse message) {
        ByteBuf byteBuf = Unpooled.buffer((int)(5 + message.getMechanism().length() + 1 + 4 + message.getSaslData().length()));
        boolean bl = false;
        boolean bl2 = false;
        ByteBuf $this$apply = byteBuf;
        boolean bl3 = false;
        $this$apply.writeByte(112);
        $this$apply.writeInt(0);
        String string = message.getMechanism();
        Charset charset = this.charset;
        boolean bl4 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        $this$apply.writeBytes(byArray);
        $this$apply.writeByte(0);
        $this$apply.writeInt(message.getSaslData().length());
        string = message.getSaslData();
        charset = this.charset;
        bl4 = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        $this$apply.writeBytes(byArray2);
        ByteBufferUtils.writeLength((ByteBuf)$this$apply);
        ByteBuf byteBuf2 = byteBuf;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"Unpooled.buffer(1 + 4 + \u2026iteLength(this)\n        }");
        return byteBuf2;
    }

    private final ByteBuf encodeSASLResponse(SASLResponse message) {
        ByteBuf byteBuf = Unpooled.buffer((int)(5 + message.getSaslData().length()));
        boolean bl = false;
        boolean bl2 = false;
        ByteBuf $this$apply = byteBuf;
        boolean bl3 = false;
        $this$apply.writeByte(112);
        $this$apply.writeInt(0);
        String string = message.getSaslData();
        Charset charset = this.charset;
        boolean bl4 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        $this$apply.writeBytes(byArray);
        ByteBufferUtils.writeLength((ByteBuf)$this$apply);
        ByteBuf byteBuf2 = byteBuf;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"Unpooled.buffer(1 + 4 + \u2026iteLength(this)\n        }");
        return byteBuf2;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public PasswordEncoder(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
    }
}

