/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql;

import com.github.jasync.sql.db.ConcreteConnectionBase;
import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.ResultSet;
import com.github.jasync.sql.db.ResultSetKt;
import com.github.jasync.sql.db.column.ColumnDecoderRegistry;
import com.github.jasync.sql.db.column.ColumnEncoderRegistry;
import com.github.jasync.sql.db.exceptions.ConnectionStillRunningQueryException;
import com.github.jasync.sql.db.exceptions.InsufficientParametersException;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.general.MutableResultSet;
import com.github.jasync.sql.db.interceptor.PreparedStatementParams;
import com.github.jasync.sql.db.pool.TimeoutScheduler;
import com.github.jasync.sql.db.pool.TimeoutSchedulerImpl;
import com.github.jasync.sql.db.postgresql.PostgreSQLConnectionKt;
import com.github.jasync.sql.db.postgresql.PreparedStatementHolder;
import com.github.jasync.sql.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.jasync.sql.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.jasync.sql.db.postgresql.column.PostgreSQLColumnDecoderRegistry;
import com.github.jasync.sql.db.postgresql.column.PostgreSQLColumnEncoderRegistry;
import com.github.jasync.sql.db.postgresql.exceptions.AuthenticationException;
import com.github.jasync.sql.db.postgresql.exceptions.GenericDatabaseException;
import com.github.jasync.sql.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.jasync.sql.db.postgresql.exceptions.PendingCloseStatementException;
import com.github.jasync.sql.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationCleartextPasswordMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationMD5PasswordMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationSASLContinueMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationSASLFinalMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationSASLMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationSimpleChallenge;
import com.github.jasync.sql.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.DataRowMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ErrorMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.NotificationResponse;
import com.github.jasync.sql.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.jasync.sql.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PasswordMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementCloseMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.QueryMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.SASLInitialResponse;
import com.github.jasync.sql.db.postgresql.messages.frontend.SASLResponse;
import com.github.jasync.sql.db.postgresql.util.URLParser;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import com.github.jasync.sql.db.util.FP;
import com.github.jasync.sql.db.util.FutureUtilsKt;
import com.github.jasync.sql.db.util.VersionKt;
import com.ongres.scram.client.ScramClient;
import com.ongres.scram.client.ScramSession;
import com.ongres.scram.common.exception.ScramException;
import com.ongres.scram.common.stringprep.StringPreparation;
import com.ongres.scram.common.stringprep.StringPreparations;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0081\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002\u0081\u0001BJ\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010C\u001a\u000201J\u0014\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u00160\u0015H\u0002J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016H\u0016J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\u0010\u0010K\u001a\u0002012\u0006\u0010L\u001a\u00020-H\u0002J\b\u0010M\u001a\u00020\u0012H\u0016J\b\u0010N\u001a\u00020\u0012H\u0016J\b\u0010O\u001a\u00020\u0012H\u0016J\u0006\u0010P\u001a\u00020\u0012J\b\u0010Q\u001a\u00020\u0012H\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0018\u0010R\u001a\u0002012\u0006\u0010S\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020\u0012H\u0002J\u0010\u0010U\u001a\u0002012\u0006\u0010V\u001a\u00020WH\u0016J\b\u0010X\u001a\u000201H\u0016J\u0010\u0010Y\u001a\u0002012\u0006\u0010V\u001a\u00020ZH\u0016J\b\u0010[\u001a\u000201H\u0002J\u0010\u0010\\\u001a\u0002012\u0006\u0010V\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u0002012\u0006\u0010V\u001a\u00020_H\u0016J\u0010\u0010^\u001a\u0002012\u0006\u0010`\u001a\u00020-H\u0016J\u0010\u0010a\u001a\u0002012\u0006\u0010V\u001a\u000200H\u0016J\u0010\u0010b\u001a\u0002012\u0006\u0010V\u001a\u00020cH\u0016J\b\u0010d\u001a\u000201H\u0002J\b\u0010e\u001a\u000201H\u0016J\u0010\u0010f\u001a\u0002012\u0006\u0010V\u001a\u00020gH\u0016J\u0012\u0010h\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0iJ\u0014\u0010j\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u00160\u0015H\u0002J\u001a\u0010k\u001a\u0002012\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010\fJ\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010n\u001a\u00020\u001cH\u0016J\u0016\u0010o\u001a\b\u0012\u0004\u0012\u0002080\u00162\u0006\u0010p\u001a\u00020qH\u0016J\u0016\u0010r\u001a\b\u0012\u0004\u0012\u0002080\u00162\u0006\u0010n\u001a\u00020\u001cH\u0016J\u0016\u0010s\u001a\u0002012\f\u0010t\u001a\b\u0012\u0004\u0012\u00020$03H\u0002J\u0010\u0010u\u001a\u0002012\u0006\u0010v\u001a\u00020-H\u0002J\u0016\u0010w\u001a\u0002012\f\u0010x\u001a\b\u0012\u0004\u0012\u0002080\u0016H\u0002J\u0010\u0010y\u001a\u0002012\u0006\u0010z\u001a\u000208H\u0002J\b\u0010{\u001a\u00020\u001cH\u0016J\u001a\u0010|\u001a\u0002012\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010\fJ\u000e\u0010}\u001a\u0002012\u0006\u0010S\u001a\u00020\u001cJ\u0010\u0010~\u001a\u0002012\u0006\u0010n\u001a\u00020\u001cH\u0002J\u0011\u0010\u007f\u001a\u0002012\u0007\u0010V\u001a\u00030\u0080\u0001H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#0\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000Rb\u0010.\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000201 2*\u0010\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000201\u0018\u00010\f0\f 2**\u0012$\u0012\"\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000201 2*\u0010\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000201\u0018\u00010\f0\f\u0018\u0001030/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c05X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001705X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u00160\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00109\u001a\b\u0012\u0004\u0012\u0002080\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0018\u00010=R\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010@\u001a\u00060Aj\u0002`BX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0082\u0001"}, d2={"Lcom/github/jasync/sql/db/postgresql/PostgreSQLConnection;", "Lcom/github/jasync/sql/db/ConcreteConnectionBase;", "Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionDelegate;", "Lcom/github/jasync/sql/db/Connection;", "Lcom/github/jasync/sql/db/pool/TimeoutScheduler;", "configuration", "Lcom/github/jasync/sql/db/Configuration;", "encoderRegistry", "Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "decoderRegistry", "Lcom/github/jasync/sql/db/column/ColumnDecoderRegistry;", "withDelegate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "delegate", "(Lcom/github/jasync/sql/db/Configuration;Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;Lcom/github/jasync/sql/db/column/ColumnDecoderRegistry;Lkotlin/jvm/functions/Function1;)V", "authenticated", "", "closeStatementReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/Optional;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/github/jasync/sql/db/postgresql/PreparedStatementHolder;", "connectionFuture", "connectionHandler", "Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionHandler;", "connectionId", "", "createTimeoutSchedulerImpl", "Lcom/github/jasync/sql/db/pool/TimeoutSchedulerImpl;", "currentCount", "", "currentPreparedStatement", "currentQuery", "Lcom/github/jasync/sql/db/general/MutableResultSet;", "Lcom/github/jasync/sql/db/postgresql/messages/backend/PostgreSQLColumnData;", "getDecoderRegistry", "()Lcom/github/jasync/sql/db/column/ColumnDecoderRegistry;", "getEncoderRegistry", "()Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "id", "getId", "()Ljava/lang/String;", "lastException", "", "notifyListeners", "", "Lcom/github/jasync/sql/db/postgresql/messages/backend/NotificationResponse;", "", "kotlin.jvm.PlatformType", "", "parameterStatus", "", "parsedStatements", "queryPromiseReference", "Lcom/github/jasync/sql/db/QueryResult;", "queryResult", "queryTimeoutSchedulerImpl", "recentError", "scramClientFinalProcessor", "Lcom/ongres/scram/client/ScramSession$ClientFinalProcessor;", "Lcom/ongres/scram/client/ScramSession;", "scramSession", "version", "Lkotlin/KotlinVersion;", "Lcom/github/jasync/sql/db/util/Version;", "clearNotifyListeners", "clearQueryPromise", "connect", "createPasswordMessage", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/PasswordMessage;", "authenticationMessage", "Lcom/github/jasync/sql/db/postgresql/messages/backend/AuthenticationSimpleChallenge;", "disconnect", "failQueryPromise", "t", "hasRecentError", "isConnected", "isQuerying", "isReadyForQuery", "isTimeout", "notReadyForQueryError", "errorMessage", "race", "onAuthenticationResponse", "message", "Lcom/github/jasync/sql/db/postgresql/messages/backend/AuthenticationMessage;", "onCloseComplete", "onCommandComplete", "Lcom/github/jasync/sql/db/postgresql/messages/backend/CommandCompleteMessage;", "onCreateTimeout", "onDataRow", "Lcom/github/jasync/sql/db/postgresql/messages/backend/DataRowMessage;", "onError", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ErrorMessage;", "throwable", "onNotificationResponse", "onParameterStatus", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ParameterStatusMessage;", "onQueryTimeout", "onReadyForQuery", "onRowDescription", "Lcom/github/jasync/sql/db/postgresql/messages/backend/RowDescriptionMessage;", "parameterStatuses", "", "queryPromise", "registerNotifyListener", "listener", "releasePreparedStatement", "query", "sendPreparedStatementDirect", "params", "Lcom/github/jasync/sql/db/interceptor/PreparedStatementParams;", "sendQueryDirect", "setColumnDatas", "columnDatas", "setErrorOnFutures", "e", "setQueryPromise", "promise", "succeedQueryPromise", "result", "toString", "unregisterNotifyListener", "validateIfItIsReadyForQuery", "validateQuery", "write", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "Companion", "jasync-postgresql"})
public final class PostgreSQLConnection
extends ConcreteConnectionBase
implements PostgreSQLConnectionDelegate,
Connection,
TimeoutScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnEncoderRegistry encoderRegistry;
    @NotNull
    private final ColumnDecoderRegistry decoderRegistry;
    @NotNull
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    @NotNull
    private final String connectionId;
    @NotNull
    private final String id;
    @NotNull
    private final Map<String, String> parameterStatus;
    @NotNull
    private final Map<String, PreparedStatementHolder> parsedStatements;
    private boolean authenticated;
    @NotNull
    private final CompletableFuture<PostgreSQLConnection> connectionFuture;
    @NotNull
    private final TimeoutSchedulerImpl queryTimeoutSchedulerImpl;
    @NotNull
    private final TimeoutSchedulerImpl createTimeoutSchedulerImpl;
    private boolean recentError;
    @NotNull
    private final AtomicReference<Optional<CompletableFuture<QueryResult>>> queryPromiseReference;
    @NotNull
    private final AtomicReference<Optional<CompletableFuture<PreparedStatementHolder>>> closeStatementReference;
    @NotNull
    private Optional<MutableResultSet<PostgreSQLColumnData>> currentQuery;
    @NotNull
    private Optional<PreparedStatementHolder> currentPreparedStatement;
    @NotNull
    private KotlinVersion version;
    private final List<Function1<NotificationResponse, Unit>> notifyListeners;
    @NotNull
    private Optional<QueryResult> queryResult;
    @Nullable
    private Throwable lastException;
    @Nullable
    private ScramSession scramSession;
    @Nullable
    private ScramSession.ClientFinalProcessor scramClientFinalProcessor;
    @NotNull
    private static final AtomicLong Counter = new AtomicLong();
    @NotNull
    private static final String ServerVersionKey = "server_version";

    @JvmOverloads
    public PostgreSQLConnection(@NotNull Configuration configuration, @NotNull ColumnEncoderRegistry encoderRegistry, @NotNull ColumnDecoderRegistry decoderRegistry, @NotNull Function1<? super PostgreSQLConnectionDelegate, ? extends PostgreSQLConnectionDelegate> withDelegate) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)encoderRegistry, (String)"encoderRegistry");
        Intrinsics.checkNotNullParameter((Object)decoderRegistry, (String)"decoderRegistry");
        Intrinsics.checkNotNullParameter(withDelegate, (String)"withDelegate");
        super(configuration);
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, this.encoderRegistry, (PostgreSQLConnectionDelegate)withDelegate.invoke((Object)this), configuration.getEventLoopGroup(), configuration.getExecutionContext());
        this.currentCount = Counter.incrementAndGet();
        this.id = this.connectionId = "<postgres-connection-" + this.currentCount + '>';
        this.parameterStatus = new LinkedHashMap();
        this.parsedStatements = new LinkedHashMap();
        this.connectionFuture = new CompletableFuture();
        this.queryTimeoutSchedulerImpl = new TimeoutSchedulerImpl(configuration.getExecutionContext(), configuration.getEventLoopGroup(), (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                PostgreSQLConnection.access$onQueryTimeout((PostgreSQLConnection)this.receiver);
            }
        });
        this.createTimeoutSchedulerImpl = new TimeoutSchedulerImpl(configuration.getExecutionContext(), configuration.getEventLoopGroup(), (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                PostgreSQLConnection.access$onCreateTimeout((PostgreSQLConnection)this.receiver);
            }
        });
        this.queryPromiseReference = new AtomicReference(Optional.empty());
        this.closeStatementReference = new AtomicReference(Optional.empty());
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        this.currentQuery = optional;
        Optional optional2 = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty()");
        this.currentPreparedStatement = optional2;
        this.version = new KotlinVersion(0, 0, 0);
        this.notifyListeners = Collections.synchronizedList(new ArrayList());
        Optional optional3 = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty()");
        this.queryResult = optional3;
    }

    public /* synthetic */ PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry columnEncoderRegistry, ColumnDecoderRegistry columnDecoderRegistry, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            configuration = URLParser.INSTANCE.getDEFAULT();
        }
        if ((n & 2) != 0) {
            columnEncoderRegistry = PostgreSQLColumnEncoderRegistry.Companion.getInstance();
        }
        if ((n & 4) != 0) {
            columnDecoderRegistry = PostgreSQLColumnDecoderRegistry.Companion.getInstance();
        }
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(configuration, columnEncoderRegistry, columnDecoderRegistry, (Function1<? super PostgreSQLConnectionDelegate, ? extends PostgreSQLConnectionDelegate>)function1);
    }

    @NotNull
    public final ColumnEncoderRegistry getEncoderRegistry() {
        return this.encoderRegistry;
    }

    @NotNull
    public final ColumnDecoderRegistry getDecoderRegistry() {
        return this.decoderRegistry;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public final boolean isReadyForQuery() {
        return !this.queryPromise().isPresent();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<PostgreSQLConnection> connect() {
        CompletionStage<PostgreSQLConnection> completionStage;
        void $this$onFailureAsync$iv;
        this.createTimeoutSchedulerImpl.addTimeout(this.connectionFuture, Duration.ofMillis(this.getConfiguration().getConnectionTimeout()), this.connectionId);
        CompletableFuture<PostgreSQLConnectionHandler> completableFuture = this.connectionHandler.connect();
        Executor executor$iv = this.getConfiguration().getExecutionContext();
        boolean $i$f$onFailureAsync = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$onFailureAsync$iv.whenCompleteAsync(new BiConsumer(this){
            final /* synthetic */ PostgreSQLConnection this$0;
            {
                this.this$0 = postgreSQLConnection;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void accept(Object object, Throwable t) {
                if (t != null) {
                    Throwable e = t;
                    boolean bl = false;
                    FutureUtilsKt.failed((CompletableFuture)PostgreSQLConnection.access$getConnectionFuture$p(this.this$0), (Throwable)e);
                }
            }
        }, executor$iv), (String)"crossinline onFailureFun\u2026ailureFun(t) }, executor)");
        if (this.getConfiguration().getApplicationName() == null) {
            completionStage = this.connectionFuture;
        } else {
            String string = this.getConfiguration().getApplicationName();
            Intrinsics.checkNotNull((Object)string);
            String appName = StringsKt.replace$default((String)string, (String)"'", (String)"\\'", (boolean)false, (int)4, null);
            CompletionStage completionStage2 = this.connectionFuture.thenComposeAsync(arg_0 -> PostgreSQLConnection.connect$lambda-2(appName, arg_0), this.getConfiguration().getExecutionContext());
            completionStage = completionStage2;
            Intrinsics.checkNotNullExpressionValue((Object)completionStage2, (String)"{\n            val appNam\u2026ecutionContext)\n        }");
        }
        return completionStage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<Connection> disconnect() {
        void $this$mapAsync$iv;
        CompletableFuture<PostgreSQLConnectionHandler> completableFuture = this.connectionHandler.disconnect().toCompletableFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"this.connectionHandler.d\u2026t().toCompletableFuture()");
        CompletableFuture<PostgreSQLConnectionHandler> completableFuture2 = completableFuture;
        Executor executor$iv = this.getConfiguration().getExecutionContext();
        boolean $i$f$mapAsync = false;
        CompletionStage completionStage = $this$mapAsync$iv.thenApplyAsync(new Function(this){
            final /* synthetic */ PostgreSQLConnection this$0;
            {
                this.this$0 = postgreSQLConnection;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object it) {
                PostgreSQLConnectionHandler c = (PostgreSQLConnectionHandler)((Object)it);
                boolean bl = false;
                return this.this$0;
            }
        }, executor$iv);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"crossinline f: (A) -> B\n\u2026tion { f(it) }, executor)");
        return completionStage;
    }

    private final void onQueryTimeout() {
        this.disconnect();
    }

    private final void onCreateTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler.isConnected();
    }

    public boolean isTimeout() {
        return this.queryTimeoutSchedulerImpl.isTimeout();
    }

    public boolean isQuerying() {
        return this.queryPromise().isPresent();
    }

    @Nullable
    public Throwable lastException() {
        return this.lastException;
    }

    @NotNull
    public final Map<String, String> parameterStatuses() {
        return MapsKt.toMap(this.parameterStatus);
    }

    @NotNull
    public CompletableFuture<QueryResult> sendQueryDirect(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        PostgreSQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<Object>(this, query){
            final /* synthetic */ PostgreSQLConnection this$0;
            final /* synthetic */ String $query;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "sendQueryDirect - " + PostgreSQLConnection.access$getConnectionId$p(this.this$0) + ' ' + this.$query;
            }
        });
        this.validateQuery(query);
        CompletableFuture<QueryResult> promise = new CompletableFuture<QueryResult>();
        this.setQueryPromise(promise);
        this.write(new QueryMessage(query));
        this.queryTimeoutSchedulerImpl.addTimeout(promise, this.getConfiguration().getQueryTimeout(), this.connectionId);
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatementDirect(@NotNull PreparedStatementParams params) {
        PreparedStatementMessage preparedStatementMessage;
        PreparedStatementHolder holder;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        PostgreSQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<Object>(this, params){
            final /* synthetic */ PostgreSQLConnection this$0;
            final /* synthetic */ PreparedStatementParams $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "sendPreparedStatementDirect - " + PostgreSQLConnection.access$getConnectionId$p(this.this$0) + ' ' + this.$params;
            }
        });
        this.validateQuery(params.getQuery());
        CompletableFuture<QueryResult> promise = new CompletableFuture<QueryResult>();
        this.setQueryPromise(promise);
        Map<String, PreparedStatementHolder> map2 = this.parsedStatements;
        String key$iv = params.getQuery();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PreparedStatementHolder answer$iv = new PreparedStatementHolder(params.getQuery(), null, 2, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((holder = (PreparedStatementHolder)object).getParamsCount() != CollectionsUtilsKt.getLength((Collection)params.getValues())) {
            this.clearQueryPromise();
            throw new InsufficientParametersException(holder.getParamsCount(), params.getValues());
        }
        Optional<PreparedStatementHolder> optional = Optional.of(holder);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(holder)");
        this.currentPreparedStatement = optional;
        Optional<MutableResultSet> optional2 = Optional.of(new MutableResultSet(holder.getColumnDatas(), null, 2, null));
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(MutableResultSet(holder.columnDatas))");
        this.currentQuery = optional2;
        if (holder.getPrepared()) {
            preparedStatementMessage = new PreparedStatementExecuteMessage(holder.getStatementId(), holder.getRealQuery(), params.getValues(), this.encoderRegistry);
        } else {
            holder.setPrepared(true);
            preparedStatementMessage = new PreparedStatementOpeningMessage(holder.getStatementId(), holder.getRealQuery(), params.getValues(), this.encoderRegistry);
        }
        this.write(preparedStatementMessage);
        this.queryTimeoutSchedulerImpl.addTimeout(promise, this.getConfiguration().getQueryTimeout(), this.connectionId);
        CompletableFuture closedPromise = this.releaseIfNeeded(params.getRelease(), promise, params.getQuery());
        return closedPromise;
    }

    @Override
    public void onError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.setErrorOnFutures(throwable);
    }

    public boolean hasRecentError() {
        return this.recentError;
    }

    private final void setErrorOnFutures(Throwable e) {
        this.lastException = e;
        this.recentError = true;
        PostgreSQLConnectionKt.access$getLogger$p().error("Error on connection", e);
        if (!FutureUtilsKt.isCompleted(this.connectionFuture)) {
            FutureUtilsKt.failed(this.connectionFuture, (Throwable)e);
            this.disconnect();
        }
        this.currentPreparedStatement.map(arg_0 -> PostgreSQLConnection.setErrorOnFutures$lambda-5(this, arg_0));
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        this.currentPreparedStatement = optional;
        this.failQueryPromise(e);
    }

    @Override
    public void onReadyForQuery() {
        FutureUtilsKt.success(this.connectionFuture, (Object)this);
        this.recentError = false;
        this.queryResult.ifPresent(arg_0 -> PostgreSQLConnection.onReadyForQuery$lambda-6(this, arg_0));
    }

    @Override
    public void onError(@NotNull ErrorMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PostgreSQLConnectionKt.access$getLogger$p().error("Error , message -> {}", (Object)message);
        GenericDatabaseException error = new GenericDatabaseException(message);
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(@NotNull CommandCompleteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        this.currentPreparedStatement = optional;
        MutableResultSet mutableResultSet = this.currentQuery.orElse(null);
        ResultSet resultSet = mutableResultSet == null ? ResultSetKt.getEMPTY_RESULT_SET() : (ResultSet)mutableResultSet;
        Optional<QueryResult> optional2 = Optional.of(new QueryResult((long)message.getRowsAffected(), message.getStatusMessage(), resultSet));
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(QueryResult(message.r\u2026tatusMessage, resultSet))");
        this.queryResult = optional2;
    }

    @Override
    public void onParameterStatus(@NotNull ParameterStatusMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.parameterStatus.put(message.getKey(), message.getValue());
        if (Intrinsics.areEqual((Object)ServerVersionKey, (Object)message.getKey())) {
            this.version = VersionKt.parseVersion((String)message.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataRow(@NotNull DataRowMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int n = message.getValues().length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2 = i;
            Object[] objectArray2 = objectArray;
            int n3 = n2;
            ByteBuf buf = message.getValues()[n2];
            if (buf == null) {
                object = null;
            } else {
                Object object2;
                int n4 = n3;
                Object[] objectArray3 = objectArray2;
                try {
                    objectArray2 = objectArray3;
                    n3 = n4;
                    PostgreSQLColumnData columnType = (PostgreSQLColumnData)this.currentQuery.get().getColumnTypes().get(n2);
                    object2 = this.decoderRegistry.decode((ColumnData)columnType, buf, this.getConfiguration().getCharset());
                }
                finally {
                    buf.release();
                }
                object = object2;
            }
            objectArray2[n3] = object;
        }
        Object[] items = objectArray;
        this.currentQuery.get().addRow(items);
    }

    @Override
    public void onRowDescription(@NotNull RowDescriptionMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Optional<MutableResultSet> optional = Optional.of(new MutableResultSet(message.getColumnDatas(), null, 2, null));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(MutableResultSet(message.columnDatas))");
        this.currentQuery = optional;
        this.setColumnDatas(message.getColumnDatas());
    }

    private final void setColumnDatas(List<PostgreSQLColumnData> columnDatas) {
        this.currentPreparedStatement.ifPresent(arg_0 -> PostgreSQLConnection.setColumnDatas$lambda-7(columnDatas, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onAuthenticationResponse(@NotNull AuthenticationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        AuthenticationMessage authenticationMessage = message;
        if (authenticationMessage instanceof AuthenticationOkMessage) {
            PostgreSQLConnectionKt.access$getLogger$p().debug("Successfully logged in to database");
            this.authenticated = true;
        } else if (authenticationMessage instanceof AuthenticationCleartextPasswordMessage) {
            this.write(this.createPasswordMessage((AuthenticationSimpleChallenge)message));
        } else if (authenticationMessage instanceof AuthenticationMD5PasswordMessage) {
            this.write(this.createPasswordMessage((AuthenticationSimpleChallenge)message));
        } else if (authenticationMessage instanceof AuthenticationSASLMessage) {
            void it;
            Collection $this$toTypedArray$iv = ((AuthenticationSASLMessage)message).getSupportedSASLMechanisms();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ScramSession scramSession = thisCollection$iv.toArray(new String[0]);
            if (scramSession == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            ScramSession scramSession2 = scramSession;
            ScramClient scramClient = ScramClient.channelBinding((ScramClient.ChannelBinding)ScramClient.ChannelBinding.NO).stringPreparation((StringPreparation)StringPreparations.NO_PREPARATION).selectMechanismBasedOnServerAdvertised(Arrays.copyOf(scramSession2, ((String[])scramSession2).length)).setup();
            scramSession2 = scramClient.scramSession("*");
            $this$toTypedArray$iv = scramSession2;
            PostgreSQLConnection postgreSQLConnection = this;
            boolean bl = false;
            String string = scramClient.getScramMechanism().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scramClient.scramMechanism.name");
            String string2 = it.clientFirstMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.clientFirstMessage()");
            this.write(new SASLInitialResponse(string, string2));
            postgreSQLConnection.scramSession = scramSession2;
        } else if (authenticationMessage instanceof AuthenticationSASLContinueMessage) {
            void it;
            ScramSession.ClientFinalProcessor clientFinalProcessor;
            ScramSession scramSession = this.scramSession;
            if (scramSession == null) {
                throw new AuthenticationException("Received a SASL continue message before the initial message");
            }
            ScramSession scramSession3 = scramSession;
            String string = this.getConfiguration().getPassword();
            if (string == null) {
                throw new MissingCredentialInformationException(this.getConfiguration().getUsername(), this.getConfiguration().getPassword());
            }
            String password = string;
            ScramSession.ServerFirstProcessor serverFirstProcessor = scramSession3.receiveServerFirstMessage(((AuthenticationSASLContinueMessage)message).getSaslData());
            ScramSession.ClientFinalProcessor thisCollection$iv = clientFinalProcessor = serverFirstProcessor.clientFinalProcessor(password);
            PostgreSQLConnection postgreSQLConnection = this;
            boolean bl = false;
            String string3 = it.clientFinalMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.clientFinalMessage()");
            this.write(new SASLResponse(string3));
            postgreSQLConnection.scramClientFinalProcessor = clientFinalProcessor;
        } else if (authenticationMessage instanceof AuthenticationSASLFinalMessage) {
            try {
                ScramSession.ClientFinalProcessor clientFinalProcessor = this.scramClientFinalProcessor;
                if (clientFinalProcessor == null) {
                    throw new AuthenticationException("Received a SASL final message before the continue message");
                }
                clientFinalProcessor.receiveServerFinalMessage(((AuthenticationSASLFinalMessage)message).getSaslData());
            }
            catch (ScramException e) {
                throw new AuthenticationException("Server failed SCRAM validation", e);
            }
        }
    }

    @Override
    public void onNotificationResponse(@NotNull NotificationResponse message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterator<Function1<NotificationResponse, Unit>> iterator = this.notifyListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().invoke((Object)message);
        }
    }

    public final void registerNotifyListener(@NotNull Function1<? super NotificationResponse, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.notifyListeners.add(listener);
    }

    public final void unregisterNotifyListener(@NotNull Function1<? super NotificationResponse, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.notifyListeners.remove(listener);
    }

    public final void clearNotifyListeners() {
        this.notifyListeners.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final PasswordMessage createPasswordMessage(AuthenticationSimpleChallenge authenticationMessage) {
        void it;
        AuthenticationMD5PasswordMessage authenticationMD5PasswordMessage;
        if (this.getConfiguration().getPassword() == null) {
            throw new MissingCredentialInformationException(this.getConfiguration().getUsername(), this.getConfiguration().getPassword());
        }
        String string = this.getConfiguration().getUsername();
        String string2 = this.getConfiguration().getPassword();
        Intrinsics.checkNotNull((Object)string2);
        AuthenticationSimpleChallenge authenticationSimpleChallenge = authenticationMessage;
        String string3 = string2;
        String string4 = string;
        boolean bl = false;
        AuthenticationMD5PasswordMessage authenticationMD5PasswordMessage2 = authenticationMD5PasswordMessage = it instanceof AuthenticationMD5PasswordMessage ? (AuthenticationMD5PasswordMessage)it : null;
        byte[] byArray = (byte[])(authenticationMD5PasswordMessage2 != null ? authenticationMD5PasswordMessage2.getSalt() : null);
        String string5 = string3;
        String string6 = string4;
        return new PasswordMessage(string6, string5, byArray);
    }

    private final void notReadyForQueryError(String errorMessage, boolean race) {
        PostgreSQLConnectionKt.access$getLogger$p().error(errorMessage);
        throw new ConnectionStillRunningQueryException(this.getId(), race);
    }

    public final void validateIfItIsReadyForQuery(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (this.queryPromise().isPresent()) {
            this.notReadyForQueryError(errorMessage, false);
        }
    }

    private final void validateQuery(String query) {
        if (!this.isConnected()) {
            throw new IllegalStateException("not connected so can't execute queries. please make sure connect() was called and disconnect() was not called.");
        }
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        if (((CharSequence)query).length() == 0) {
            throw new QueryMustNotBeNullOrEmptyException(query);
        }
    }

    private final Optional<CompletableFuture<QueryResult>> queryPromise() {
        Optional<CompletableFuture<QueryResult>> optional = this.queryPromiseReference.get();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"queryPromiseReference.get()");
        return optional;
    }

    private final void setQueryPromise(CompletableFuture<QueryResult> promise) {
        if (!this.queryPromiseReference.compareAndSet(Optional.empty(), Optional.of(promise))) {
            this.notReadyForQueryError("Can't run query due to a race , another started query", true);
        }
    }

    private final Optional<CompletableFuture<QueryResult>> clearQueryPromise() {
        Optional<CompletableFuture<QueryResult>> optional = this.queryPromiseReference.getAndSet(Optional.empty());
        Intrinsics.checkNotNullExpressionValue(optional, (String)"this.queryPromiseReferen\u2026tAndSet(Optional.empty())");
        return optional;
    }

    private final void failQueryPromise(Throwable t) {
        this.clearQueryPromise().ifPresent(arg_0 -> PostgreSQLConnection.failQueryPromise$lambda-11(t, arg_0));
    }

    private final void succeedQueryPromise(QueryResult result) {
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        this.queryResult = optional;
        Optional optional2 = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty()");
        this.currentQuery = optional2;
        this.clearQueryPromise().ifPresent(arg_0 -> PostgreSQLConnection.succeedQueryPromise$lambda-12(result, arg_0));
    }

    private final void write(ClientMessage message) {
        this.connectionHandler.write(message);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{counter=" + this.currentCount + '}';
    }

    @NotNull
    public CompletableFuture<Boolean> releasePreparedStatement(@NotNull String query) {
        CompletionStage completionStage;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (this.closeStatementReference.get().isPresent()) {
            PendingCloseStatementException exception = new PendingCloseStatementException("There is already another close operation pending, your query was [" + query + ']');
            exception.fillInStackTrace();
            return FP.INSTANCE.failed((Throwable)((Object)exception));
        }
        this.validateIfItIsReadyForQuery("You can't close a prepared statement if we're still running a query");
        PreparedStatementHolder statement = this.parsedStatements.get(query);
        if (statement != null) {
            this.write(new PreparedStatementCloseMessage(statement.getStatementId(), false, 2, null));
            Optional<PreparedStatementHolder> optional = Optional.of(statement);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(statement)");
            this.currentPreparedStatement = optional;
            CompletableFuture promise = new CompletableFuture();
            this.closeStatementReference.set(Optional.of(promise));
            CompletableFuture $this$map$iv = promise;
            boolean $i$f$map = false;
            CompletionStage completionStage2 = $this$map$iv.thenApply(new Function(this, query){
                final /* synthetic */ PostgreSQLConnection this$0;
                final /* synthetic */ String $query$inlined;
                {
                    this.this$0 = postgreSQLConnection;
                    this.$query$inlined = string;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object apply(Object it) {
                    PreparedStatementHolder it2 = (PreparedStatementHolder)it;
                    boolean bl = false;
                    PostgreSQLConnection.access$getParsedStatements$p(this.this$0).remove(this.$query$inlined);
                    PostgreSQLConnection.access$getCloseStatementReference$p(this.this$0).set(Optional.empty());
                    return true;
                }
            });
            completionStage = completionStage2;
            Intrinsics.checkNotNullExpressionValue((Object)completionStage2, (String)"crossinline f: (A) -> B)\u2026=\n    thenApply { f(it) }");
        } else {
            completionStage = FP.INSTANCE.successful((Object)false);
        }
        return completionStage;
    }

    @Override
    public void onCloseComplete() {
        this.closeStatementReference.get().ifPresent(arg_0 -> PostgreSQLConnection.onCloseComplete$lambda-15(this, arg_0));
    }

    @JvmOverloads
    public PostgreSQLConnection(@NotNull Configuration configuration, @NotNull ColumnEncoderRegistry encoderRegistry, @NotNull ColumnDecoderRegistry decoderRegistry) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)encoderRegistry, (String)"encoderRegistry");
        Intrinsics.checkNotNullParameter((Object)decoderRegistry, (String)"decoderRegistry");
        this(configuration, encoderRegistry, decoderRegistry, null, 8, null);
    }

    @JvmOverloads
    public PostgreSQLConnection(@NotNull Configuration configuration, @NotNull ColumnEncoderRegistry encoderRegistry) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)encoderRegistry, (String)"encoderRegistry");
        this(configuration, encoderRegistry, null, null, 12, null);
    }

    @JvmOverloads
    public PostgreSQLConnection(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this(configuration, null, null, null, 14, null);
    }

    @JvmOverloads
    public PostgreSQLConnection() {
        this(null, null, null, null, 15, null);
    }

    private static final PostgreSQLConnection connect$lambda-2$lambda-1(PostgreSQLConnection $conn, QueryResult it) {
        return $conn;
    }

    private static final CompletableFuture connect$lambda-2(String $appName, PostgreSQLConnection conn) {
        Intrinsics.checkNotNullParameter((Object)$appName, (String)"$appName");
        return conn.sendQuery("set application_name=E'" + $appName + '\'').thenApply(arg_0 -> PostgreSQLConnection.connect$lambda-2$lambda-1(conn, arg_0));
    }

    private static final PreparedStatementHolder setErrorOnFutures$lambda-5(PostgreSQLConnection this$0, PreparedStatementHolder p) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.parsedStatements.remove(p.getQuery());
    }

    private static final void onReadyForQuery$lambda-6(PostgreSQLConnection this$0, QueryResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.succeedQueryPromise(it);
    }

    private static final void setColumnDatas$lambda-7(List $columnDatas, PreparedStatementHolder holder) {
        Intrinsics.checkNotNullParameter((Object)$columnDatas, (String)"$columnDatas");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        holder.setColumnDatas($columnDatas);
    }

    private static final void failQueryPromise$lambda-11(Throwable $t, CompletableFuture promise) {
        Intrinsics.checkNotNullParameter((Object)$t, (String)"$t");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        PostgreSQLConnectionKt.access$getLogger$p().error("Setting error on future {}", (Object)promise);
        FutureUtilsKt.failed((CompletableFuture)promise, (Throwable)$t);
    }

    private static final void succeedQueryPromise$lambda-12(QueryResult $result, CompletableFuture it) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FutureUtilsKt.success((CompletableFuture)it, (Object)$result);
    }

    private static final void onCloseComplete$lambda-15$lambda-14(CompletableFuture $reference, PreparedStatementHolder statement) {
        Intrinsics.checkNotNullParameter((Object)$reference, (String)"$reference");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        FutureUtilsKt.success((CompletableFuture)$reference, (Object)statement);
    }

    private static final void onCloseComplete$lambda-15(PostgreSQLConnection this$0, CompletableFuture reference) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        this$0.currentPreparedStatement.ifPresent(arg_0 -> PostgreSQLConnection.onCloseComplete$lambda-15$lambda-14(reference, arg_0));
    }

    public static final /* synthetic */ String access$getConnectionId$p(PostgreSQLConnection $this) {
        return $this.connectionId;
    }

    public static final /* synthetic */ CompletableFuture access$getConnectionFuture$p(PostgreSQLConnection $this) {
        return $this.connectionFuture;
    }

    public static final /* synthetic */ Map access$getParsedStatements$p(PostgreSQLConnection $this) {
        return $this.parsedStatements;
    }

    public static final /* synthetic */ AtomicReference access$getCloseStatementReference$p(PostgreSQLConnection $this) {
        return $this.closeStatementReference;
    }

    public static final /* synthetic */ void access$onQueryTimeout(PostgreSQLConnection $this) {
        $this.onQueryTimeout();
    }

    public static final /* synthetic */ void access$onCreateTimeout(PostgreSQLConnection $this) {
        $this.onCreateTimeout();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/postgresql/PostgreSQLConnection$Companion;", "", "()V", "Counter", "Ljava/util/concurrent/atomic/AtomicLong;", "getCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "ServerVersionKey", "", "getServerVersionKey", "()Ljava/lang/String;", "jasync-postgresql"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicLong getCounter() {
            return Counter;
        }

        @NotNull
        public final String getServerVersionKey() {
            return ServerVersionKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

