/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.parsers;

import com.github.jasync.sql.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ServerMessage;
import com.github.jasync.sql.db.postgresql.parsers.MessageParser;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/postgresql/parsers/CommandCompleteParser;", "Lcom/github/jasync/sql/db/postgresql/parsers/MessageParser;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "parseMessage", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ServerMessage;", "buffer", "Lio/netty/buffer/ByteBuf;", "jasync-postgresql"})
public final class CommandCompleteParser
implements MessageParser {
    @NotNull
    private final Charset charset;

    public CommandCompleteParser(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    @Override
    @NotNull
    public ServerMessage parseMessage(@NotNull ByteBuf buffer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        String result = ByteBufferUtils.readCString((ByteBuf)buffer, (Charset)this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        int indexOfRowCount = StringsKt.lastIndexOf$default((CharSequence)result, (String)" ", (int)0, (boolean)false, (int)6, null);
        if (indexOfRowCount == -1) {
            n = 0;
        } else {
            int n2;
            try {
                String string = result.substring(indexOfRowCount);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                n2 = Integer.parseInt(((Object)StringsKt.trim((CharSequence)string)).toString());
            }
            catch (NumberFormatException e) {
                n2 = 0;
            }
            n = n2;
        }
        int rowCount = n;
        return new CommandCompleteMessage(rowCount, result);
    }
}

