/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.ReferenceToken;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.PathValueOperation;
import com.google.common.collect.Iterables;

public final class AddOperation
extends PathValueOperation {
    private static final ReferenceToken LAST_ARRAY_ELEMENT = ReferenceToken.fromRaw((String)"-");

    @JsonCreator
    public AddOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super("add", path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return this.value;
        }
        JsonNode parentNode = (JsonNode)this.path.parent().path((TreeNode)node);
        if (parentNode.isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchParent"));
        }
        if (!parentNode.isContainerNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.parentNotContainer"));
        }
        return parentNode.isArray() ? this.addToArray(this.path, node) : this.addToObject(this.path, node);
    }

    private JsonNode addToArray(JsonPointer path, JsonNode node) throws JsonPatchException {
        int index;
        JsonNode ret = node.deepCopy();
        ArrayNode target = (ArrayNode)path.parent().get((TreeNode)ret);
        TokenResolver token = (TokenResolver)Iterables.getLast((Iterable)path);
        if (token.getToken().equals((Object)LAST_ARRAY_ELEMENT)) {
            target.add(this.value);
            return ret;
        }
        int size = target.size();
        try {
            index = Integer.parseInt(token.toString());
        }
        catch (NumberFormatException ignored) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.notAnIndex"));
        }
        if (index < 0 || index > size) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchIndex"));
        }
        target.insert(index, this.value);
        return ret;
    }

    private JsonNode addToObject(JsonPointer path, JsonNode node) {
        JsonNode ret = node.deepCopy();
        ObjectNode target = (ObjectNode)path.parent().get((TreeNode)ret);
        target.set(((TokenResolver)Iterables.getLast((Iterable)path)).getToken().getRaw(), this.value);
        return ret;
    }
}

