/*
 * Decompiled with CFR 0.152.
 */
package org.jmicrostack.karaf.python.tracker;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;

public class BundleTrackerInfo {
    public static String stateAsString(Bundle bundle) {
        if (bundle == null) {
            return "null";
        }
        int state = bundle.getState();
        switch (state) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return "unknown bundle state: " + state;
    }

    public static String eventAsString(BundleEvent event) {
        if (event == null) {
            return "null";
        }
        int type = event.getType();
        switch (type) {
            case 1: {
                return "INSTALLED";
            }
            case 512: {
                return "LAZY_ACTIVATION";
            }
            case 32: {
                return "RESOLVED";
            }
            case 2: {
                return "STARTED";
            }
            case 128: {
                return "Starting";
            }
            case 4: {
                return "STOPPED";
            }
            case 16: {
                return "UNINSTALLED";
            }
            case 64: {
                return "UNRESOLVED";
            }
            case 8: {
                return "UPDATED";
            }
        }
        return "unknown event type: " + type;
    }
}

