/*
 * Decompiled with CFR 0.152.
 */
package org.jmicrostack.karaf.python.tracker;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.jmicrostack.karaf.python.PythonResource;
import org.jmicrostack.karaf.python.tracker.BundleListenerInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonListenerActivator
implements BundleActivator,
BundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonListenerActivator.class);
    private HashMap pythonBundle = new HashMap();

    /*
     * Enabled aggressive block sorting
     */
    public void bundleChanged(BundleEvent event) {
        String bundleKey;
        block6: {
            URL pythonResource;
            block7: {
                bundleKey = event.getBundle().getSymbolicName() + ":" + event.getBundle().getVersion().toString();
                LOGGER.info("Process module <" + BundleListenerInfo.typeAsString(event) + ">: " + bundleKey);
                if (event.getBundle() == null) break block6;
                if (event.getType() == 1) break block7;
                if (event.getType() != 8) break block6;
            }
            if ((pythonResource = event.getBundle().getResource("python")) == null) return;
            if (event.getType() == 1) {
                LOGGER.info("Python install module: " + bundleKey);
            } else {
                LOGGER.info("Python update module: " + bundleKey);
            }
            this.pythonBundle.put(bundleKey, event.getBundle());
            this.installPythonResource(event.getBundle());
            return;
        }
        if (event.getType() != 16) return;
        LOGGER.info("Python uninstall module: " + bundleKey);
        if (this.pythonBundle.containsKey(bundleKey)) {
            this.pythonBundle.remove(bundleKey);
        }
        this.uninstallPythonResource(event.getBundle());
    }

    public void start(BundleContext context) throws Exception {
        LOGGER.info("Python listener START");
        context.addBundleListener((BundleListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        LOGGER.info("Python listener STOP");
        context.removeBundleListener((BundleListener)this);
    }

    private void installPythonResource(Bundle bundle) {
        PythonResource pyRes = new PythonResource();
        try {
            pyRes.unpack(bundle);
        }
        catch (IOException e) {
            LOGGER.error(e.toString());
            e.printStackTrace();
            try {
                bundle.stop();
            }
            catch (BundleException e1) {
                LOGGER.error(e.toString());
                e.printStackTrace();
            }
        }
    }

    private void uninstallPythonResource(Bundle bundle) {
        PythonResource pyRes = new PythonResource();
        pyRes.remove(bundle);
    }
}

