/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonatino.process;

import com.github.jonatino.misc.Cacheable;
import com.github.jonatino.misc.MemoryBuffer;
import com.github.jonatino.process.DataSource;
import com.github.jonatino.process.Process;
import com.sun.jna.Pointer;

public final class Module
implements DataSource {
    private final Process process;
    private final String name;
    private final long address;
    private final int size;
    private final Pointer pointer;
    private MemoryBuffer data;

    public Module(Process process, String name, Pointer pointer, long size) {
        this.process = process;
        this.name = name;
        this.address = Pointer.nativeValue((Pointer)pointer);
        this.size = (int)size;
        this.pointer = pointer;
    }

    public Process process() {
        return this.process;
    }

    public Pointer pointer() {
        return this.pointer;
    }

    public String name() {
        return this.name;
    }

    public int size() {
        return this.size;
    }

    public long address() {
        return this.address;
    }

    public MemoryBuffer data() {
        return this.data(false);
    }

    public MemoryBuffer data(boolean forceNew) {
        return this.data == null || forceNew ? (this.data = this.process().read(this.address, this.size())) : this.data;
    }

    @Override
    public MemoryBuffer read(Pointer offset, int size, MemoryBuffer toBuffer) {
        return this.process().read(Cacheable.pointer(this.address() + Pointer.nativeValue((Pointer)offset)), size, toBuffer);
    }

    @Override
    public Process write(Pointer offset, MemoryBuffer buffer) {
        return this.process().write(Cacheable.pointer(this.address() + Pointer.nativeValue((Pointer)offset)), buffer);
    }

    @Override
    public boolean canRead(Pointer offset, int size) {
        return this.process().canRead(Cacheable.pointer(this.address() + Pointer.nativeValue((Pointer)offset)), size);
    }

    public String toString() {
        return "Module{name='" + this.name + '\'' + ", address=" + this.address + ", size=" + this.size + '}';
    }
}

